/************************************************************************
* MOUSE4.C -- demonstrate how to alter the graphics mouse cursor.		 *
* This program changes cursor styles, depending on which side of the	 *
* screen the cursor is.												 *
*																		 *
* To compile: "cl mouse4.c /link graphics"								 *
************************************************************************/

#include <dos.h>	/* int86(), union REGS								*/
#include <conio.h>	/* kbhit()											*/
#include <graph.h>	/* _DEFAULTMODE, _ellipse(), _GFILLINTERIOR,		*/
					/* _MRES16COLOR, _setcolor(), _setvideomode()		*/
#include <stdio.h>	/* printf()											*/
#include <stdlib.h>/* exit(), EXIT_FAILURE, EXIT_SUCCESS				*/

void main(void)
	{
	union REGS in_regs, out_regs;

	/* The right hand mouse cursor is a block */
	unsigned right_mouse_cursor[] =
		{
		/* Screen mask */
		0xffff,		0xffff,		0xffff,		0xffff,
		0xffff,		0xffff,		0xffff,		0xffff,
		0xffff,		0xffff,		0xffff,		0xffff,
		0xffff,		0xffff,		0xffff,		0xffff,
		/* Cursor mask */
		0xffff,		0xffff,		0xffff,		0xffff,
		0xffff,		0xffff,		0xffff,		0xffff,
		0xffff,		0xffff,		0xffff,		0xffff,
		0xffff,		0xffff,		0xffff,		0xffff,
		};
	unsigned char NewFillMask[]=
		{ 0x00, 0x55, 0x00, 0xaa, 0x00, 0x55, 0x00, 0xaa };

	/* The left side mouse cursor is a crosshair */
	unsigned left_mouse_cursor[] = 
		{
		/* Screen mask */
		0xfcff,		0xfcff,		0xfcff,		0xfcff,
		0xfcff,		0xfcff,		0xfcff,		0x0003,
		0x0003,		0xfcff,		0xfcff,		0xfcff,
		0xfcff,		0xfcff,		0xfcff,		0xfcff,
		/* Cursor mask */
		0x0300,		0x0300,		0x0300,		0x0300,
		0x0300,		0x0300,		0x0300,		0xfcfc,
		0xfcfc,		0x0300,		0x0300,		0x0300,
		0x0300,		0x0300,		0x0300,		0x0300,
		};

	/* Set the CRT to four color mode, and draw a cyan ellipse	*/
	_setvideomode(_MRES4COLOR);
	_selectpalette(1);
	_setcolor(1);
	_ellipse(_GFILLINTERIOR, 25, 25, 180, 100);
	_setcolor(2);
	_setfillmask(NewFillMask);
	_rectangle(_GBORDER, 100, 110, 200, 190);
	_rectangle(_GFILLINTERIOR, 100, 110, 200, 190);

	/* Initialize the mouse */
	in_regs.x.ax = 0;
	int86(0x33, &in_regs, &out_regs);
	if (!out_regs.x.ax)
		{
		printf("ERROR - Mouse could not be initialized.\n");
		exit(EXIT_FAILURE);
		}
	printf("Mouse initialized.\n");

	/* Display the mouse cursor */
	in_regs.x.ax = 1;
	int86(0x33, &in_regs, &out_regs);

	printf("Type a 'q' to quit.");
	while ( !kbhit() )
		{
		/* Get the current mouse information */
		in_regs.x.ax = 3;
		int86(0x33, &in_regs, &out_regs);

		/* Set the appropriate mouse cursor */
		if (out_regs.x.cx < 320)
			/* If mouse is on left half of screen use left mouse cursor	*/
			in_regs.x.dx = (int) left_mouse_cursor;
		else
			/* Otherwise, use the right side mouse cursor */
			in_regs.x.dx = (int) right_mouse_cursor;
		in_regs.x.bx = 0;
		in_regs.x.cx = 0;
		in_regs.x.ax = 9;
		int86(0x33, &in_regs, &out_regs);
	}

	/* Clear the keyboard buffer, reset the display, and quit	*/
	while ( kbhit() )
		getch();
	_setvideomode(_DEFAULTMODE);
	exit(EXIT_SUCCESS);
	}
