/****************************************************************
* TIMER.C -- This program times the execution of a function		*
* "testfunc" which contains the code to be timed				*
*																*
* To compile: "cl /Ox TIMER.C /Od TEST.C"						*
* Where you supply TEST.C (with the "emptyfunc" and "testfunc"	*
* functions).													*
* RHS 9/17/90													*
****************************************************************/
#include <time.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>

#define DEF_ITERATIONS   100000L
#define TRUE 1
#define FALSE 0

void testfunc(void);
void emptyfunc(void);
void cdecl main(int argc, char **argv);

void cdecl main(int argc, char **argv)
    {
    long start=0L, end=0L, control_start=0L, control_end=0L;
    unsigned long iterations, setting =  DEF_ITERATIONS;
    unsigned def = FALSE;
    float test,empty,op;

    if(argc < 2)
        def = TRUE;
    else
        {
        if(!atol(argv[1]))
            def = TRUE;
        else
            setting = atol(argv[1]);
        }

    if(def)
        printf("Testing with default iterations: %lu\n",setting);
    else
        printf("Testing with %lu iterations\n",setting);

    puts("Timing empty function...");
    iterations = setting;
    control_start = clock();
    for( ; iterations; iterations--)
        emptyfunc();
    control_end = clock();
    empty = (float)(control_end-control_start);
    empty /= CLK_TCK;

    puts("Testing code...");
    iterations = setting;
    start = clock();
    for( ; iterations; iterations--)
        testfunc();
    end = clock();
    test = (float)(end-start);
    test /= CLK_TCK;
    op = (test-empty);

    printf("Test end:\n");
    printf("          Test required: %04.02f seconds\n",test);
    printf("Empty function required: %04.02f \n",empty);
    printf("Operation test required: %04.02f \n",op);
    }
