#include <math.h>
#include <string.h>
#include <stdio.h>

#include "bmp.h"

const char editmap :: mode_s = 'S' ;
const char editmap :: mode_x = 'X' ;
const char *editmap :: mode_str = "MODE:%c" ;

editmap :: editmap ( int wd, int hg, char *fn ) :
win( 0, 0, fg.displaybox[FG_X2], fg.displaybox[FG_Y2], FG_WHITE,
	FG_BLACK, NULL, 19, 2 ), w( wd ), h( hg ), draw_func( draw_pixel ),
	filename( fn ), clipb( NULL )
{
#define MOSTLENGTH	13
#define MOSTLENGTHP1	14
#define MOSTLENGTHP2	15

	int i ;
	fg_coord_t k ;

	bits = alloc_array( w, h ) ;
	mode = new char [MOSTLENGTH] ;
	func = new char [MOSTLENGTH] ;

	sprintf( mode, mode_str, mode_s ) ;

	for ( i = 0 ; i < w ; i++ )
		memset( bits[i], 0, h ) ;

	cellbox[FG_X1] = cellbox[FG_Y1] = 0 ;
	cellbox[FG_X2] =
		( fg.displaybox[FG_X2] -
			fg.charbox[FG_X2] * MOSTLENGTHP2 ) / w ;
	cellbox[FG_Y2] = ( fg.displaybox[FG_Y2] - fg.charbox[FG_Y2] * 2 ) / h ;

	fg_make_box( pix, -1, -1, -1, -1 ) ;
	fg_make_box( editbox, 0, 0, cellbox[FG_X2] * w, cellbox[FG_Y2] * h );
	editbox[FG_X1] += fg.charbox[FG_X2] ;
	editbox[FG_X2] += fg.charbox[FG_X2] ;
	editbox[FG_Y1] += fg.charbox[FG_Y2] ;
	editbox[FG_Y2] += fg.charbox[FG_Y2] ;

	kbd->add_script( 'q', destroy ) ;
	kbd->add_script( 'l', _set_draw_line ) ;
	kbd->add_script( 'p', _set_draw_pixel ) ;
	kbd->add_script( 'r', _redraw ) ;
	kbd->add_script( 'f', _set_floodfill ) ;
	kbd->add_script( 'c', _set_draw_circle ) ;
	kbd->add_script( 'e', _set_draw_ellipse ) ;
	kbd->add_script( 'b', _set_draw_box ) ;
	kbd->add_script( 'm', set_mode ) ;
	kbd->add_script( 'i', _set_invert_box ) ;
	kbd->add_script( 'a', _set_clear ) ;
	kbd->add_script( 'y', _set_copy ) ;
	kbd->add_script( 'u', _set_cut ) ;
	kbd->add_script( 'z', _set_paste ) ;
	kbd->add_script( 'x', byebye ) ;
	kbd->add_script( 's', save ) ;
	kbd->add_script( ',', _set_flip_x ) ;
	kbd->add_script( '.', _set_flip_y ) ;
	kbd->add_script( '\x1b', finish_func ) ;
	box->add_script( editbox, edit_map ) ;
	box->add_script( winbox, total_map ) ;
	k = fg.displaybox[FG_X2] - fg.charbox[FG_X2] * MOSTLENGTH ;
	fg_make_box( dispbox, k, fg.charbox[FG_Y2], k + w - 1,
		fg.charbox[FG_Y2] + h - 1 ) ;
#define ITEMS	24
	mu = new menu ( k, fg.displaybox[FG_Y2] - fg.charbox[FG_Y2] * ITEMS,
		MOSTLENGTH -  2, ITEMS, this ) ;

	strcpy( func, "PIXEL" ) ;
	mu->add_item( '\x0', "[P]ixel", _set_draw_pixel ) ;
	mu->add_item( '\x0', "[L]ine", _set_draw_line ) ;
	mu->add_item( '\x0', "[B]ox", _set_draw_box ) ;
	mu->add_item( '\x0', "[C]ircle", _set_draw_circle ) ;
	mu->add_item( '\x0', "[E]llipse", _set_draw_ellipse ) ;
	mu->add_item( '\x0', "[F]ill", _set_floodfill ) ;
	mu->add_item( '\x0', "[I]nvert", _set_invert_box ) ;
	mu->add_item( '\x0', "--------", NULL ) ;
	mu->add_item( '\x0', "Cop[Y]", _set_copy ) ;
	mu->add_item( '\x0', "C[U]t", _set_cut ) ;
	mu->add_item( '\x0', "Paste[Z]", _set_paste ) ;
	mu->add_item( '\x0', "Cle[A]r", _set_clear ) ;
	mu->add_item( '\x0', "--------", NULL ) ;
	mu->add_item( '\x0', "[M]ode", set_mode ) ;
	mu->add_item( '\x0', "[R]edraw", _redraw ) ;
	mu->add_item( '\x0', "FlipX[,]", _set_flip_x ) ;
	mu->add_item( '\x0', "FlipY[.]", _set_flip_y ) ;
	mu->add_item( '\x0', "--------", NULL ) ;
	mu->add_item( '\x0', "[S]ave", save ) ;
	mu->add_item( '\x0', "[Q]uit", destroy ) ;
	mu->add_item( '\x0', "e[X]it", byebye ) ;
	mu->add_item( '\x0', "--------", NULL ) ;	
	mu->add_item( '\x0', func, NULL ) ;
	mu->add_item( '\x0', mode, NULL ) ;
}

void editmap :: delete_array ( char **a, int w ) {

	if ( a ) {
		for ( int i = 0 ; i < w ; i++ )
			delete a[i] ;
		delete a ;
	}
}

char **editmap :: alloc_array ( int w, int h ) {

	char **x ;

	x = new char * [w] ;
	for ( int i = 0 ; i < w ; i++ )
		x[i] = new char [h] ;
	return x ;
}

void editmap :: realloc_array ( char ***x, int w, int h ) {

	if ( x )
		delete_array( *x, w ) ;
	*x = alloc_array( w, h ) ;
}

editmap :: ~editmap () {

	int i ;

	delete_array( bits, w ) ;
	delete_array( clipb, clip_w ) ;
	delete mode ;
}

void editmap :: byebye () { save() ; destroy() ; }

void editmap :: copymap ( char **b ) {

	int i, j ;

	for ( i = 0 ; i < w ; i++ )
		for ( j = 0 ; j < h ; j++ )
			bits[i][j] = b[i][j] ;
}

void editmap :: save () {

	FILE *f ;
	char *xn, *da ;
	char *defna = "Untitled" ;
	fg_box_t t ;
	int i, j, k, m, kda, msk ;

	if ( ( f = fopen( xn = filename, "wt" ) ) == NULL )
		if ( ( f = fopen( xn = defna, "wt" ) ) == NULL )
			return ;
	da = new char [w + 1] ;
	fg_make_box( t, 0, 0, w - 1, h - 1 ) ;
	fprintf( f, "fg_box_t %s_box = { 0, 0, %d, %d } ;\n", xn, w-1, h-1 ) ;
	fprintf( f, "char %s_matrix[%u] = {\n", xn, fg_matrix_size( t ) ) ;

	for ( i = 0 ; i < h ; i++ ) {
		fprintf( f, "\t" ) ;
		for ( j = 0 ; j < w ; j++ )
			da[j] = bits[j][h - i - 1] ? '#' : ' ' ;
		da[j] = 0 ;
		for ( k = 0 ; k < w ; k += 8 ) {
			msk = 0x80 ;
			for ( kda = 0, m = k ; m < k + 8 && m < w ; m++ ) {
				if ( bits[m][h - i - 1] )
					kda |= msk ;
				msk >>= 1 ;
			}
			fprintf(
				f, "0x%02x%c ",
				kda, k + 8 < w || i + 1 < h ? ',' : ' ' ) ;
		}
		fprintf( f,"\t/* %s */\n", da ) ;
	}
	fprintf( f, "} ;\n" ) ;
	fclose( f ) ;
	delete da ;
}		

fg_color_t editmap :: get_color () {
	return p_status == MSM_BUTTONL ? fgc : bgc ;
}

int editmap :: get_mode () {
	return mode[strlen(mode)-1] == mode_s ? FG_MODE_SET : FG_MODE_XOR ;
}

void editmap :: set_mode () {

	if ( get_mode() == FG_MODE_SET )
		sprintf( mode, mode_str, mode_x ) ;
	else
		sprintf( mode, mode_str, mode_s ) ;
	mu->expose() ;
}

void editmap :: getmspos () {

	p_status = msm_getstatus( &p_x, &p_y ) ;
	p_y = fg.displaybox[FG_Y2] + 1 - p_y ;	
}

void editmap :: translate () {

	p_x = ( p_x - editbox[FG_X1] ) / cellbox[FG_X2] ;
	p_y = ( p_y - editbox[FG_Y1] ) / cellbox[FG_Y2] ;
}

void editmap :: set_funcname ( eventscript_t e, char *n ) {

	draw_func = e ;
	finish_func() ;
	strcpy( func, n ) ;
	mu->expose() ;
}

void editmap :: _set_floodfill () { set_funcname( floodfill, "FILL" ) ; }

void editmap :: floodfill () {

	if ( pix[FG_X1] == -1 ) {
		msm_hidecursor() ;
		fg_fill( dispbox[FG_X1] + p_x, dispbox[FG_Y1] + p_y,
			get_color(), get_color() ) ;
		msm_showcursor() ;
		redraw( 0, 0, w - 1, h - 1 ) ;
		finish_func() ;
	}
}

void editmap :: _set_draw_line () { set_funcname( draw_line, "LINE" ) ; }

void editmap :: draw_line () {

	fg_coord_t x1, y1, x2, y2 ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		pix[FG_X2] = p_x ;
		pix[FG_Y2] = p_y ;
		pix[FG_X1] += dispbox[FG_X1] ;
		pix[FG_X2] += dispbox[FG_X1] ;
		pix[FG_Y1] += dispbox[FG_Y1] ;
		pix[FG_Y2] += dispbox[FG_Y1] ;
		msm_hidecursor() ;
		fg_drawlineclip( get_color(), get_mode(), ~0, FG_LINE_SOLID,
			pix, dispbox ) ;
		msm_showcursor() ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_draw_box () { set_funcname( draw_box, "BOX" ) ; }

void editmap :: draw_box () {

	fg_coord_t x1, y1, x2, y2 ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		pix[FG_X1] = dispbox[FG_X1] + x1 ;
		pix[FG_X2] = dispbox[FG_X1] + x2 ;
		pix[FG_Y1] = dispbox[FG_Y1] + y1 ;
		pix[FG_Y2] = dispbox[FG_Y1] + y2 ;
		msm_hidecursor() ;
		fg_drawbox( get_color(), get_mode(), ~0, FG_LINE_SOLID,
			pix, dispbox ) ;
		msm_showcursor() ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_invert_box () { set_funcname( invert_box, "INVERT" ) ; }

void editmap :: invert_box () {

	fg_coord_t x1, y1, x2, y2 ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		pix[FG_X1] = dispbox[FG_X1] + x1 ;
		pix[FG_X2] = dispbox[FG_X1] + x2 ;
		pix[FG_Y1] = dispbox[FG_Y1] + y1 ;
		pix[FG_Y2] = dispbox[FG_Y1] + y2 ;
		msm_hidecursor() ;
		fg_fillbox( get_color(), FG_MODE_XOR, ~0, pix ) ;
		msm_showcursor() ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_flip_x () { set_funcname( flip_x, "FLIP X" ) ; }

void editmap :: flip_x () {

	fg_coord_t x1, y1, x2, y2, w, h, i, j ;
	char **buf ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		w = x2 - x1 + 1 ;
		h = y2 - y1 + 1 ;
		buf = alloc_array( w, h ) ;
		for ( i = 0 ; i < w ; i++ )
			for ( j = 0 ; j < h ; j++ )
				buf[w - i - 1][j] = fg_readdot(
					x1 + dispbox[FG_X1] + i,
					y1 + dispbox[FG_Y1] + j ) == fgc ?
					1 : 0 ;
		msm_hidecursor() ;
		for ( i = 0 ; i < w ; i++ )
			for ( j = 0 ; j < h ; j++ )
				fg_drawdot( buf[i][j] ? fgc : bgc,
					get_mode(), ~0,
					dispbox[FG_X1] + x1 + i,
					dispbox[FG_Y1] + y1 + j
				) ;
		msm_showcursor() ;
		delete_array( buf, w ) ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_flip_y () { set_funcname( flip_y, "FLIP Y" ) ; }

void editmap :: flip_y () {

	fg_coord_t x1, y1, x2, y2, w, h, i, j ;
	char **buf ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		w = x2 - x1 + 1 ;
		h = y2 - y1 + 1 ;
		buf = alloc_array( w, h ) ;
		for ( i = 0 ; i < w ; i++ )
			for ( j = 0 ; j < h ; j++ )
				buf[i][h - j - 1] = fg_readdot(
					x1 + dispbox[FG_X1] + i,
					y1 + dispbox[FG_Y1] + j ) == fgc ?
					1 : 0 ;
		msm_hidecursor() ;
		for ( i = 0 ; i < w ; i++ )
			for ( j = 0 ; j < h ; j++ )
				fg_drawdot( buf[i][j] ? fgc : bgc,
					get_mode(), ~0,
					dispbox[FG_X1] + x1 + i,
					dispbox[FG_Y1] + y1 + j
				) ;
		msm_showcursor() ;
		delete_array( buf, w ) ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_clear () { set_funcname( clear, "CLEAR" ) ; }

void editmap :: clear () {

	fg_coord_t x1, y1, x2, y2 ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		pix[FG_X1] = dispbox[FG_X1] + x1 ;
		pix[FG_X2] = dispbox[FG_X1] + x2 ;
		pix[FG_Y1] = dispbox[FG_Y1] + y1 ;
		pix[FG_Y2] = dispbox[FG_Y1] + y2 ;
		msm_hidecursor() ;
		fg_fillbox( bgc, FG_MODE_SET, ~0, pix ) ;
		msm_showcursor() ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_copy () {

	set_funcname( copy, "COPY" ) ;
	delete_array( clipb, clip_w ) ;
}

void editmap :: copy () {

	fg_coord_t x1, y1, x2, y2, i, j ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		clip_w = x2 - x1 + 1 ;
		clip_h = y2 - y1 + 1 ;
		clipb = alloc_array( clip_w, clip_h ) ;
		for ( i = x1 ; i <= x2 ; i++ )
			for ( j = y1 ; j <= y2 ; j++ )
				clipb[i - x1][j - y1] =
					fg_readdot( dispbox[FG_X1] + i,
						dispbox[FG_Y1] + j ) == fgc ?
						1 : 0 ;
		finish_func() ;
	}
}

void editmap :: _set_cut () {

	set_funcname( cut, "CUT" ) ;
	delete_array( clipb, clip_w ) ;
}

void editmap :: cut () {

	fg_coord_t x1, y1, x2, y2, i, j, k, m ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x1 = min( p_x, pix[FG_X1] ) ;
		x2 = max( p_x, pix[FG_X1] ) ;
		y1 = min( p_y, pix[FG_Y1] ) ;
		y2 = max( p_y, pix[FG_Y1] ) ;
		clip_w = x2 - x1 + 1 ;
		clip_h = y2 - y1 + 1 ;
		clipb = alloc_array( clip_w, clip_h ) ;
		for ( i = x1 ; i <= x2 ; i++ )
			for ( j = y1 ; j <= y2 ; j++ ) {
				clipb[i - x1][j - y1] =
					fg_readdot( k = dispbox[FG_X1] + i,
						m = dispbox[FG_Y1] + j )
					== fgc ? 1 : 0 ;
				fg_drawdot( bgc, FG_MODE_SET, ~0, k, m ) ;
			}
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_paste () {

	set_funcname( paste, "PASTE" ) ;
}

void editmap :: paste () {

	fg_coord_t i, j, k, m ;

	if ( pix[FG_X1] == -1 ) {
		for ( i = 0 ; i < clip_w ; i++ )
			for ( j = 0 ; j < clip_h ; j++ ) {
				k = dispbox[FG_X1] + p_x + i ;
				m = dispbox[FG_Y1] + p_y - j ;
				if ( fg_pt_inbox( dispbox, k, m ) )
					if ( clipb[i][clip_h - j - 1] )
						fg_drawdot( get_color(),
							get_mode(),~0, k, m ) ;
			}
		finish_func() ;
		redraw( p_x, p_y - clip_h + 1, p_x + clip_w - 1, p_y ) ;
	}
}

void editmap :: _set_draw_circle () { set_funcname( draw_circle, "CIRCLE" ) ;}

void editmap :: draw_circle () {

	double radiu ;
	int x, y, r ;
	fg_coord_t x1, y1, x2, y2 ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x = p_x - pix[FG_X1] ;
		y = p_y - pix[FG_Y1] ;
		radiu = sqrt( x * x + y * y ) ;
		r = int( radiu ) ;
		x1 = pix[FG_X1] - r ; x2 = pix[FG_X1] + r ;
		y1 = pix[FG_Y1] - r ; y2 = pix[FG_Y1] + r ;
		pix[FG_X1] += dispbox[FG_X1] ;
		pix[FG_Y1] += dispbox[FG_Y1] ;
		msm_hidecursor() ;
		fg_drawarc( get_color(), get_mode(), ~0,
			pix[FG_X1], pix[FG_Y1], r, 0, 3600, dispbox ) ;
		msm_showcursor() ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_draw_ellipse () {

	set_funcname( draw_ellipse, "ELLIPSE" ) ;
}

void editmap :: draw_ellipse () {

	int x, y, r, s ;
	fg_coord_t x1, y1, x2, y2 ;

	if ( pix[FG_X1] == -1 ) {
		pix[FG_X1] = p_x ;
		pix[FG_Y1] = p_y ;
	} else if ( pix[FG_X2] == -1 ) {
		x = min( p_x, pix[FG_X1] ) ;
		y = min( p_y, pix[FG_Y1] ) ;
		r = x == p_x ? pix[FG_X1] - x : p_x - x ;
		s = y == p_y ? pix[FG_Y1] - y : p_y - y ;
		x1 = x - r ; x2 = x + r ; y1 = y - s ; y2 = y + s ;
		x += dispbox[FG_X1] ;
		y += dispbox[FG_Y1] ;
		msm_hidecursor() ;
		fg_drawellipse( get_color(), get_mode(), ~0, x, y, r, s,
			0, 3600, dispbox ) ;
		msm_showcursor() ;
		finish_func() ;
		redraw( x1, y1, x2, y2 ) ;
	}
}

void editmap :: _set_draw_pixel () { set_funcname( draw_pixel, "PIXEL" ) ; }

void editmap :: draw_pixel () {

	if ( pix[FG_X1] == -1 ) {
		bits[p_x][p_y] = p_status == MSM_BUTTONL ? 1 : 0 ;
		msm_hidecursor() ;
		drawcell( p_x, p_y, 1 ) ;
		msm_showcursor() ;
		finish_func() ;
	}
}

void editmap :: edit_map () {

	getmspos() ;
	translate() ;
	msm_hidecursor() ;
	drawcell( p_x, p_y, 0 ) ;
	msm_showcursor() ;
	( this->*draw_func )() ;
}
void editmap :: total_map () {

	getmspos() ;
	mu->box->translate_script( this, p_x, p_y ) ;
}

void editmap :: drawcell ( int i, int j, int f ) {

	fg_box_t t ;
	fg_coord_t g, k ;

	if ( i < 0 || i >= w || j < 0 || j >= h )
		return ;
	g = editbox[FG_X1] + i * cellbox[FG_X2] ;
	k = editbox[FG_Y1] + j * cellbox[FG_Y2] ;
	fg_make_box( t, g, k, g + cellbox[FG_X2] - 1, k + cellbox[FG_Y2] - 1 ) ;
	if ( f ) {
		fg_fillbox( bits[i][j] ? fgc : bgc, FG_MODE_SET, ~0, t ) ;
		fg_drawdot( bits[i][j] ? fgc : bgc, FG_MODE_SET, ~0,
			dispbox[FG_X1] + i, dispbox[FG_Y1] + j ) ;
		t[FG_X2]++ ; t[FG_Y2]++ ;
		fg_drawbox( fgc, FG_MODE_SET, ~0, FG_LINE_SOLID, t, winbox ) ;
	} else {
		fg_drawline( fgc, FG_MODE_XOR, ~0, FG_LINE_SOLID, t ) ;
		g = t[FG_X1] ; t[FG_X1] = t[FG_X2] ; t[FG_X2] = g ;
		fg_drawline( fgc, FG_MODE_XOR, ~0, FG_LINE_SOLID, t ) ;
	}		
}

void editmap :: expose () {

	int i, j, k ;
	fg_coord_t m, n ;
	fg_box_t t ;

	msm_hidecursor() ;
	cls() ;
	for ( i = 0 ; i < w ; i++ )
		for ( j = 0 ; j < h ; j++ )
			drawcell( i, j, 1 ) ;

	for ( i = 0 ; i < w ; i += 10 )
		for ( k = 1, j = i ; j < i + 10 && j < w ; k--, j += 5 ) {
			m = editbox[FG_X1] + j * cellbox[FG_X2] ;
			n = editbox[FG_Y1] - 2 ;
			fg_make_box( t, m,
				editbox[FG_Y1] - fg.charbox[FG_Y2] / 2,
				m, n ) ;
			if ( !j )
				continue ;
			if ( k )
				t[FG_Y1] -= fg.charbox[FG_Y2] / 2 ;
			fg_drawlineclip( fgc, FG_MODE_SET, ~0,
				FG_LINE_SOLID, t, winbox );
		}

	for ( i = 0 ; i < h ; i += 10 )
		for ( k = 1, j = i ; j < i + 10 && j < h ; k--, j += 5 ) {
			m = editbox[FG_Y1] + j * cellbox[FG_Y2] ;
			n = editbox[FG_X1] - 2 ;
			fg_make_box( t, editbox[FG_X1] - fg.charbox[FG_X2] / 2,
				m, n, m ) ;
			if ( !j )
				continue ;
			if ( k )
				t[FG_X1] -= fg.charbox[FG_X2] / 2 ;
			fg_drawlineclip( fgc, FG_MODE_SET, ~0,
				FG_LINE_SOLID, t, winbox ) ;
		}

	fg_box_cpy( t, dispbox ) ;
	t[FG_X1]-- ; t[FG_Y1]-- ; t[FG_X2]++ ; t[FG_Y2]++ ;
	fg_drawbox( fgc, FG_MODE_SET, ~0, FG_LINE_SOLID, t, winbox);
	msm_showcursor() ;
	mu->expose() ;
}

void editmap :: redraw ( int _x1, int _y1, int _x2, int _y2 ) {

	int i, j ;
	fg_box_t t ;
	fg_coord_t p, q, x1, y1, x2, y2 ;

	msm_hidecursor() ;
	p = dispbox[FG_X1] ;
	q = dispbox[FG_Y1] ;
	x1 = max( _x1, 0 ) ;
	y1 = max( _y1, 0 ) ;
	x2 = min( _x2, w - 1 ) ;
	y2 = min( _y2, h - 1 ) ;
	for ( i = x1 ; i <= x2 ; i++ )
		for ( j = y1 ; j <= y2 ; j++ ) {
			bits[i][j] = fg_readdot( p + i, q + j )
				== bgc ? 0 : 1 ;
			drawcell( i, j, 1 ) ;
		}
	fg_box_cpy( t, dispbox ) ;
	t[FG_X1]-- ; t[FG_Y1]-- ; t[FG_X2]++ ; t[FG_Y2]++ ;
	fg_drawbox( fgc, FG_MODE_SET, ~0, FG_LINE_SOLID, t, winbox);
	msm_showcursor() ;
}

void editmap :: _redraw () { redraw( 0, 0, w - 1, h - 1 ) ; }

void editmap :: focus () { focus_loop( this ) ; }

void editmap :: destroy () { quit = 1 ; }

