; ===========================================================================
;    d_break.asm
; ---------------------------------------------------------------------------
;    Copyright (C) 1989.  Daniel J. Reynolds.  All Rights Reserved.
;    High Aspect Development Corporation.
;    45 Shore Drive # 909.
;    Ogden Dunes, IN. 46368  (219) 762-4725
; ---------------------------------------------------------------------------
;    $Log:   Z:/source/video/vcs/d_break.asv  $
;  
;     Rev 3.2   28 Jan 1991 14:09:00   DJR
;  Release3.Version2
;  
;     Rev 3.1   17 Jan 1991 05:08:26   DJR
;  Release3.Version1
;  
;     Rev 3.0   05 Sep 1990 00:00:58   DJR
;  Release3.Version0
; ===========================================================================

include   model.inc

param     struc

saved_bp  dw     ?
ifdef     FAR_CALLS
ret_addr  dd     ?
else
ret_addr  dw     ?
endif
ifdef     FAR_DATA
cad_flg_addr   dd   ?
else
cad_flg_addr   dw   ?
endif

param     ends

TEXT_SEG  VIDEO
FUNCTION  break_off
;----------------------------------------------------------------------------
          push   ds                    ;save registers
          push   di
          push   si

          mov    ax,word ptr [bp].cad_flg_addr ;Get the ctrl-alt-del flag 
          mov    word ptr cs:flag,ax   ; offset and save it
ifdef     FAR_DATA                     ;Get the ctrl-alt-del flag segment
          mov    ax,word ptr [bp].cad_flg_addr+2 ; based on wether this is
else                                   ; a far or near data memory model
          mov    ax,ds
endif
          mov    word ptr cs:flag+2,ax ; and save it

                                       ;pick up original vector contents
          mov    ax,3509h              ;for interrupt 09H (MS-DOS
          int    21h                   ;Keyboard handler)
          mov    word ptr cs:int09,bx
          mov    word ptr cs:int09+2,es

          push   cs                    ;set address of new handler
          pop    ds
          mov    dx,offset kb_int
          mov    ax,02509H
          int    21h

          pop    si
          pop    di
          pop    ds                    ;restore registers and
END_FUNC  break_off
;------------------------------------------------------------------------------
FUNCTION  break_on
          push   ds                    ;save registers
          push   di
          push   si

          lds    dx,cs:int09           ;set interrupt 1BH (MS-DOS Keyboard
          mov    ax,2509h              ;interrupt handler)
          int    21h

          pop    si
          pop    di
          pop    ds                    ;restore registers and
END_FUNC  break_on
;------------------------------------------------------------------------------
kb_int    PROC   far

          sti
          push   ax                    ;save affected registers
          push   bx
          pushf
          push   ds
          push   es

          xor    ax,ax
          mov    es,ax
          mov    al,byte ptr es:[0417h]
          and    al,0fh
          cmp    al,0ch
          jz     ck_delete
	  cmp    al,04h
          jz     ck_break
          jmp    short do_old
ck_break:
          in     al,60h
          jmp    $+2
          cmp    al,46h
          jz     do_delete
          cmp    al,2eh
          jz     do_delete
          jmp    short do_old
ck_delete:
          in     al,60h
          jmp    $+2
          cmp    al,53h
          jz     do_delete
          jmp    short do_old
do_delete:
          lds    bx,cs:flag            ;set flag within C program to "TRUE"
          mov    word ptr ds:[bx],1
          in     al,61h
          jmp    $+2
          mov    ah,al
          or     al,80h
          out    61h,al
          jmp    $+2
          xchg   ah,al
          out    61h,al
          jmp    $+2
          mov    al,20h
          out    20h,al
          pop    es
          pop    ds
          popf
          pop    bx
          pop    ax
          iret
do_old:
          pop    es                    ;restore registers and exit
          pop    ds
          popf
          pop    bx
          pop    ax
          pushf
          call   dword ptr cs:[int09]
          iret

kb_int    endp

flag      dd     0                     ;long address of C program's
                                       ;Control-Alt-Delete detected flag
int09     dd     0                     ;original contents of MS-DOS
                                       ;Keyboard Interrupt 09H
                                       ;vector
END_TEXT  VIDEO
          end
