/*  PHONENUM.C -- Searches a file for a phone number using a person's lastname.
    also allows new names to be added by passing "Enter" as the lastname.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*  Create a structure template for the structure with the tag "record".  */

struct record {
		char lastname[31];
		char firstname[16];
		char phonenum[13];
	      };

FILE *fptr;

void main(int argc, char *argv[])
{
	struct record inputt;
	int count = 0;
	int names = 0;

    /*  Check to make sure enough arguements were passed.  If not, display
    an error message.  */
	
    if(argc == 1)
	{
		puts("\nUsage:  PHONENUM <name> ");
		puts("\nWhere <name> is the lastname of the person.");
		puts("In order to add names to the file, enter the");
		puts("word 'Enter' as the name of the person.");
		exit(1);
	}
	
    /*  If "Enter" was entered as the lastname, allow user to add a record.  */

	if(strcmpi("enter", argv[1]) == 0)
	{

		/*  Open the file for storing the entered data.  */

		if((fptr=fopen("input","ab")) == NULL)
		{
			printf("\nCannot open file for storing data.");
			exit(1);
		}

		/*  Get the input data from the user and write it to the data file.  */

		printf("\nEnter last name:  ");
		gets(inputt.lastname);

		printf("\nEnter first name:  ");
		gets(inputt.firstname);

		printf("\nEnter phone number (XXX-XXX-XXXX):  ");
		gets(inputt.phonenum);

		fwrite(&inputt, sizeof(inputt), 1, fptr);

		/*  Close the data file.  */

		fclose(fptr);

		exit(0);

	}


	/*  Open data file for reading.  */

	if((fptr=fopen("input","rb")) == NULL)
	{
		puts("\nCannot open file for reading data.");
		exit(1);
	}

	/*  Search for a lastname in the file, which matches the arguement.  If
	    there is a match, print the name.  Keep count of the number of times
	    through the loop.  */

	do
	{
		fread(&inputt,sizeof(inputt),1,fptr);
		if(strcmpi(inputt.lastname, argv[1]) == 0)
		{
			printf("\n%s %s:  %s", inputt.firstname, inputt.lastname, inputt.phonenum);
			names++;
		}
		count++;
	}while(count < 10);  /*  For this example, a limit of ten names.  */

    /*  If there was no name, print mesage.  */

	if(names == 0)
		puts("\nNo name found.");

	/*  Close data file.  */

	fclose(fptr);

}


