/*							qsqrt.c		*/
/* square root check routine */
/* full precision for 9 word mantissa */
#include "qhead.h"
extern short qsqrt2[];

/* constants for first approximation polynomial */
static short qsq2[NQ] =
{-1,037776,0,0150517,0142057,0163633,0124000,0,0,0,0,0,};

static short qsq1[NQ] =
{0,040000,0,0161743,0141256,046024,063400,0,0,0,0,0,};

static short qsq0[NQ] =
{0,037777,0,0120213,0156175,0152777,0161400,0,0,0,0,0,};

int qsqrt( x, y )
short *x, *y;
{
short a[NQ], b[NQ];
int i, m;

if( x[0] < 0 )
	{
	qclear(y);
	printf( "qsqrt domain error\n" );
	return;
	}
if( x[1] == 0 )
	{
	qclear(y);
	return;
	}

qmov( x, a );
m = a[1];	/* save the exponent		*/
a[1] = 040000;	/* change range to 0.5, 1 */

/* b = ( a * qsq2 + qsq1) * a + qsq0		*/
qmul( a, qsq2, b );	/* b = a * qsq2		*/
qadd( qsq1, b, b );	/* b += qsq1		*/
qmul( a, b, b );	/* b *= a;		*/
qadd( qsq0, b, b );	/* b += qsq0;		*/

/* divide exponent by 2 */
m -= 040000;
b[1] = (m / 2) + 040000;


/* multiply by sqrt(2) if exponent odd */
if( (m & 1) != 0 )
	qmul( b, qsqrt2, b );


/* Newton iterations */

for( i=0; i<8; i++ )
	{
	qdiv( b, x, a );
	qadd( a, b, b );
	b[1] -= 1;
	}

qmov( b, y );
}
