@echo off
REM ************************************************************************
REM *** AllFiles.bat - Perform the given command on all files that match ***
REM ***                the input command spec, where the special command ***
REM ***                fields $DIR, $ROOT, $EXT, and $FILE are replaced  ***
REM ***                by the directory, root, extension, and full       ***
REM ***                filename of the matching files found.             ***
REM ************************************************************************/

REM **********************************************************************
REM *** Only nine parameters can be passed using %1 %2 %3 etc, and so  ***
REM *** build up one big environment variable to hold all the parms,   ***
REM *** and then pass that big variable to the CEnvi code.             ***
REM **********************************************************************
SET ALLFILES_SOURCE=%0
SET ALLFILES_ARGUMENTS=
   :NEXT_ARG
      IF a%1z == az GOTO NO_MORE_ARGS
      SET ALLFILES_ARGUMENTS=%ALLFILES_ARGUMENTS% %1
      SHIFT
      GOTO NEXT_ARG
   :NO_MORE_ARGS
CEnvi %ALLFILES_SOURCE%.bat %ALLFILES_ARGUMENTS%
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( argc < 3  ||  !strcmp(argv[1],"/?")  ||  !stricmp(argv[1],"/help") ) {
      Instructions();
   } else {
      FileSpec = argv[1];
      // build output command, which is all the other input args
      Command = argv[2];
      for ( i = 3; i < argc; i++ ) {
         strcat(strcat(Command," "),argv[i]);
      }
      // build list of matching files
      FileList = Directory(FileSpec,FALSE,FATTR_RDONLY|FATTR_HIDDEN|FATTR_SYSTEM|FATTR_ARCHIVE)
      if ( NULL != FileList ) {
         for( i = 0; i <= GetArraySpan(FileList); i++ ) {
            PerformCommandOnFile(Command,FileList[i].name);
         }
      }
   }
}

SubstituteNamesInCommand(Command,Find,Replace)
{
   FindLen = strlen(Find);
   ReplaceLen = strlen(Replace);
   for ( c = Command; NULL != (c = strchr(c,'$')); c++ ) {
      if ( !strnicmp(c+1,Find,FindLen) ) {
         // replace the Find string with the Replace string
         strcpy(c+ReplaceLen,c+1+FindLen);
         memcpy(c,Replace,ReplaceLen);
         c += ReplaceLen - 1;
      }
   }
}

PerformCommandOnFile(VirginCommand,File)
{
   NameParts = SplitFileName(File);
   // substitute all the $DIR, $ROOT, $EXT, and $FILE commands for that part in NameParts
   strcpy(NewCommand,VirginCommand);
   SubstituteNamesInCommand(NewCommand,"DIR",NameParts.dir);
   SubstituteNamesInCommand(NewCommand,"ROOT",NameParts.name);
   SubstituteNamesInCommand(NewCommand,"EXT",NameParts.ext);
   SubstituteNamesInCommand(NewCommand,"FILE",File);
   // set the environment variables to the new values
   $DIR = NameParts.dir
   $ROOT = NameParts.name
   $EXT = NameParts.ext
   $FILE = File
   // print the command, and send it to the system
   printf("%s\n",NewCommand);
   system(NewCommand);
}

Instructions()
{
   printf("\n")
   printf("AllFiles.bat - Execute a command on all files meeting the input criteria.  The\n")
   printf("               command may include these strings:\n")
   printf("                $DIR    - directory portion of matching file\n")
   printf("                $ROOT   - root name of the matching file\n")
   printf("                $EXT    - extension name of the matching file\n")
   printf("                $FILE   - full name of the matching file\n")
   printf("               These names, $DIR, $ROOT, $EXT, and $FILE will also be set as\n")
   printf("               environment variables when the command is executed.\n")
   printf("\n")
   printf("SYNTAX: AllFiles FileSpec [Command]\n")
   printf("Where:  FileSpec  - any file specification ith wildcards included\n")
   printf("        Command   - any command line specification\n")
   printf("\n")
   printf("EXAMPLE: To copy all *.TXT files to *.bak files in the C:\\Temp directory. but\n")
   printf("         only if the C:\\Temp\\*.bak file does not already exist:\n")
   printf("     ALLFILES *.TXT IF NOT EXIST C:\\Temp\\$ROOT.bak copy $FILE C:\\Temp\\$ROOT.bak\n")
   printf("\n")
}

:CENVI_EXIT
   SET ALLFILES_SOURCE=
   SET ALLFILES_ARGUMENTS=
   SET $DIR=
   SET $ROOT=
   SET $EXT=
   SET $FILE=
