@echo off
REM ************************************************************************
REM *** PathStak.bat - Utility to save or restore a path location using  ***
REM ***                environment variables to remember.  The paths are ***
REM ***                saved in the PATH_STACK environment variable.     ***
REM ***                Return ERRORLEVEL 0 for success and ERRORLEVEL 1  ***
REM ***                if there was a problem.  No error on restore or   ***
REM ***                forget if there is nothing saved.                 ***
REM ************************************************************************
cd | cenvi %0.bat %1 %2
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( 2 != argc ) {
      Instructions();
      Success = False;
   } else {
      Success = True;
      command = argv[1], len = strlen(command);
      // determine how many paths are currently saved
      PathStackDepth = defined(PATH_STACK) ? (GetArraySpan(PATH_STACK) + 1) : 0 ;
      if ( !strnicmp("PUSH",command,len) ) {
         PATH_STACK[PathStackDepth] = gets(); // cd was piped here, which is the current path
      } else if ( !strnicmp("POP",command,len) ) {
         if ( 0 != PathStackDepth ) {
            OldPath = PATH_STACK[PathStackDepth-1];
            // send system calls to return to old path
            system("cd %s",OldPath);
            OldPath[2] = 0;   // get just the <drive>:
            system(OldPath);
            // remove this final element from the PATH_STACK array
            if ( 1 == PathStackDepth ) {
               undefine(PATH_STACK);
            } else {
               SetArraySpan(PATH_STACK,PathStackDepth - 2);
            }
         }
      } else if ( !strnicmp("FORGET",command,len) ) {
         undefine(PATH_STACK);
      } else {
         Instructions();
         Success = False;
      }
   }
   return( Success ? 0 : 1 );
}

Instructions()
{
   printf("\a\n")
   printf("PathStak.bat - Save or restore directory paths.\n")
   printf("\n")
   printf("SYNTAX: PathStak PUSH | POP | FORGET\n")
   printf("\n")
   printf("Where:  PUSH    Save the current directory as most recent.\n")
   printf("        POP     Return to the most recently saved directory.\n")
   printf("        FORGET  Forget all saved directories.\n")
   printf("\n")
}


:CENVI_EXIT
