/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "key.h"
#include "tools.h"
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>



/*
 * Functions    : getPasswd
 *
 * Description  : Input a password (echoes '*')
 *
 * Parameters   : in  char *passwd    string to store password
 *
 * Remarks      : Backspace and left arrow can be used to erase characters
 *                Characters must be in the range 32 - 254
 *
 * Return       : pointer to password
 *
 */

char *getPasswd( char *passwd )

{ char *ptr = passwd;
  int key;

  for (;;) { switch( key = getkey() )
                   {
                     case '\0':
                     case '\n':
                     case '\r':
                     case EOF : putch( '\r' ); putch( '\n' );
                                *ptr = '\0';
                                return passwd;

                     case LEFT:
                     case '\b': if ( ptr > passwd )
                                   {
                                     ptr--;
                                     putch( '\b' );  putch( SPACE ); putch( '\b' );
                                   }
                                continue;

                     default  : if ( key < 32 || key > 254 ) continue;

                                putch( '*' );
                                break;
                   }
             *ptr++ = key;
           }
}
