#define Uses_TRect
#define Uses_TView
#define Uses_TStaticText
#define Uses_TWindowInit
#define Uses_TDialog
#define Uses_TButton
#define Uses_TSystemError
#define Uses_TEventQueue
#define Uses_TScreen
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TStatusLine

#include <graphics.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#include <tv.h>

#include "TVBGI.H"
#include "scroll.h"
#include "PRTgraph.h"
#include "OUTMSG.H"

extern int ScreenPreview;

/*----------------------------*/
class TPrDialog: public TDialog
/*----------------------------*/
{
   PRT__handleT far *handlePPtr;
   virtual void handleEvent(TEvent& event);
   public:
   TPrDialog ( const TRect& bound, const char *aTitle, PRT__handleT far *hPPtr ):
                TDialog(bound, aTitle),
                TWindowInit( &TDialog::initFrame )
                { handlePPtr = hPPtr; };
};


/*----------------------------*/
void TPrDialog::handleEvent(TEvent& event)
/*----------------------------*/
{
   if ( event.what==evCommand && event.message.command==cmOK )
   {
      TStaticText *pt = new TStaticText( TRect(3,5,37,6), "Printing");
      insert(pt);
      redraw();
      helpCtx = hcGraphPrint;
      TProgram::application->statusLine->update();
      TEventQueue::suspend();
      int  ReturnCode =  PRT_PrintBuffer(handlePPtr);
      TEventQueue::resume();
   }
   TDialog::handleEvent(event);
};


/*----------------------------*/
int _PRT__pascal TVUserPrtFunc( void far* UserPtr,
                                PRT__handleT   *handlePPtr,
                                const char far* BGIpath )
/*----------------------------*/
{  int  graphdriver=DETECT,graphmode=0;
   int  Scrn_x1,Scrn_y1,dx,dy,buf_x,buf_y,Scrn_width,Scrn_height;
   int  deltaX,deltaY;
   int  c;
   int  ReturnCode=0;
   struct viewporttype ts;


     if ( ScreenPreview && PRT_PreviewPossible(0) )
      {
         // bgiApp. suspend();
         // TSystemError::suspend();
         TEventQueue::suspend();
         TScreen::suspend();

         // If you didn't use BGI_initgraph before PRT_PrintBGI you must
         // initiate graphic mode using either initgraph or BGI_initgraph
         // function
             BGI_initgraph(&graphdriver,&graphmode,BGIpath,Scrn_BGIgroup);
             if ( graphresult() ) return 16;

         getviewsettings(&ts);
         Scrn_x1=0; Scrn_y1=16;

         /* Draw message at the top of the screen */
         setviewport ( 0,0, getmaxx()+1,Scrn_y1-1, 1);
         if ( getmaxcolor()>1 )
            setcolor(getmaxcolor());
         else
            setcolor(0);
         setfillstyle(SOLID_FILL,1);
         bar(0,0,getmaxx(),Scrn_y1-1);
         settextjustify(CENTER_TEXT, TOP_TEXT);
         outtextxy(getmaxx()/2,1,"Use \x18 \x19 \x1a \x1b to scroll" );
                                    // "   
         Scrn_width=getmaxx()+1-Scrn_x1; Scrn_height=getmaxy()+1-Scrn_y1;
         setviewport ( Scrn_x1,Scrn_y1,
                       Scrn_x1+Scrn_width-1,Scrn_y1+Scrn_height-1,1);
         clearviewport();

         Scrn_x1=(Scrn_x1+15)&(-16);    Scrn_y1=(Scrn_y1+15)&(-16);
         if ( Scrn_x1+Scrn_width  > getmaxx()+1 ) Scrn_width= (getmaxx()-Scrn_x1+1);
         if ( Scrn_y1+Scrn_height > getmaxy()+1 ) Scrn_height=(getmaxy()-Scrn_y1+1);
         Scrn_width &= (-16);

         deltaX = (Scrn_width/5+15) & (-16);
         deltaY = (Scrn_height/5+15) & (-16);

         buf_x=buf_y=0;
         //
         // Note that all values passed to PRT_MoveToScrn and PRT_ScrollScrn
         // functions should be evenly divided by 16.
         //
         PRT_MoveToScrn (buf_x,buf_y, Scrn_x1,Scrn_y1,Scrn_width,Scrn_height);

         do
         {
            if (!kbhit()) { sound(650);delay(5);nosound(); }
            dx=dy=0;
            if ( (c=getch())==0)
            {
               switch (c=getch())
               {
                  case 0x4b: dx=-deltaX; c=0;  break;  // left
                  case 0x4d: dx=deltaX;  c=0;  break;  // right
                  case 0x50: dy=deltaY;  c=0;  break;  // down
                  case 0x48: dy=-deltaY; c=0;  break;  // up
                  default: ;
               }
            }
            PRT_ScrollScrn ( &dx, &dy );
            // buf_x += dx; buf_y += dy;  // you may uncomment it if you need
         } while (c==0);
         BGI_closegraph();
         // bgiApp.resume();
         // TSystemError::resume();
         TEventQueue::resume();
         TScreen::resume();
         TProgram::application->redraw();
      }


      if ( c!=0x1b ) // do not print if Esc key pressed
      {
         TPrDialog *d = new TPrDialog(TRect(0,0,42,10), "About to Print",handlePPtr);
         d->options |= ofCentered;
         d->insert(new TStaticText( TRect(3,2,37,3), "If you want to print press OK button"));
         d->insert(new TStaticText( TRect(3,3,37,4), "otherwise press Cancel"));
         //  Buttons
         d->insert(new TButton( TRect(27,7,36,9), "~C~ancel", cmCancel, bfNormal) );
         d->insert(new TButton( TRect(10,7,19,9),"O~K~", cmOK, bfDefault) );
         TProgram::deskTop->execView(d);
         TProgram::deskTop->destroy(d);
      }
      else ReturnCode=PRT_USER_INTERRUPT;

   return ReturnCode;
}
