@echo off

:			Ŀ
:			   BACKSUN.BAT   
:			Ĵ
:			  Backup & Restore files    
:			   onto a UNIX system using  
:			   PC-NFS network system     
:			                             
:			  Use TAR (Type ARchive)    
:			   format                    
:			                             
:			  Usage: BACKSUN            
:			                             
:			ٰ
:			  


: Check if user is logged into the network
net name | find "nobody" | XSET/UPPER _name
if not "%name%" == "" goto NOLOG

: Check if PC node name is defined
if "%node%" == "" goto NONODE

: Find the name of the NIS server
net nisset | xset /right "11" /left "6" _host
set _target=
if "%_host%" == "mo4701" set _target=/pc_backup/
if "%_host%" == "mo4801" set _target=/home/pc_backup/
if "%_target%" == "" goto NOSERVER

xset _date yymmdd

:MENU
xset _time time
cls
echo.
echo                               BACKSUN MENU
echo.
echo.
echo                            B. Backup pc on server
echo.
echo                            R. Restore backup from server
echo.
echo                            L. List current backup files
echo.
echo                            D. Dates of backup files
echo.
echo                            E. Exit
echo.
echo   Restore & List presuppose that the backup file has
echo   previously been restored on the server from the backup cartridge.
echo.
echo   Choose a letter

XSET/UPPER _action key "BRLDE"
goto %_action%

:B   BACKUP
echo Backup dates of %node%:
rsh %_host% fgrep %node% %_target%.backupdates
rsh %_host% cat %_target%.%node% | XSET _disk
if "%_disk%" == "" goto NODEFAULT
echo.
echo   Enter backup mode (Full/Incremental):
XSET/UPPER _action key "FI"
echo.
goto %_action%

:f   FULL
tar cvf %_host%:%_target%%node%.full.%_date%.%_time% %_disk%
rsh %_host% cd %_target% ; %_target%.update %node%.full.%_date%.%_time%*
echo.
pause
goto MENU

:i   INCREMENTAL
tar cvfI %_host%:%_target%%node%.inc.%_date%.%_time% %_disk%
rsh %_host% cd %_target% ; %_target%.update %node%.inc.%_date%.%_time%*
echo.
pause
goto MENU



:R   RESTORE
echo Backup list of %node% 
rsh %_host% ls %_target%%node%.*
echo.
:ASK_TARFILE
echo Enter your backup filename
XSET /PROMPT "(e.g. MOPC13.full.920422.13:28:34): " _files
if "%_files%" == "" goto ASK_TARFILE
echo.
echo To restore your entire hard disk press ENTER.
echo To restore a single file from the backup of your entire disk,
echo    specify the exact path name.
XSET /PROMPT "Enter data to restore: " _disk
tar xvf %host%:%_target%%_files% %_disk%
echo.
pause
GOTO menu

:L   LIST
echo Backup list of %node%
rsh %_host% cd %_target%; ls %node%.*
echo.
:ASK_TARLIST
echo Enter your backup filename
XSET /PROMPT "(e.g. MOPC13.full.920422): " _files
if "%_files%" == "" goto ASK_TARLIST
tar tvf %_host%:%_target%%_files%
echo.
pause
GOTO menu

:D   LIST DATES
echo Backup dates of %node%:
rsh %_host% fgrep %node% %_target%.backupdates
echo.
pause
GOTO menu

:NONODE
echo.
echo  Your PC has no node name defined !
echo.

:NOLOG
echo.
echo  You must be logged on the server
echo.

:NOSERVER
echo Can't find a NIS server
goto EXIT

:NODEFAULT
echo Your PC has no default disk(s) defined on the server !
goto EXIT

:EXIT
:E   EXIT
echo.
set _name=
set _host=
set _target=
set _date=
set _time=
set _action=
set _files=                     
set _disk=
