DECLARE SUB Continue ()
DEFINT A-Z

'Program:   TESTFCB.BAS
'Test program for FCBLabel functions

'$INCLUDE: 'FCBLABEL.BI'

'DIM DiskID$ AS STRING * 11
'DIM NewDiskID$ AS STRING * 11
'DIM Drive AS STRING * 1


DO WHILE 1 > 0
	CLS
	LOCATE 1, 25: PRINT "Volume Functions"
	LOCATE 9, 25: PRINT "1) SET label"
	LOCATE 10, 25: PRINT "2) DELETE label"
	LOCATE 11, 25: PRINT "3) RENAME label"
	LOCATE 12, 25: PRINT "4) GET label"
	LOCATE 13, 25: PRINT "5) EXIT"
	LOCATE 15, 20

	INPUT "Type number and press Enter > "; Choice
	Drive$ = "C"

	SELECT CASE Choice
		CASE 1                  'SET VOLUME LABEL
			DiskID$ = GetDiskID(Drive$)
			IF DiskID$ <> "" THEN
				PRINT "Label is not null: "; DiskID$
				PRINT "Use RENAME option instead"
				Continue
			ELSE
				INPUT "Enter new label > "; DiskID$
				IF NOT SetDiskID(Drive$, DiskID$) THEN
					PRINT "System Error"
					Continue
				END IF
			END IF
		CASE 2                  'DELETE VOLUME LABEL
			IF DeleteDiskID(Drive$) THEN
				PRINT "Volume label deleted"
				Continue
			ELSE
				PRINT "System Error"
				IF GetDiskID(Drive$) = "" THEN
					PRINT "Can't delete a null label"
				END IF
				Continue
			END IF
		CASE 3                  'RENAME VOLUME LABEL
			DiskID$ = GetDiskID(Drive$)
			IF DiskID$ = "" THEN
				PRINT "Current label is null:"
				PRINT "Use SET option instead"
				Continue
			ELSE
				INPUT "Enter new name of label > ";_
        	                             NewDiskID$
				IF NOT RenameDiskID_
                (Drive$, DiskID$, NewDiskID$) THEN
					PRINT "System Error"
					Continue
				END IF
			END IF
		CASE 4                  'GET VOLUME LABEL
			DiskID$ = GetDiskID(Drive$)
			PRINT "The current label is ";
			IF DiskID$ = "" THEN
				PRINT "null"
			ELSE
				PRINT DiskID$
			END IF
			Continue
		CASE 5
			EXIT DO
		CASE ELSE
			BEEP
	END SELECT
LOOP
END

SUB Continue
	PRINT "Press Enter to continue ";
	INPUT d$
END SUB

