DECLARE FUNCTION SetMaxFiles% (NbrFiles AS INTEGER)

'PROGRAM: FILEOPEN.BAS

'PURPOSE: Demonstrate process to open more than
'         15 files in QuickBASIC and PDS

'Use the QBX.BI include file in the INCLUDE
'metacommand if you are using BASIC version 7.0
'else use QB.BI if you use QuickBASIC

'$INCLUDE: 'QBX.BI'

CLS : PRINT "Opening 20 files"

'Place a comment marker in front of next line 
' to see the program fail

ErCode% = SetMaxFiles%(25)

IF ErCode% THEN
	PRINT "Error number "; ErCode%; " encountered."
	STOP
END IF

FOR I% = 1 TO 20
  F$ = "TEST" + CHR$(I% + 64) + ".TMP"
  PRINT "Opening file "; F$
  OPEN "O", I%, F$
NEXT I%
CLOSE
KILL "TEST*.TMP"  'Get rid of the test files
END

FUNCTION SetMaxFiles% (NbrFiles AS INTEGER)

DIM InRegs AS RegType, OutRegs AS RegType

InRegs.AX = &H6700
InRegs.BX = NbrFiles

SetMaxFiles = 0         'Initialize return value

CALL Interrupt(&H21, InRegs, OutRegs)

IF (OutRegs.Flags AND 1) = 1 THEN_
   SetMaxFiles% = OutRegs.AX  'Error number
END FUNCTION
