DECLARE FUNCTION GetSizeOfFile& (FileNumber AS INTEGER)
'Program: BONUS2.BAS

'This program demonstrates a way to save room
'in DGROUP by storing string data outside the
'program, but within the EXE file.

TYPE DataRec1
	CoName   AS STRING * 30
	FName    AS STRING * 15
	LName    AS STRING * 20
	Phone    AS STRING * 14
	CRLF     AS STRING * 2
END TYPE

TYPE DataRec2
	CoName  AS STRING * 30
	CoAddr1 AS STRING * 30
	CoAddr2 AS STRING * 30
	CoCity  AS STRING * 20
	CoState AS STRING * 2
	CoZip   AS STRING * 9
END TYPE

DIM TestRec1 AS DataRec1
DIM TestRec2 AS DataRec2

CLS
OPEN "B", 1, "K:\BONUS2\NEWTEST.EXE"
InitLoc& = GetSizeOfFile&(1) + 1

GET #1, InitLoc&, TestRec1

PRINT TestRec1.CoName
PRINT TestRec1.LName + ", " + TestRec1.FName
PRINT TestRec1.Phone

'The " + 1 " skips <EOF> character at end of record
GET #1, , TestRec2

PRINT : PRINT
PRINT TestRec2.CoName
PRINT TestRec2.CoAddr1
PRINT TestRec2.CoAddr2
PRINT TestRec2.CoCity
PRINT TestRec2.CoState
PRINT TestRec2.CoZip

'To write to EXE file use Put
'file number & offset as follow

'  To write TestRec1

TestRec1.LName = "Jr."
PUT #1, InitLoc&, TestRec1

'  To write TestRec2

TestRec2.CoName = "THE COBB GROUP, INC."
PUT #1, , TestRec2

CLOSE #1
END

FUNCTION GetSizeOfFile& (FileNumber AS INTEGER)

'This function returns the actual size of
'programs in a long variable.  Pass the routine
'the file number used to open the file

'Read 1st 6 bytes of hdr
	A$ = INPUT$(6, FileNumber)

'Calculate the number of partial pages used in
'  the program file, if any.  This number is stored
'  in bytes 3 and 4.
	Fraction& = ASC(MID$(A$, 4)) * 256& + ASC(MID$(A$, 3))

'Calculate the number of whole pages used to
'  store the file.           
	Pages& = ASC(MID$(A$, 6)) * 256& + ASC(MID$(A$, 5))

'If there are any fractional pages subtract 1
'  from the pages count.
	IF Fraction& THEN Pages& = Pages& - 1

'Each page is 512 bytes long so multiply 512
'  times the number of pages and add any
'  fractional bytes to the total.
	GetSizeOfFile& = Pages& * 512& + Fraction&

END FUNCTION

