;***********************************************************************
;                          GEOTOL.LSP
;***********************************************************************
;Copyright (c) 1993  Jon P. Page
;This program is provided "as is" without warranty of any kind.


(defun geoerr (s)
   (if (/= s "Function cancelled")   ; If an error (such as CTRL-C) occurs
      (princ (strcat "\nError: " s)) ; while this command is active...
   )
   (setq p nil)                      ; Free selection set
   (setq *error* olderr)             ; Restore old *error* handler
   (princ)
)

(defun GEOTOL (/ p l n e os as ns st s nsl osl sl si chf chm olderr)
   (setq olderr  *error*             ; Initialize variables
         *error* geoerr
         chm     0)
     
	(command "layer" "s" "te" "")
	(command "style" "vlab12" "" "" "" "" "" "" "")
	(setq tol (getstring t "\nPick Tolerancing Symbols: "))
	(setvar "cmdecho" 1)
	(command "TEXT" pause "0" tol)
	(setvar "cmdecho" 0)
	(setq p (ssget "L"))                  ; Select objects
   (if p (progn                      ; If any objects selected
      (while (= 0 (setq osl (strlen (setq os "XXX"))))
            (princ "Null input invalid")
      )
      (setq nsl (strlen (setq ns (getstring t "\nEnter Tolerance: "))))
      (setq l 0 n (sslength p))
      (while (< l n)                 ; For each selected object...
         (if (= "TEXT"               ; Look for TEXT entity type (group 0)
                (cdr (assoc 0 (setq e (entget (ssname p l))))))
            (progn
               (setq chf nil si 1)
               (setq s (cdr (setq as (assoc 1 e))))
               (while (= osl (setq sl (strlen
                             (setq st (substr s si osl)))))
                  (if (= st os)
                      (progn
                        (setq s (strcat (substr s 1 (1- si)) ns
                                        (substr s (+ si osl))))
                        (setq chf t) ; Found old string
                        (setq si (+ si nsl))
                      )
                      (setq si (1+ si))
                  )
               )
               (if chf (progn        ; Substitute new string for old
                  (setq e (subst (cons 1 s) as e))
                  (entmod e)         ; Modify the TEXT entity
                  (setq chm (1+ chm))
               ))
            )
         )
         (setq l (1+ l))
      )
   ))
  (princ "Changed ")                ; Print total lines changed
  (princ chm)
  (princ " text lines.")
  (terpri)
   		(setq textent (entget (entlast)))
	(command "UCS" "ENTITY" (entlast))
		(setq tb (textbox textent))
		(setq ll (car tb))
		(setq ur (cadr tb))
		(setq loff (* 0.05 (getvar "DIMSCALE")))
		(setq roff (* 0.07 (getvar "DIMSCALE")))
		(setq pt4 (list (- (car ll) loff) (cadr ur)))
		(setq pt3 (list (- (car ur) roff) (cadr ur)))
		(setq pt2 (list (- (car ur) roff) (cadr ll)))
		(setq pt1 (list (- (car ll) loff) (cadr ll)))
	(command "PLINE" pt1 pt2 pt3 pt4 "CLOSE")
	(command "UCS" "P")
	(setq *error* olderr)             ; Restore old *error* handler
	(princ)
);defun