
#include "stdio.h"
#include "term.h"

char progname[] = "termnx10";

main()
	{
	register int c;

	while( !feof( stdin ))
		{
		c = getchar();
		switch( c )
			{
			case ESCAPE:
				getpc();
				break;
			case EOF:
				break;
			default:
				putchar( c );
				break;
			}
		}
	}

getpc()
	{
	register int c;

	c = getchar();
	switch( c )
		{
		case ROMAN:
			roman();
			break;
		case ITALIC:
			italic();
			break;
		case BOLD:
			bold();
			break;
		case HALFUP:
			halfup();
			break;
		case HALFDOWN:
			halfdown();
			break;
		default:
			fprintf( stderr, "%s:  unrecognized output escape sequence ESC-0x%x \n", progname, c );
			break;
		}
	}

roman()
	{
	printf( "\0335\033H" );
	}

italic()
	{
	printf( "\0334" );
	}

bold()
	{
	printf( "\033G" );
	}

halfup()
	{
	printf( "\033j\022" );
	}

halfdown()
	{
	printf( "\033J\022" );
	}


