/*************************************************************************

	kb_ibmpc.c	Keyboard (KB) Subroutines
			for Bywater Software

			Implementation for the IBM PC and Compatibles
			utilizing BIOS keyboard routines.

			This implementation contains code specific
			to the Microsoft Quick C (tm) compiler.

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "stdio.h"
#include "kb.h"
#include "bios.h"

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

#ifndef CR
#define CR      0x0d
#endif

/*************************************************************************

	FUNCTION:       kb_init()

	DESCRIPTION:    This function should perform any initialization
			necessary for the keyboard system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_init()
	{
	}

/*************************************************************************

	FUNCTION:       kb_deinit()

	DESCRIPTION:    This function should perform any necessary
			deinitialization, that is, return the keyboard
			to its default state when a Simple Software
			program is to be exited.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_deinit()
	{
	}

/*************************************************************************

	FUNCTION:       kb_rxstat()

	DESCRIPTION:    This function determines whether a character is
			ready from the console.  The function is used
			especially in telecommunications programs,
			where it is necessary to poll the keyboard
			without locking up the program waiting for a
			response.

	INPUT:          none.

	RETURNS:        The function returns 0 if no character is
			available and 1 if a character is available.

**************************************************************************/

kb_rxstat()
	{
	if ( _bios_keybrd( _KEYBRD_READY ) == 0 )
		{
		return FALSE;
		}
	else
		{
		return TRUE;
		}
	}

/*************************************************************************

	FUNCTION:       kb_rx()

	DESCRIPTION:    This function returns a single character from
			the keyboard.  If a character is not available
			it waits.  The function should be able to
			recognize any special keys, and return the
			appropriate Simple Software KB conventions
			designated for them.

	INPUT:          none.

	RETURNS:        The function returns the ASCII code for the
			key pressed, or the Simple Software KB convention
			(see kb.h) for a function or other special key.

**************************************************************************/

kb_rx()
     {
     unsigned int ax;
     unsigned char ah, al;

     while( kb_rxstat() == 0 )
	  {
	  }

     ax = _bios_keybrd( _KEYBRD_READ );
     ah = ax / 256;
     al = ax % 256;

     if ( al != 0 )
	  {
	  return al;
	  }

     else
	  {
	  switch( ah )
		{
		case 0x50:
			return KB_DOWN;
			break;
		case 0x48:
			return KB_UP;
			break;
		case 0x4b:
			return KB_LEFT;
			break;
		case 0x4d:
			return KB_RIGHT;
			break;
		case 0x49:
			return KB_P_UP;
			break;
		case 0x51:
			return KB_P_DOWN;
			break;
		case 0x53:
			return KB_DELETE;
			break;
		case 0x52:
			return KB_INSERT;
			break;
		case 0x4f:
			return KB_END;
			break;
		case 0x47:
			return KB_HOME;
			break;
		case 0x3b:                      /* FK 1         */
		case 0x54:
			return KB_FK1;
			break;
		case 0x3c:                      /* FK 2         */
		case 0x55:
			return KB_FK2;
			break;
		case 0x3d:                      /* FK 3         */
		case 0x56:
			return KB_FK3;
			break;
		case 0x3e:                      /* FK 4         */
		case 0x57:
			return KB_FK4;
			break;
		case 0x3f:                      /* FK 5         */
		case 0x58:
			return KB_FK5;
			break;
		case 0x40:                      /* FK 6         */
		case 0x59:
			return KB_FK6;
			break;
		case 0x41:                      /* FK 7         */
		case 0x5a:
			return KB_FK7;
			break;
		case 0x42:                      /* FK 8         */
		case 0x5b:
			return KB_FK8;
			break;
		case 0x43:                      /* FK 9         */
		case 0x5c:
			return KB_FK9;
			break;
		case 0x44:                      /* FK 10        */
		case 0x5d:
			return KB_FK0;
			break;
		case 0x10:
			return KB_ALT + 'Q';
			break;
		case 0x11:
			return KB_ALT + 'W';
			break;
		case 0x12:
			return KB_ALT + 'E';
			break;
		case 0x13:
			return KB_ALT + 'R';
			break;
		case 0x14:
			return KB_ALT + 'T';
			break;
		case 0x15:
			return KB_ALT + 'Y';
			break;
		case 0x16:
			return KB_ALT + 'U';
			break;
		case 0x17:
			return KB_ALT + 'I';
			break;
		case 0x18:
			return KB_ALT + 'O';
			break;
		case 0x19:
			return KB_ALT + 'P';
			break;
		case 0x1E:
			return KB_ALT + 'A';
			break;
		case 0x1F:
			return KB_ALT + 'S';
			break;
		case 0x20:
			return KB_ALT + 'D';
			break;
		case 0x21:
			return KB_ALT + 'F';
			break;
		case 0x22:
			return KB_ALT + 'G';
			break;
		case 0x23:
			return KB_ALT + 'H';
			break;
		case 0x24:
			return KB_ALT + 'J';
			break;
		case 0x25:
			return KB_ALT + 'K';
			break;
		case 0x26:
			return KB_ALT + 'L';
			break;
		case 0x2C:
			return KB_ALT + 'Z';
			break;
		case 0x2D:
			return KB_ALT + 'X';
			break;
		case 0x2E:
			return KB_ALT + 'C';
			break;
		case 0x2F:
			return KB_ALT + 'V';
			break;
		case 0x30:
			return KB_ALT + 'B';
			break;
		case 0x31:
			return KB_ALT + 'N';
			break;
		case 0x32:
			return KB_ALT + 'M';
			break;
		default:
			return 0;
			break;
		}
	  }
     }

