/****************************************************************

	sfsx_sp.c       Set Orbital Parameters Routines
			for Space Flight Simulator,
			Simulation Module

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "sfsx.h"

#ifdef   __STDC__
#include "malloc.h"
#include "stdlib.h"
#else
extern char * malloc();
#define	size_t	int
#endif

#define SYS_TITLES      4

extern int fo_xcenter, fo_ycenter;
extern long get_long();
static char *sys_titles[ SYS_TITLES ];
static char set_buffer[ 128 ];
static struct menu_box ssp_box;

fw_grid()
   {
   ui_fbox( fo_window->u_x1, fo_window->u_y1,
      fo_window->u_x2, fo_window->u_y2, BLACK, SOLID );
   ui_fbox( fo_window->u_x1, fo_window->u_y1,
      fo_window->u_x2, fo_window->u_y2, WHITE, GRID );
   }

/****************************************************************

   ssp()      Set System Parameters

****************************************************************/

ssp()
   {
   register int c, y;
   static int sysp_init = FALSE;
   static int x_x1 = 0, x_y1 = 0, x_x2 = 0, x_y2 = 0;
   int test, item;
   static int x_ebuf;

   if ( x_x1 == 0 )
      {
      x_x1 = (int) fo_xcenter - ( ui_grwind->xmax / 4 );
      x_y1 = (int) fo_ycenter - ( ui_grwind->fysize * 6 );
      x_x2 = (int) fo_xcenter + ( ui_grwind->xmax / 4 );
      x_y2 = (int) fo_ycenter + ( ui_grwind->fysize * 5 );
      }

   if ( sysp_init == FALSE )
      {
      for ( c = 0; c < SYS_TITLES; ++c )
         {
         if ( ( sys_titles[ c ] = malloc( 64 ) ) == NULL )
            {
	    bw_error( MEMERR_SSP );
            return;
            }
         }
      sysp_init = TRUE;
      }

   gr_imsave( GR_PRIMARY, TRUE, x_x1, x_y1, x_x2, x_y2, &x_ebuf );

   y = TRUE;
   while( y == TRUE )
      {

      /* set up titles for menu */

      sprintf( sys_titles[ 0 ], SSP_TF,
         (long) sfs_tfactor );
      sprintf( sys_titles[ 1 ], SSP_UI,
	 (long) sfs_inc );
      sprintf( sys_titles[ 2 ], SSP_TPL,
         vpt_level );
      sprintf( sys_titles[ 3 ], SSP_EXIT );

      item = ui_list( MENU_SLIDERS, x_x1, x_y1, x_x2, x_y2,
	 SSP_TITLE, SYS_TITLES,
	 sys_titles, cl_mfore, cl_mback, cl_marker,
	 &ssp_box );

      /* Process the argument */

      switch( item )
	 {
	 case 0:
	    sfs_tfactor = get_long( TF_TITLE,
	       TF_LEGEND,
	       TF_PROMPT,
	       (long) sfs_tfactor,
	       (long) 1, (long) 0 );
	    ssp_box.is_drawn = FALSE;
	    break;
	 case 1:
	    sfs_inc = get_long( UI_TITLE,
	       UI_LEGEND,
	       UI_PROMPT,
	       (long) sfs_inc,
	       (long) 1, (long) 0 );
	    ssp_box.is_drawn = FALSE;
	    break;
	 case 2:
	    vpt_level = get_int( TPL_TITLE,
	       TPL_LEGEND,
	       TPL_PROMPT,
	       vpt_level, 1, 2 );
	    ssp_box.is_drawn = FALSE;
	    break;
	 case TK_EXIT:
	 case 3:
	    y = FALSE;
	    break;
	 }
      }

   gr_imsave( GR_PRIMARY, FALSE, x_x1, x_y1, x_x2, x_y2, &x_ebuf );
   gr_imfree( x_ebuf );

   }

/****************************************************************

   sdi()      Set Display

****************************************************************/

sdi( d_titles, n_titles, title )
   char **d_titles;
   int n_titles;
   char *title;
   {
   register int c, y;
   static struct menu_box sdi_box;
   int test, item;
   static int x_x1 = 0, x_y1 = 0, x_x2 = 0, x_y2 = 0;
   static int x_ebuf;

   if ( x_x1 == 0 )
      {
      x_x1 = (int) fo_xcenter - ( ui_grwind->xmax / 4 );
      x_y1 = (int) fo_ycenter - ( ui_grwind->fysize * 7 );
      x_x2 = (int) fo_xcenter + ( ui_grwind->xmax / 4 );
      x_y2 = (int) fo_ycenter + ( ui_grwind->fysize * 5 );
      }

   gr_imsave( GR_PRIMARY, TRUE, x_x1, x_y1, x_x2, x_y2, &x_ebuf );

   sdi_box.is_drawn = FALSE;
   item = ui_list( MENU_SLIDERS, x_x1, x_y1, x_x2, x_y2,
	 title, n_titles,
	 d_titles, cl_mfore, cl_mback, cl_marker,
	 &sdi_box );

   gr_imsave( GR_PRIMARY, FALSE, x_x1, x_y1, x_x2, x_y2, &x_ebuf );
   gr_imfree( x_ebuf );

   return item;

   }

get_int( title, text, prompt, oldvalue, minimum, maximum )
   char *title, *text, *prompt;
   int oldvalue, minimum, maximum;
   {
   char *_text;
   int y;
   static int n;

   _text = text;
   y = 1;
   while( y == 1 )
      {
      ui_dial( ssp_box.window->x1, ssp_box.window->y1, ssp_box.window->x2, ssp_box.window->y2, cl_mback, cl_mfore,
	 cl_marker, 1, title,
	 _text, prompt, set_buffer, &ssp_box.window );
      if ( set_buffer[ 0 ] == 0 )
	 {
	 return oldvalue;
	 }

      sscanf( set_buffer, "%d",  &n );
      y = 0;
      if ( n < minimum )
	 {
	 sprintf( sfsx_tbuf, "%s %ld; %s.", MINERR, minimum - 1, PTA );
	 _text = sfsx_tbuf;
	 y = 1;
	 }
      if ( ( maximum != 0 ) && ( n > maximum ))
	 {
	 y = 1;
	 sprintf( sfsx_tbuf, "%s %ld; %s.", MAXERR, maximum + 1, PTA );
	 _text = sfsx_tbuf;
	 }
      }

   return n;
   }

long
get_long( title, text, prompt, oldvalue, minimum, maximum )
   char *title, *text, *prompt;
   long oldvalue, minimum, maximum;
   {
   char *_text;
   int y;
   static long n;

   _text = text;
   y = 1;
   while( y == 1 )
      {
      ui_dial( ssp_box.window->x1, ssp_box.window->y1, ssp_box.window->x2, ssp_box.window->y2, cl_mback, cl_mfore,
	 cl_marker, 1, title,
	 _text, prompt, set_buffer, &ssp_box.window );

      if ( set_buffer[ 0 ] == 0 )
	 {
	 return oldvalue;
	 }

      sscanf( set_buffer, "%ld",  &n );
      y = 0;
      if ( n < minimum )
	 {
	 sprintf( sfsx_tbuf, "%s %ld; %s.", MINERR, minimum - 1, PTA );
	 _text = sfsx_tbuf;
	 y = 1;
	 }
      if ( ( maximum != 0 ) && ( n > maximum ))
	 {
	 y = 1;
	 sprintf( sfsx_tbuf, "%s %ld; %s.", MAXERR, maximum + 1, PTA );
	 _text = sfsx_tbuf;
	 }
      }

   return n;
   }

