#---------------------------------------------------------------
#
#	makefile.x
#
#	Unix Makefile for Space Flight Simulator
#	Map Utility -- X Windows ver. 11
#
#---------------------------------------------------------------

#---------------------------------------------------------------
# ui and as object files

LIBS=		../../lib/ui_boxes.o ../../lib/ui_dial.o \
		../../lib/ui_init.o ../../lib/ui_list.o ../../lib/ui_text.o \
		../../lib/ui_gets.o ../../lib/ui_pbm.o\
		../../lib/gr_x.o\
                ../../lib/dr_unix.o ../../lib/kb_x.o

AST=		as_orbit.o as_focus.o as_vpt.o \
		as_spj.o

#---------------------------------------------------------------
# Map utility object files

MAP=		map.o map_dr.o

#---------------------------------------------------------------
# Flags for map utility

CFLAGS=		-DDEBUG -O -I../../include

#---------------------------------------------------------------
# Build the map utility

map:		$(MAP) $(AST)
		$(CC) $(CFLAGS) $(MAP) $(AST) $(LIBS)\
                -lX11 -lm -o map

#---------------------------------------------------------------
# Specific dependencies:

map.o:	
		$(CC) $(CFLAGS) map.c -c

map_dr.o:	
		$(CC) $(CFLAGS) map_dr.c -c

as_orbit.o:
		$(CC) $(CFLAGS) ../as/as_orbit.c -c

as_focus.o:
		$(CC) $(CFLAGS) ../as/as_focus.c -c

as_vpt.o:
		$(CC) $(CFLAGS) ../as/as_vpt.c -c

as_spj.o:
		$(CC) $(CFLAGS) ../as/as_spj.c -c

#---------------------------------------------------------------
# End of makefile.x
#---------------------------------------------------------------


