;
; *** Listing 11-3 ***
;
; Converts all characters in a string to uppercase,
; using a loop containing LODSB and STOSB and using
; two pointers.
;
	jmp	Skip
;
SourceString	label	word
	db	'This space intentionally left not blank',0
;
; Copies one zero-terminated string to another string,
; converting all characters to uppercase.
;
; Input:
;	DS:SI = start of source string
;	ES:DI = start of destination string
;
; Output:
;	none
;
; Registers altered: AL, BX, SI, DI
;
; Direction flag cleared
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
CopyStringUpper:
	mov	bl,'a'	;set up for fast register-register
	mov	bh,'z'	; comparisons
	cld
StringUpperLoop:
	lodsb		;get the next character and
			; point to the following character
	cmp	al,bl	;below 'a'?
	jb	IsUpper	;yes, not lowercase
	cmp	al,bh	;above 'z'?
	ja	IsUpper	;yes, not lowercase
	and	al,not 20h ;is lowercase-make uppercase
IsUpper:
	stosb		;put the uppercase character into
			; the new string and point to the
			; following character
	and	al,al	;is this the zero that marks the
			; end of the string?
	jnz	StringUpperLoop ;no, do the next character
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset SourceString	;point DS:SI to the
					; string to convert
	mov	di,ds
	mov	es,di			;point ES:DI to the
	mov	di,si			; same string
	call	CopyStringUpper		;convert to
					; uppercase in place
	call	ZTimerOff
