;
; *** Listing 9-11 ***
;
; Illustrates the use of the efficient word-sized INC to
; increment a byte-sized register, taking advantage of the
; knowledge that AL never counts past 0FFh to wrap to 0 and
; so AH will never affected by the INC.
;
; Note: This is a sample code fragment, and is not intended
; to either be run under the Zen timer or assembled as a
; standalone program.
;
	sub	al,al	;count up from 0
TestLoop:
	inc	ax	;AL will never turn over, so AH
			; will never be affected
	cmp	al,8	;count up to 8
	jbe	TestLoop
