.radix	16
		;
cseg	segment
		assume	cs:cseg,  ds:cseg
		;
		video	equ	10	; bios video interrupt
		exit	equ	20	; return to ccp routine
		dos	equ	21
		getmode	equ	0f
		getattr	equ	8
		setcurs	equ	2
		ttywrit	equ	0e08	; tty write a backspace
		scroll	equ	0600
		inforeq	equ	1130	; char gen routine,  get info
		;
		org	100
		;
clr:		mov	dl, 18		; assume 24 rows
		sub	bh, bh
		mov	ax, inforeq
		int	video		; get number of rows in dl
		mov	ah, getmode
		int	video
		dec	ah
		mov	ch, dl
		mov	cl, ah		; cx = maximum row and col
		xor	ah, ah		; graphics attribute
		cmp	al, 07		; see if monochrome mode
		je	mono
		cmp	al, 03		; see if notext mode
		ja	notext
mono:		; on a text screen, get current attribute
		mov	dl, 20		; write space to display
		mov	ah, 02
		int	dos
		mov	ax, ttywrit	; wipe it out with a backspace
		int	video
		mov	ah, getattr	; read attribute
		int	video
		;
notext:		push	bx		; save video page
		mov	bh, ah		; screen to be cleared
		mov	dx, cx
		sub	cx, cx
		mov	ax, scroll
		int	video
		pop	bx		; get back video page
		sub	dx, dx		; home cursor
		mov	ah, setcurs
		int	video
		;
		int	exit
cseg	ends
	end	clr
