unit AiUser;

interface

uses crt,aiglob,
             initunit,bordunit,aidigit;


Procedure MakeVideoBox(x1,y1,x2,y2:word);
Procedure EraseVideoBox(x1,y1,x2,y2:word);
procedure Makecross(x,y:word;size:byte);
procedure Erasecross(x,y:word;size:byte);
Procedure TabletDriver(var x1,y1,x2,y2:word;TwoLayer:boolean);
Function GetGray(x,y:word;Size : byte):byte;
Procedure EraseIt(x,y:word;Nucsize : byte);
Procedure BlackToRed(x1,y1,x2,y2:word);

implementation

Var
    graydatah,
    graydatav : array[1..7] of byte;

Procedure MakeCross(x,y:word;size:byte);
var i : word;
    count : byte;
begin
  If size > 3 then
    size := 3;
  newgrayvalue(1,1,1);
  count := 0;
  for i := x-size to x+size do
  begin
    count := count+1;
    graydatah[count] := oldgrayvalue(i,y);
    If (graydatah[count] and 1 <> 1) then
       newgrayvalue(i,y,graydatah[count] or 1)
    else
       newgrayvalue(i,y,20);
  end;
  count := 0;
  for i := y-size to y+size do
  begin
    count := count+1;
    If (i <> y) then
    begin
      graydatav[count] := oldgrayvalue(x,i);
      If (graydatav[count] and 1 <> 1) then
         newgrayvalue(x,i,graydatav[count] or 1)
      else
         newgrayvalue(x,i,20);
    end;
  end;
end;

Procedure EraseCross(x,y:word;size:byte);
var i : word;
    count : byte;
begin
  If size > 3 then
    size := 3;
  newgrayvalue(1,1,1);
  count := 0;
  for i := x-size to x+size do
  begin
    count := count+1;
    newgrayvalue(i,y,graydatah[count]);
  end;
  count := 0;
  for i := y-size to y+size do
  begin
    count := count+1;
    If (i <> y) then
      newgrayvalue(x,i,graydatav[count]);
  end;
end;


Procedure MakeVideoBox(x1,y1,x2,y2:word);
Var
    j,k : word;
    xc,yc : word;
begin
    newgrayvalue(1,1,oldgrayvalue(1,1));
    for j := x1 to x2 do
    begin
       newgrayvalue(j,y1,(oldgrayvalue(j,y1) or 1));
       newgrayvalue(j,y2,(oldgrayvalue(j,y2) or 1));
    end;
    for k := y1 to y2 do
    begin
       newgrayvalue(x1,k,(oldgrayvalue(x1,k) or 1));
       newgrayvalue(x2,k,(oldgrayvalue(x2,k) or 1));
    end;
    xc := (x1+x2) shr 1;
    yc := (y1+y2) shr 1;
end;

Procedure EraseVideoBox(x1,y1,x2,y2:word);
Var
    j,k : word;
    xc,yc : word;
begin
    newgrayvalue(1,1,oldgrayvalue(1,1));
    for j := x1 to x2 do
    begin
       newgrayvalue(j,y1,(oldgrayvalue(j,y1) and $FE));
       newgrayvalue(j,y2,(oldgrayvalue(j,y2) and $FE));
    end;
    for k := y1 to y2 do
    begin
       newgrayvalue(x1,k,(oldgrayvalue(x1,k) and $FE));
       newgrayvalue(x2,k,(oldgrayvalue(x2,k) and $FE));
    end;
    xc := (x1+x2) shr 1;
    yc := (y1+y2) shr 1;
end;


procedure TabletDriver(var x1,y1,x2,y2:word;TwoLayer:boolean);
Const
    xc = 256;
    yc = 240;
Var
    xdig,ydig,butdig,errdig : integer;
    buttemp,butold : integer;
    xo1,xo2,yo1,yo2 : integer;
    xold,yold : integer;
    width,height,
    W_old,H_old : word;
    Enlarge,
    done        : boolean;
begin
  done := false;
  butdig := 0;                                     {button to zero}
  xold := 0;                                       {init old coords}
  yold := 0;
  Width := 100;                                     {Init aspects}
  Height := 100;
  W_old := 100;
  H_old := 100;
  x1 := xc-width;
  x2 := xc+width;
  y1 := yc-height;
  y2 := yc+height;

  Enlarge := TRUE;                                 {using 1 or 2 enlarges
                                                     by default}

  repeat
    digitlocate(xdig,ydig,butdig,errdig);
    If (butold = 3) and (butdig = 3) then           {exit?}
      done := true;                                 {do this because 3 twice
                                                        is the exit code}
    If butdig <> 0 then                             {set button}
       butold := butdig;
    buttemp := butdig;

    If butdig = 3 then                              {only have 3 buts to use}
    begin
     repeat
        digitlocate(xdig,ydig,butdig,errdig);
     until butdig = 0;
     delay(100);
    end;
    Case buttemp of                                  {what do we do?}
      3: Enlarge := Not Enlarge;
      1: If Enlarge and (width > 50) then
            Width := Width - 20
          Else if (Not Enlarge) and (width < 200) then
            Width := Width + 20;
      2: If Enlarge and (height > 50) then
            Height := Height - 20
          Else if (Not Enlarge) and (height < 200) then
            Height := Height + 20;
      else;
     end;{end case}

                                                      {do something}
    If (buttemp = 1) or (buttemp = 2) then
    begin
      x1 := xc - width;                          {change size or location}
      x2 := xc + width;
      y1 := yc - height;
      y2 := yc + height;
      xo1 := xold-w_old;
      xo2 := xold+w_old;
      yo1 := yold-h_old;
      yo2 := yold+h_old;
      w_old := width;
      h_old := height;
      erasevideobox(xo1,yo1,xo2,yo2);
      If twolayer then
        erasevideobox(xo1-5,yo1-5,xo2+5,yo2+5);
      makevideobox(x1,y1,x2,y2);
      If twolayer then
        makevideobox(x1-5,y1-5,x2+5,y2+5);
      xold := xc;
      yold := yc;
    end;
  until done;
  erasevideobox(x1,y1,x2,y2);
  if twolayer then
    erasevideobox(x1-5,y1-5,x2+5,y2+5);

end;

Function Sampleit(x1,y1,x2,y2:word):word;
var j,k : word;
    sum : word;
    count : word;
begin
  sum := 0;
  count := 0;
  for k := y1+1 to y2-1 do
    for j := x1+1 to x2-1 do
      begin
       count := count + 1;
       sum := sum + oldgrayvalue(j,k);
      end;
   Sampleit := round(sum/count);
end;

Procedure SampleBackFor(Var Bk1,Fr1,bk2,fr2,bk3,fr3,bk4,fr4 : byte);
Var
    done : boolean;
    xdig,ydig,butdig,errdig : integer;
    xold,yold : integer;
    x1,y1,x2,y2,
    xo1,yo1,xo2,yo2 : word;
    j,i : word;
    temp : byte;

begin
  done := false;
  xold := 0;
  yold := 0;
  newgrayvalue(1,1,1);

  Writeln('Sample four background/foreground pairs:');

  for j := 0 to 512 do                                {set up grid}
  begin
     newgrayvalue(j,256,(oldgrayvalue(j,256) or 1));
     newgrayvalue(256,j,(oldgrayvalue(256,j) or 1));
  end;

 for i := 1 to 1 do
 begin

  Repeat                                               {mov box}
    digitlocate(xdig,ydig,butdig,errdig);
    If butdig = 1 then
      done := true
    else if (xold <> xdig) or (yold <> ydig) then
    begin
      x1 := xdig - 5;                          {change size or location}
      x2 := xdig + 5;
      y1 := ydig - 5;
      y2 := ydig + 5;
      xo1 := xold-5;
      xo2 := xold+5;
      yo1 := yold-5;
      yo2 := yold+5;
      erasevideobox(xo1,yo1,xo2,yo2);
      makevideobox(x1,y1,x2,y2);
      xold := xdig;
      yold := ydig;
    end;
  until done;
  erasevideobox(x1,y1,x2,y2);

  repeat
    digitlocate(xdig,ydig,butdig,errdig);
  until butdig = 0;

  temp := sampleit(x1,y1,x2,y2);
  writeln('sample ',i,' is ',temp);
  done := false;
  bk1 := temp;

 end;

  for j := 0 to 512 do                           {erase grid}
  begin
     newgrayvalue(j,256,(oldgrayvalue(j,256) and $FE));
     newgrayvalue(256,j,(oldgrayvalue(256,j) and $FE));
  end;


end;

Function GetGray(x,y:word;Size : byte):byte;
Var j,k:word;
    Temp : word;
    gray1 : byte;
    count : word;
begin
    Temp := 0;
    For k := y-size to y+size do
      for j := x-size to x+size do
         Temp := Temp + oldgrayvalue(j,k);
    Count := sqr((2*size) + 1);
    GetGray := round(Temp/count);
end;

Procedure BlackToRed(x1,y1,x2,y2:word);
var j,k:word;
    gray1 : byte;
begin
  for k := y1 to y2 do
    for j := x1 to x2 do
    begin
      gray1 := oldgrayvalue(j,k);
      If (gray1 = 20) then
        newgrayvalue(j,k,1);
    end;
end;

Procedure EraseIt(x,y:word;Nucsize : byte);
var j,k: word;
    gray1 : byte;
    foundfirst : boolean;
    end1,end2 : word;
begin
  newgrayvalue(1,1,1);
  FoundFirst := FALSE;
  j := x;
  While Not(FoundFirst) or (j = x-(2*nucsize)) do
  begin
    If (oldgrayvalue(j,y) and 1 <> 1) then
      FoundFirst := TRUE;
    j := j-1;
  end;
  end1 := j-5;
  FoundFirst := FALSE;
  j := x+1;
  While Not(FoundFirst) or (j = x+(2*nucsize)) do
  begin
    If (oldgrayvalue(j,y) and 1 <> 1) then
      FoundFirst := TRUE;
    j := j+1;
  end;
  end2 := j+5;

  FoundFirst := FALSE;
  k := y;
  While Not(FoundFirst) or (k = y-(2*nucsize)) do
  begin
    FoundFirst := TRUE;
    For j := end1 to end2 do
    begin
      Gray1 := oldgrayvalue(j,k);
      If (gray1 and 1 = 1) then
      begin
        FoundFirst := FALSE;
        newgrayvalue(j,k,gray1 and $FE);
      end;
    end;
    k := k-1;
  end;

  FoundFirst := FALSE;
  k := y+1;
  While Not(FoundFirst) or (k = y+(3*nucsize)) do
  begin
    FoundFirst := TRUE;
    For j := end1 to end2 do
    begin
      Gray1 := oldgrayvalue(j,k);
      If (gray1 and 1 = 1) then
      begin
        FoundFirst := FALSE;
        newgrayvalue(j,k,gray1 and $FE);
      end;
    end;
    k := k+1;
  end;

end;



END.