{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}

Unit aiIMGS;

Interface

Uses
     DOS,      CRT,      GLOBUNIT, aiDIGIt, JWINUNIT, BORDUNIT;

procedure SaveFile(FileName : string);
procedure SubtractFile(FileName : string);
procedure StoreShading;
procedure ShadingCorrect;
procedure pixelfinder;

{===========================================================================}

Implementation

procedure DrawCursor(X,Y : integer);
{ ++++++++++++++++++++++++++++++++++++++++++++++++ }

  var i,ValueA : integer;
  begin
{
    ValueA := OldGrayValue(X,Y);
    GotoXY(24,12);
    writeln('X = ',X:3,'    Y = ',Y:3,'    Value = ',ValueA:3);
}
    if ((X < 10) or (X > 502) or (Y < 10) or (Y > 502)) then
    else
      begin
        for i := (Y - 10) to (Y + 10) do
          begin
            if (i <> Y) then
              begin
                ValueA := OldGrayValue(X,i) + $80;
                NewGrayValue(X,i,ValueA);
              end;
          end;
        for i := (X - 10) to (X + 10) do
          begin
            if (i <> X) then
              begin
                ValueA := OldGrayValue(i,Y) + $80;
                NewGrayValue(i,Y,ValueA);
              end;
          end;
      end;
    end;


procedure UndrawCursor(X,Y : integer);
{ ++++++++++++++++++++++++++++++++++++++++++++++++ }

  var i,ValueA : integer;
  begin
    if ((X < 10) or (X > 502) or (Y < 10) or (Y > 502)) then
    else
      begin
        for i := (Y - 10) to (Y + 10) do
          begin
            if (i <> Y) then
              begin
                ValueA := OldGrayValue(X,i) - $80;
                NewGrayValue(X,i,ValueA);
              end;
          end;
        for i := (X - 10) to (X + 10) do
          begin
            if (i <> X) then
              begin
                ValueA := OldGrayValue(i,Y) - $80;
                NewGrayValue(i,Y,ValueA);
              end;
          end;
      end;
  end;



procedure PixelFinder;
{ ++++++NEW 10/6/87++++++++++++++++++++++++++++++++++++++++++++++++++ }

    var
      XFirst,YFirst,XLast,YLast,XOld,YOld,XTemp,YTemp,ButCount,Choice : integer;
      First : boolean;
      ValueA : byte;
      TempN,NumPix : integer;

  begin
{    BlankDrawing; }
    {clrscr;}

{    Reset_Interrupt_9;}
    {***************************************************************}
    zoomeffect := true;
    blinkeffect := false;
    zoomdelay := 20;
    shadoweffect := none;
    borderstyle := double;
    scanpage;
    createwindow(8,20,8,40,white,black,white,black);
    {***************************************************************}
    GotoXY(34,8);
    writeln('PIXEL FINDER');
    GotoXY(27,14);
    writeln('Press Button #1 to CONTINUE');
    Delay(500);
    ButDig := 0;
    ErrDig := 0;
    repeat
      DigitLocate(XDig,YDig,ButDig,ErrDig);
    until (ErrDig = 0);
    XOld := XDig;
    YOld := YDig;
    DrawCursor(XOld,YOld);

    repeat
      repeat
        DigitLocate(XDig,YDig,ButDig,ErrDig);
      until (ErrDig = 0);
      UnDrawCursor(XOld,YOld);
      DrawCursor(Xdig,Ydig);
        ValueA := OldGrayValue(XDig,YDig);
        GotoXY(24,11);
        writeln('X = ',XDig:3,'    Y = ',YDig:3,'    Value = ',ValueA:3);
      XOld := XDig;
      YOld := YDig;
    until (ButDig = 1);
    Repeat
      DigitLocate(Xdig,Ydig,ButDig,Errdig);
    Until (ButDig = 0);
    UnDrawCursor(XOld,YOld);
    zoomdelay := 0;
    destroywindow(8,20,8,40,white,black);
 end;



procedure RetrieveFile(PathName : string);
{ ++++++++++++++++++++++++++++++++++++++++++++++++ }
  var PictureFile      : file;
      Block,X,Y,YY     : integer;
      Offset           : word;
      ValueBlock       : ValueBlockType;
      OldTemp,NewTemp  : integer;
      FileName         : string;

  begin
     FileName := PathName;
     if (FileExists(FileName)) then
      begin
        AcquireSingle;
        assign(PictureFile,FileName);
        reset(PictureFile);
{$IFDEF PCPLUS}
        OldTemp := Port[Control] and $1F;    { mask bits 7,6,5 }
        for Block := 0 to 3 do
          begin
            case Block of
              0 : NewTemp := OldTemp;
              1 : NewTemp := OldTemp + $20;
              2 : NewTemp := OldTemp + $40;
              3 : NewTemp := OldTemp + $60;
            end;
            Port[Control] := NewTemp;
            for Y := 0 to 127 do
              begin
                YY := 512 * Y;
                BlockRead(PictureFile,ValueBlock,4);
                for X := 0 to 511 do
                  begin
                    Offset := YY + X;
                    Mem[MemBase : Offset] := ValueBlock[X];
                  end;
               end;
           end;
{$ENDIF}
{$IFDEF PCVISION}
        for Block := 0 to 3 do
          begin
            Port[FBB0] := Block;
            for Y := 0 to 255 do
              begin
                YY := 256 * Y;
                BlockRead(PictureFile,ValueBlock,2);
                for X := 0 to 255 do
                  begin
                    Offset := YY + X;
                    Mem[MemBase : Offset] := ValueBlock[X];
                  end;
               end;
           end;
{$ENDIF}
        close(PictureFile);
      end;
  end;


procedure SaveFile(FileName : string);
{ ++++++++++++++++++++++++++++++++++++++++++++++++ }
  var PictureFile      : file;
      X,Y,YY,Block     : integer;
      Offset           : word;
      ValueBlock       : ValueBlockType;
      OldTemp,NewTemp  : integer;
      ch,ch2 : char;
      Good             : boolean;

  begin
    Ch := 'Y';
    if (UpCase(ch) = 'Y') then
      begin
        assign(PictureFile,FileName);
        rewrite(PictureFile);
{$IFDEF PCVISION}
        for Block := 0 to 3 do
          begin
            Port[FBB0] := Block;
            for Y := 0 to 255 do
              begin
                YY := 256 * Y;
                for X := 0 to 255 do
                  begin
                    Offset := YY + X;
                    ValueBlock[X] := Mem[MemBase : Offset];
                  end;
                  BlockWrite(PictureFile,ValueBlock,2);
               end;
           end;
{$ENDIF}
{$IFDEF PCPLUS}
        OldTemp := Port[Control] and $1F;
        for Block := 0 to 3 do
          begin
            case Block of
              0 : NewTemp := OldTemp;
              1 : NewTemp := OldTemp + $20;
              2 : NewTemp := OldTemp + $40;
              3 : NewTemp := OldTemp + $60;
            end;
            Port[Control] := NewTemp;
            for Y := 0 to 127 do
              begin
                YY := 512 * Y;
                for X := 0 to 511 do
                  begin
                    Offset := YY + X;
                    ValueBlock[X] := Mem[MemBase : Offset];
                  end;
                  BlockWrite(PictureFile,ValueBlock,4);
               end;
           end;
{$ENDIF}
        close(PictureFile);
      end;
  end;

procedure SubtractFile(FileName : string);
{ ++++  MOD 11/10/87 to force displayed byte to even  +++++++++++++++++++++++ }
{====== MOD 12/22/87 to permit display of odd byte ========================== }
  var PictureFile      : file;
      X,Y,YY,Block     : integer;
      Offset           : word;
      ValueBlock       : ValueBlockType;
      ValueHi,ValueLo  : integer;
      DisplayedByte,
      StoredByte:        integer;
      OldTemp,NewTemp  : integer;
      Ch               : char;

  function max(a,b : byte) : byte;
    begin
      if a >= b then max := a
        else max := b;
    end;

  begin
    if (FileExists(FileName)) then
      begin
        ValueLo := 255;
        ValueHi := 0;
        AcquireSingle;
        assign(PictureFile,FileName);
        reset(PictureFile);
{$IFDEF PCVISION}
        for Block := 0 to 3 do
          begin
            Port[FBB0] := Block;
            for Y := 0 to 255 do
              begin
                BlockRead(PictureFile,ValueBlock,2);
                YY := 256 * Y;
                for X := 0 to 255 do
{$ENDIF}
{$IFDEF PCPLUS}
        OldTemp := Port[Control] and $1F;
        for Block := 0 to 3 do
          begin
            case Block of
              0 : NewTemp := OldTemp;
              1 : NewTemp := OldTemp + $20;
              2 : NewTemp := OldTemp + $40;
              3 : NewTemp := OldTemp + $60;
            end;
            Port[Control] := NewTemp;
            for Y := 0 to 127 do
              begin
                BlockRead(PictureFile,ValueBlock,4);
                YY := 512 * Y;
                for X := 0 to 511 do
{$ENDIF}
                  begin
                    Offset := YY + X;
                    DisplayedByte := Mem[MemBase : Offset];
                    StoredByte := ValueBlock[X];
                    DisplayedByte := DisplayedByte + (256 - StoredByte);
                    if (DisplayedByte > 255) then
                      if ((DisplayedByte and 1) = 1) then
                        DisplayedByte := 255
                      else DisplayedByte := 254
                    else if (DisplayedByte < 0) then
                      if ((DisplayedByte and 1) = 1) then
                        DisplayedByte := 1
                       else DisplayedByte := 0;
                    if DisplayedByte > ValueHi then
                      ValueHi := DisplayedByte;
                    if DisplayedByte < ValueLo then
                      ValueLo := DisplayedByte;
                    Mem[MemBase : Offset] := DisplayedByte;
                  end;
               end;
           end;
        close(PictureFile);
        Beep;
        StretchLow := ValueLo;
        StretchHigh := ValueHi;
        StretchLUT;
        while KeyPressed do ch := ReadKey;
        MakeWindow2;
          GotoXY(20,12);
          write('Do you wish to save this image? (Y/N) : ');
          Ch := UpCase(ReadKey);
        UnMakeWindow2;
        if (Ch = 'Y') then SaveFile('myfile');
      end
    else
      begin
        Beep;
        while KeyPressed do Ch := ReadKey;
        MakeWindow1;
        GotoXY(28,12);
        write('  IMAGE FILE NOT FOUND');
        GotoXY(28,13);
        write('Press Any Key to Continue');
        repeat until KeyPressed;
        UnMakeWindow1;
      end;
  end;

(*
procedure StoreShading;
{ ++++++++++++++++++++++++++++++++++++++++++++++++ }
  var Ch : char;
  begin

    MakeWindow2;
    GotoXY(10,12);
    write('Storing a Shading Correction will Destroy the Displayed Image');
    GotoXY(20,14);
    write('ENTER Y TO PROCEED - N TO QUIT  :');
    Ch := ReadKey;
    if (UpCase(Ch) = 'Y') then
      begin
        AcquireContinuous;

        MakeWindow1;
        GotoXY(26,12);
        write('PLEASE SET UP A BLANK IMAGE');
        GotoXY(23,14);
        write('ENTER Y WHEN BLANK IMAGE IS SET UP  :');
        Ch := ReadKey;
        UnMakeWindow1;
        if (UpCase(Ch) = 'Y') then
          begin

            MakeWindow1;
            AcquireSingle;
            GotoXY(29,12);
            write('This will take a moment');
            SaveFile('SHADING.COR');
            AcquireContinuous;
            UnMakeWindow1;
          end;
      end;
    UnMakeWindow2;
  end;


procedure ShadingCorrect;
{========================}
var Ch : char;
begin

  MakeWindow1;
  GotoXY(29,12);
  write('This will take a moment');
  while KeyPressed do Ch := ReadKey;
  SubtractFile('SHADING.COR');
  UnMakeWindow1;
end;
*)
procedure StoreShading;
{ ++++++++++++++++++++++++++++++++++++++++++++++++ }
  var Ch : char;
  begin
    MakeWindow2;
    GotoXY(10,12);
    write('Storing a Shading Correction will Destroy the Displayed Image');
    GotoXY(20,14);
    write('ENTER Y TO PROCEED - N TO QUIT  :');
    Ch := ReadKey;
    if (UpCase(Ch) = 'Y') then
      begin
        AcquireContinuous;
        MakeWindow1;
        GotoXY(26,12);
        write('PLEASE SET UP A BLANK IMAGE');
        GotoXY(23,14);
        write('ENTER Y WHEN BLANK IMAGE IS SET UP  :');
        Ch := ReadKey;
        UnMakeWindow1;
        if (UpCase(Ch) = 'Y') then
          begin
{$IFDEF PCPLUS}
            Port[PanFG] := 64;
            ClearDisplay;
            AcquireContinuous;
            Delay(500);
            AcquireSingle;
            Port[PanFG] := 0;
            AcquireContinuous;
{$ENDIF}
{$IFDEF PCVISION}
            MakeWindow1;
            AcquireSingle;
            GotoXY(29,12);
            write('This will take a moment');
            SaveFile('SHADING.COR');
            AcquireContinuous;
            UnMakeWindow1;
{$ENDIF}
          end;
      end;
    UnMakeWindow2;
  end;


procedure ShadingCorrect;
{========================}
var Ch : char;
begin
  MakeWindow1;
  GotoXY(29,12);
  write('This will take a moment');
{$IFDEF PCPLUS}
inline($B9/$04/$00/      { MOV	CX,0004     ; load counter with 4 }
{#1}
       $33/$C0/          { XOR	AX,AX       ; zero out ax }
       $BA/$00/$03/      { MOV	DX,0300     ; load control register address }
       $EC/              { IN	AL,DX       ; read in from register }
       $24/$1F/          { AND	AL,1F       ; mask 3 MSBs }
       $50/              { PUSH	AX          ; save it }
(*
       $B8/$04/$00/      { MOV	AX,4 }
       $2B/$C1/          { SUB	AX,CX }
*)
       $89/$C8/$90/      { MOV AX,CX }      { do correction from bottom up }
       $48/$90/          { DEC AX  }

       $51/              { PUSH CX }
       $B1/$05/          { MOV  CL,05}
       $D3/$E0/          { SHL  AX,CL}

       $8B/$D8/          { MOV	BX,AX       ; copy result to bx }
       $59/              { POP  CX}
       $58/              { POP	AX          ; recall value }
       $03/$C3/          { ADD	AX,BX       ; and add it to shifted counter }
       $89/$C7/          { MOV	DI,AX       ; save result in di register }

       $51/              { PUSH CX}
       $E8/$06/$00/      { CALL	#2          ; and jump to #2}

       $59/              { POP	CX          ; restore the counter }
       $E2/$DE/          { LOOP	#1          ; and do it again }

       $EB/$43/          { JMP DONE}
       $90/              { NOP}

{#2}
       $B9/$FE/$FF/      { MOV	CX,FFFE     ; load counter with 64k }
{#6}
       $89/$F8/          { MOV	AX,DI       ; recall register value }
       $05/$80/$00/      { ADD	AX,0080     ; add $80 to it }
       $EE/              { OUT	DX,AL       ; set the block }
       $8B/$D9/          { MOV	BX,CX       ; copy counter to bx for offset }

       $B8/$00/$A0/      { MOV	AX,A000     ; copy video segment to ax }
       $8E/$C0/          { MOV	ES,AX       ; and then to es }

       $26/$8A/$07/      { MOV	AL,ES:[BX]  ; read video memory MEM_B }
       $32/$E4/          { XOR AH,AH }

       $50/              { PUSH	AX          ; save value }
       $89/$F8/          { MOV	AX,DI       ; recall register value }
       $EE/              { OUT	DX,AL       ; set the block }
       $26/$8A/$07/      { MOV	AL,ES:[BX]  ; read video memory MEM_A }
       $32/$E4/          { XOR AH,AH }

       $5B/              { POP	BX          ; recall MEM_B }
       $29/$D8/          { SUB	AX,BX       ; and subtract result from MEM_A }
       $05/$00/$01/      { ADD	AX,0100     ; now add 256 }
       $3D/$00/$00/      { CMP	AX,0000     ; is it less than 0? }
       $7C/$08/          { JL	#3          ; then branch to #3 }
       $3D/$FF/$00/      { CMP	AX,00FF     ; is it greater than 255? }
       $7F/$09/          { JG	#4          ; then branch to #4 }
       $EB/$0A/          { JMP	#5          ; ok, then branch to #5 }
       $90/              { NOP }
{#3}
       $B8/$00/$00/      { MOV	AX,0000     ; set it to 0 }
       $EB/$04/          { JMP	#5 }
       $90/              { NOP }
{#4}
       $B8/$FE/$00/      { MOV	AX,00FE     ; set it to 254 }
{#5}
       $8B/$D9/          { MOV	BX,CX       ; load offset into bx }
       $26/$88/$07/      { MOV	ES:[BX],AL  ; write out to video location }

       $E2/$C2/          { LOOP #6          ; and return }
       $C3/              {RET}
       $90);
{$ENDIF}
{$IFDEF PCVISION}
  while KeyPressed do Ch := ReadKey;
  SubtractFile('SHADING.COR');
{$ENDIF}
  UnMakeWindow1;
end;




End.
