{AUTHOR : Jonathan Kraidin
 PURPOSE: Global variables used by all routines.  The main purpose
          of these variables is for setting thresholds which can
          be modified by the Learn routines.}

Unit AIGLOB;

Interface

Type ImagType2 = array[1..3036] of word;

     offlimits = record                 {used to mark area of cell}
                  x : word;
                  y : word;
                 end;

     limitarray = array[1..30] of offlimits;

    Type
     Celltype = record
       Area       : word;
       Perimeter  : word;
       _area,
       _perim     : word;
       xcoord     : word;
       ycoord     : word;
       good       : boolean;
       gray       : byte;
       mval       : double;
       black      : double;
       foregnd    : double;
       _stdev     : double;
       dadb       : word;
       score      : word;
       stdx,
       forx       : double;
       kux,
       cytost,
       rx1,rx2    : double;

     end;

     Cells = array[1..50] of celltype;

Const
    GraphOn = true;
    SpecDis = true;
    filteron = false;
    EdgeThreshold = 100;
    PlotShift = 0;
    PlotScale = 3;
    CutOffLow    = 00;
    CutOffHigh   = 254;
Var
    CellCount               : word;
    Xdig,Ydig,Butdig,Errdig : integer;
    CenterLighter           : boolean;
    LearnMode               : boolean;
    AiCells                 : Cells;
    GrayStrike,
    CriticalValue,
    CriticalHigh,
    Lowdiv                  : byte;

    MinArea,MaxArea         : word;
    Firstx,ScoreX           : word;
    MinBlack,MaxBlack       : double;
    _stqset,_stqxset        : double;
    forset,forxset          : double;
    MvalX                   : double;
    MvalHigh,MvalLow        : double;
    dadbX                   : word;
    DaDbq                   : double;
    ShapeHigh,
    shapeLow                : double;
    kuLow,Kuhigh,
    cytoset,
    rx1low,rx1high,
    rx2low,rx2high          : double;

    Calibfactor2            : double;

Implementation

end.