-- Problem 2.5
-- by Rick Conn
with Text_IO;
procedure Main is

  type BOOLEAN_VECTOR is array (1..4) of BOOLEAN;
  T : constant BOOLEAN := TRUE;
  F : constant BOOLEAN := FALSE;

  A : constant BOOLEAN_VECTOR := (F, F, T, T);
  B : constant BOOLEAN_VECTOR := (F, T, F, T);

  B_AND : BOOLEAN_VECTOR;
  B_OR  : BOOLEAN_VECTOR;
  B_XOR : BOOLEAN_VECTOR;

  package Bool_IO is new Text_IO.Enumeration_IO (BOOLEAN);

begin -- Main

  B_AND := A and B;
  B_OR  := A or B;
  B_XOR := A xor B;

  Text_IO.Put_Line ("A     B     and   or    xor");
  for I in 1 .. 4 loop
    Bool_IO.Put (A(I), 6);
    Bool_IO.Put (B(I), 6);
    Bool_IO.Put (B_AND(I), 6);
    Bool_IO.Put (B_OR(I), 6);
    Bool_IO.Put (B_XOR(I), 6);
    Text_IO.New_Line;
  end loop;

end Main;
