#define HEADER "C++ Problem 5.2 by Rick Conn using Borland C++"

#include <stdio.h>

enum pet_kind {doggy, kitty, neither};

class pet {
  pet_kind pk;
public:
  pet(pet_kind);
  void speak(void);
  pet_kind type(void);
};

class dog : public pet {
public:
  dog();
  void speak(void);
};

class cat : public pet {
public:
  cat();
  void speak(void);
};

pet::pet(pet_kind kind) {
  pk = kind;
}

void pet::speak(void) {
  printf("silence\n");
}

pet_kind pet::type(void) {
  return pk;
}

dog::dog() : pet(doggy) {
  // nothing to do
}

void dog::speak(void) {
  printf("woof\n");
}

cat::cat() : pet(kitty) {
  // nothing to do
}

void cat::speak(void) {
  printf("meow\n");
}

void talk (pet *p) {
  switch (p->type()) {
    case doggy : ((dog *)p) -> speak();
                 break;
    case kitty : ((cat *)p) -> speak();
                 break;
    default    : p -> speak();
                 break;
  }
}

void main(void)
{
  printf("%s\n", HEADER);

  dog scotty;
  cat fluffy;
  pet funny (neither);
  
  talk(&scotty);
  talk(&fluffy);
  talk(&funny);
}
