-- Problem 3.2
-- by Rick Conn
with Text_IO;
procedure Main is

  type CHAR_TYPE is (LOWER_CASE, UPPER_CASE, SHARP, COMMA,
                     SEMICOLON, DIGIT, SOME_OTHER);

  Char_List : constant STRING := "a#B,;2c8&1";

  package Char_Type_IO is new Text_IO.Enumeration_IO (CHAR_TYPE);

  function Char_Class (Item : in CHARACTER) return CHAR_TYPE is
    Result : CHAR_TYPE;
  begin
    case Item is
      when 'A' .. 'Z' => Result := UPPER_CASE;
      when 'a' .. 'z' => Result := LOWER_CASE;
      when '0' .. '9' => Result := DIGIT;
      when '#'        => Result := SHARP;
      when ','        => Result := COMMA;
      when ';'        => Result := SEMICOLON;
      when others     => Result := SOME_OTHER;
    end case;
    return Result;
  end Char_Class;

begin -- Main

  for I in Char_List'RANGE loop
    Text_IO.Put ("Character " & Char_List(I) & " is of type ");
    Char_Type_IO.Put (Char_Class(Char_List(I)));
    Text_IO.New_Line;
  end loop;

end Main;
