-- Problem 1.3
-- by Rick Conn
package example is

  function square (item : in float) return float;  -- spec

  procedure display (item : in integer);  -- spec

  procedure display (item : in float);  -- spec
    -- overloading of the procedure display with different
    -- parameter types is fine in Ada

end example;

with text_io;
package body example is

  package int_io is new text_io.integer_io (integer);
  package flt_io is new text_io.float_io (float);

  function square (item : in float) return float is -- body
  begin
    return item * item;
  end square;

  procedure display (item : in integer) is  -- body
  begin
    text_io.put ("Integer number: ");
    int_io.put (item, 4);
    text_io.new_line;
  end display;

  procedure display (item : in float) is  -- body
  begin
    text_io.put ("Floating point number: ");
    flt_io.put (item, 5, 4, 0);
    text_io.new_line;
  end display;

end example;

with example;
procedure demo is

  result : float;

begin

  result := example.square (2.2);
  example.display (result);  -- float display
  example.display (2);       -- integer display

end demo;
