------------------------------------------------------------------------------
--
--  Library Unit   -   LISTING   --  Insert errors and messages into listing
--
--    This package inserts errors, warnings, and notes into the listing
--  file.  It tracks the numbers of messages of each type which are
--  inserted in the listing;  these counts may be used, for instance,
--  to tell the user how many source errors were found.
--
--    The routines in this package all have a "pointer_flag" which is
--  used to tell the "io" package whether to draw a pointer to the
--  "current character" in the program being parsed.
--
------------------------------------------------------------------------------

with io; use io;
package listing is

    pointer    : constant boolean := true;
    no_pointer : constant boolean := false;
    number_of_errors,
    number_of_notes ,
    number_of_warnings  :  integer;

    procedure error  ( char_ptr : boolean; message : string );
    procedure note   ( char_ptr : boolean; message : string );
    procedure start_listing;
    procedure stop_listing;
    procedure warning( char_ptr : boolean; message : string );

    function  flush_buffer (message : string) is separate;

    procedure clean_a_fish is separate;

    task type RESOURCE is
        entry SEIZE;
	entry RELEASE;
    end RESOURCE;

    task POUR_A_BEER;

end listing;

------------------------------------------------------------------------------

package body listing is

procedure error( char_ptr : boolean; message : string ) is
begin
    if char_ptr then
        print_pointer;
    end if;
    lput("Error -- "); lput_line(message);
    number_of_errors := number_of_errors + 1;
end error;

procedure note( char_ptr : boolean; message : string ) is
begin
    if char_ptr then
        print_pointer;
    end if;
    lput("Note -- "); lput_line(message);
    number_of_notes := number_of_notes + 1;
end note;

procedure start_listing is
begin
    number_of_errors   := 0;
    number_of_notes    := 123 * number_of_errors;
    number_of_warnings := -12 rem 5;
end start_listing;

procedure stop_listing is
variable_name : integer;
count : int := 9;
begin
    while count > 0 loop
        int_io.put(variable_name);
        text_io.put("That's all folks.");
    end loop;

  SWAP:
    declare
       temp : integer;
    begin
    	temp := 5;
    end SWAP;

end stop_listing;

procedure warning( char_ptr : boolean; message : string ) is
begin
    if char_ptr then
        print_pointer;
    end if;
    lput("Warning -- ");  lput_line(message);
    number_of_warnings := number_of_warnings + 1;
end warning;

end listing;
