--***************************************************************--
--                                                               --
--  TITLE:          AN ADA SOFTWARE METRIC                       --
--                                                               --   
--  MODULE NAME:    PACKAGE SPECIFICATION PARSER_3               --
--  FILE NAME:      PARSER3.ADS                                  --
--                                                               --
--  LAST MODIFIED:  02 MAR 90                                    --
--                                                               --
--  DESCRIPTION:  This package contains thirty-five functions    --
--       that make up the baseline productions for our top-down, --
--       recursive descent parser.  Each function is preceded    --
--       by the grammar productions they are implementing.       --
--                                                               --  
--  CHANGE LOG:                                                  -- 
--              - modified function NAME to parse the colon      --
--                that follows usage of the optional name for    --
--                loops or blocks. If a colon is present, NAME   --
--                passes back false since it is being called     --
--                from other than BLOCK_STATEMENT or LOOP_       --
--                STATEMENT.                                     --
--                                                               --
--  COPYRIGHT:  The Ada source code in this file is Copyright    --
--              1990 by Source Translation & Optimization. There --
--              are no restrictions to the use of this source    --
--              code in any product or system that is released   --
--              in non-source code form. Resale of this source   --
--              code, without permission of STO, is a violation  --
--              of our Copyright.                                --
--                                                               --
--                                                               --
--  HELP:       For more information contact: Gregory Aharonian  --
--              Source Translation & Optimization, P.O. Box 404  --
--              Belmont, MA, 02178-0404            617-489-3727  --
--***************************************************************--

package PARSER_3 is

  function  SUBTYPE_INDICATION                 return boolean;
  function  ARRAY_TYPE_DEFINITION              return boolean;
  function  CHOICE                             return boolean;
  function  ITERATION_SCHEME                   return boolean;
  function  EXPRESSION                         return boolean;
  function  SIMPLE_EXPRESSION                  return boolean;
  function  CONSTRAINT                         return boolean;
  function  FLOATING_OR_FIXED_POINT_CONSTRAINT return boolean;
  function  RANGES                             return boolean;
  function  NAME                               return boolean;
  function  INTEGER_TYPE_DEFINITION            return boolean;
  function  DISCRETE_RANGE                     return boolean;
  function  EXIT_STATEMENT                     return boolean;
  function  RETURN_STATEMENT                   return boolean;
  function  GOTO_STATEMENT                     return boolean;
  function  DELAY_STATEMENT                    return boolean;
  function  ABORT_STATEMENT                    return boolean;
  function  RAISE_STATEMENT                    return boolean;

--
-- The following procedures are declared locally in the package body
--
--    function LOOP_PARAMETER_SPECIFICATION return boolean;
--    function RELATION                     return boolean;
--    function RELATION_TAIL                return boolean;
--    function SIMPLE_EXPRESSION_TAIL       return boolean;
--    function TERM                         return boolean;
--    function FACTOR                       return boolean;
--    function PRIMARY                      return boolean;
--    function INDEX_CONSTRAINT             return boolean;
--    function AGGREGATE                    return boolean;
--    function COMPONENT_ASSOCIATION        return boolean;
--    function ALLOCATOR                    return boolean;
--    function NAME_TAIL                    return boolean;
--    function LEFT_PAREN_NAME_TAIL         return boolean;
--    function ATTRIBUTE_DESIGNATOR         return boolean;


end PARSER_3;
