;DISC.CMD  Used for disconnecting from BBSs

SET PARITY EVEN          ;Set parity and databits
SET DATABITS 7           ; for communicating with Telenet
LABEL1:                  ;Loop to here in case of failed attempt
PAUSE 1                  ;Start "escape to command mode" sequence: wait one second
TRANSMIT "+++"           ;Send "+++" to escape to command mode
WAITFOR "OK" 3           ;Wait a maximum of three seconds for "OK" prompt
IF NOT WAITFOR           ;If no "OK" prompt,
  GOTO LABEL1            ;Try again
ENDIF
TRANSMIT "ATZ!"          ;Otherwise, reset remote modem
WAITFOR "OK"             ;Wait for "OK" prompt
TRANSMIT "ATH0!"         ;Send disconnect command
WAITFOR "OK"             ;Wait for "OK" prompt
PAUSE 1                  ;Allow user to see results
CLEAR                    ;Clear screen
LOCATE 11,14             ;Locate for message
MESSAGE "BBS has been disconnected.  Start VERSA now <Y/N>?"
LABEL2:                  ;Loop to here in case of erroneous input
LOCATE 11,65             ;Locate for user input
GET S6 1                 ;Get user input (1 character)
SWITCH S6                ;Decision based on S6 (user input)
  CASE "Y"               ;If the user enters "Y",
    EXECUTE "VERSA.CMD"  ; then start VERSA.CMD
  ENDCASE
  CASE "N"               ;If the user enters "N",
    CLEAR                ; clear screen,
    EXIT                 ; and exit
  ENDCASE
  CASE "E"               ;If the user enters "E",
    CLEAR                ; clear screen,
    EXIT                 ; and exit
  ENDCASE
  DEFAULT                ;Erroneous input
    LOCATE 11,65         ;Locate cursor,
    MESSAGE "^G "        ; beep, erase erroneous input,
    GOTO LABEL2          ; and redo the GET
  ENDCASE
ENDSWITCH                ;End of decision based on user input
