/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tbackgnd.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TProgram class.
*
* $Id: tbackgnd.cpp 1.2 1994/03/09 11:50:31 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tbackgnd.hpp"
#include <string.h>

/*----------------------------- Implementation ----------------------------*/

TBackGround::TBackGround(const TRect& bounds,int fillStyle,const pattern& pat)
	: TView(bounds), fillStyle(fillStyle)
/****************************************************************************
*
* Function:		TBackGround::TBackGround
* Parameters:	bounds		- Bounding box for the background
*				fillStyle	- Style to fill the background with
*				pat			- Pattern to fill the background with
*
* Description:	Constructor for the background class.
*
****************************************************************************/
{
	memcpy(TBackGround::pat,pat,sizeof(pattern));
}

void TBackGround::draw(const TRect& clip)
/****************************************************************************
*
* Function:		TBackGround::draw
* Parameters:	clip	- Clip rectangle for the view
*
* Description:	Method to draw the background view.
*
****************************************************************************/
{
	attributes attr;
	MGL_getAttributes(&attr);

	MGL_setBackColor(getColor(1));
	MGL_setColor(getColor(2));
	MGL_setPenStyle(fillStyle);
	MGL_setPenBitmapPattern(&pat);
	MGL_setClipRect(clip);
	MGL_fillRectCoord(0,0,size.x,size.y);

	MGL_restoreAttributes(&attr);
}

TPalette& TBackGround::getPalette() const
/****************************************************************************
*
* Function:		TBackGround::getPalette
* Returns:		Pointer to the standard palette for menus.
*
****************************************************************************/
{
	static char cpBackGround[] = {1,2};

	static TPalette palette(cpBackGround,sizeof(cpBackGround));
	return palette;
}
