/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: hotkey.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Implementation for the HotKey class.
*
* $Id: hotkey.cpp 1.2 1994/03/09 11:50:25 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tkeys.hpp"

bool HotKey::operator == (const KeyEvent& event) const
/****************************************************************************
*
* Function:		HotKey::operator ==
* Parameters:	event	- Keyboard event to check
* Returns:		True if the hotkey value is present
*
****************************************************************************/
{
	if (event.keyCode != keyCode)
		return false;

	if (modifiers == mdShift) {
		// Handle the tricky case of any shift key modifier, as either the
		// left or the right key may be used.

		return (event.modifiers & mdLeftShift)
			|| (event.modifiers & mdRightShift);
		}
	else
		return (event.modifiers & mdKey) == modifiers;
}
