/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tlabel.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TLabel class. The TLabel class
*				is a special type of static text label that when clicked
*				can be used to selected another view (such as a list box
*				or input line).
*
* $Id: tlabel.cpp 1.2 1994/03/09 11:50:36 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tsttext.hpp"

/*----------------------------- Implementation ----------------------------*/

void TLabel::handleEvent(TEvent& event,phaseType)
/****************************************************************************
*
* Function:		TLabel::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TLabel class. We simply
*				determine if the static text item has been clicked,
*				selecting the attached view if it was.
*
****************************************************************************/
{
	if (event.what == evMouseDown && (event.mouse.buttons & mbLeftButton)) {
		if (attached && !(attached->getState() & sfDisabled))
			attached->select();
		clearEvent(event);
		}
}
