/*
**  Define structure for bbscfg.dat file
**  allows dynamic reconfiguration of the bbs system.
*/

#ifndef BBSCFG_DEF

#define BBSCFG_DEF

#define ASK_HANDLE      0
#define ASK_REALNAME    1
#define ASK_ADDRESS     2
#define ASK_CITYST      3
#define ASK_ZIP         4
#define ASK_HOMEPHONE   5
#define ASK_WORKPHONE   6
#define ASK_SEX         7
#define ASK_BIRTHDAY    8

#define CHANGE_HANDLE    0
#define CHANGE_REALNAME  1
#define CHANGE_ADDRESS   2
#define CHANGE_CITYST    3
#define CHANGE_ZIP       4
#define CHANGE_HOMEPHONE 5
#define CHANGE_WORKPHONE 6
#define CHANGE_MALEFEMALE 7
#define CHANGE_COMMENT   8

struct killtime
{
	int khour;
	int kminute;
	int kday;
};

struct menu_rec
{
	char select_char[30][6];
    char action[30][30];
	int cost[30];
};

struct cfg_rec
{
	char sysop[uidlen];
	int nchans;
	int visitors_allowed;
        char modem_init_str[65][40];
        int fixedbaud[65];
        int irqn[65];
        int haddr[65];                          /* address of hayes modems */
        unsigned int hbaud[65];         /* speed  of hayes modems */
        int flowctl[65];                        /* 0=none, 1=Xon/Xoff, 2=RTS/CTS */
        char line_parms[65][4];         /* default is 8N1 */
	int makenewaccts;
	int newacctpriv;
	int onlinetimer[6];
	int daylimit[6];
	char attach_path[30];		/* path for files attached to email */
	char sysop_password[12];
	int sysop_chat;
	int logactive;
	int minage;					/* minimum age to gain system access */
	long bul_must_read_flags;
	long cfgaccessflags;
        long cfgdloadflags[2];
        long cfguploadflags[2];
	long cfgmsgpostflags[2];
	long cfgmsgreadflags[2];
	struct killtime kt[4];
	char msgsubj[64][30];
	char moderator[64][20];
	int anonymous_allowed[64];
	char ext_prots_ul[8][20];
	char ext_prots_dl[8][20];
	int main_menu_cost;
        int idleminutes;                /* unused! */
	char work_file_path[30];	/* path to open work files on */
	unsigned upload_ratio;
	unsigned long newacctcredits;	/* credits to give new accounts */
	unsigned long newuplcredits;/* give the guy credit for uploads */
	unsigned int uplratio;
	char unused[8];
	char logon_doors[8][40];
	int setup_query[10];		/* which questions will be asked */
	int change_allowed[10];		/* which items can the user change ? */
	char timed_doors[4][40];
        struct killtime kt_d[4];
        long int highacctnum;
        int num_accts;
        char front_door[30];
        char unused_char[36];
};


#define MAXLIB 64   /* a maximum of 64 libraries */
#define MAXCAT  20  /* with up to 20 categories per library */


struct library_cfg_rec
{
	char lib_name[30];
	char uplpath[30];
	char dl_passwd[12];
	char librarian[uidlen];
    struct category_rec
    {
        char catname[20];
        char dlpath[30];
    } category[MAXCAT];
};
#endif


