/****************************************************
 * DS2TP.C - DS2 Turbo Pascal Portuguese version
 * Descriptive statistics
 * Single file pass with array loading version
 * Computes the median, skewness and kurtosis
 * Joao C de Magalhaes 1997 jcm@mail.EUnet.pt
 */

#define VECTOR_SIZE 10000   /* for small model */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <ctype.h>

#define COUNTERS    7
#define OUTVALUES 15

#include "getfiles.tcf" /* input handling            */
#include "dsfile.c"     /* file operations           */
#include "dsmed.c"      /* array (median) operations */
#include "dsmath.tcf"   /* math operations           */
#include "dsout.c"      /* output functions          */

int main (int argc, char ** argv)
   {
   int I, Files =0;
   float DataVector[VECTOR_SIZE];
		 /* compiles under the Small model */
   long double Counters[COUNTERS],
	       OutValues[OUTVALUES];
   char FileTable[MAX_FILES][F_LINE_LEN];
   char * Cp = &FileTable[0][0];

   puts("\nEstatstica descritiva (2)");
   puts("Joao Magalhaes - 1997 - jcm@mail.EUnet.pt");
   printf("Verso de teste %s %s\n\n",
	__DATE__, __TIME__);

   for(I=0; I< sizeof(FileTable); I++) *Cp++ = 0x00;

   Files = GetFiles(FileTable, argc, argv);

   if ((!Files) || (Files > MAX_FILES))
      {
      printf("\nErro: seleccionados %d ficheiros.\n",
	     Files);
      exit(1);
      }

   printf("\n%d Ficheiros a processar:\n", Files);
   for(I=0; I<Files; I++) printf("[%2d] %s\t", I+1, FileTable[I]);
   puts("");

   for (I=0; I< Files; I++)
      {
      printf("\nFICHEIRO : %s -------------------------------",
	  FileTable[I]);
      S101Vect(Counters,
	       FileTable[I],
	       DataVector,
	       VECTOR_SIZE);
      Counters[5] = S101Mom(DataVector,
			 Counters[0],
			 Counters[1],
			 3);
      Counters[6] = S101Mom(DataVector,
			 Counters[0],
			 Counters[1],
			 4);

      S101Math(OutValues,
	    Counters);
      WOut(OutValues);
      SortFVect(DataVector, Counters[0]);
      PrintMedian( S101Med(DataVector, Counters[0]) );
      } /* end for I */

   return 0;
   } /* main version 2.1 ends. */
