/****************************************************
 * DS1TP.C - DS1 Turbo C Portuguese version
 * Descriptive statistics
 * Single file pass
 * Joao Magalhaes 1997 jcm@mail.EUnet.pt
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <ctype.h>

#define COUNTERS    5
#define OUTVALUES 12

#include "getfiles.tcf" /* input handling            */
#include "dsfile.c"     /* file operations           */
#include "dsmath.c"     /* math operations           */
#include "dsout.c"      /* output functions          */


int main (int argc, char ** argv)
   {
   int I, Files =0;
		 /* compiles under the Small model */
   long double Counters[COUNTERS],
	       OutValues[OUTVALUES];
   char FileTable[MAX_FILES][F_LINE_LEN];
   char * Cp = &FileTable[0][0];

   puts("\nEstatstica descritiva (1)");
   puts("Joao Magalhaes - 1997 - jcm@mail.EUnet.pt");
   printf("Verso de teste %s %s\n\n",
	__DATE__, __TIME__);

   for(I=0; I< sizeof(FileTable); I++) *Cp++ = 0x00;

   Files = GetFiles(FileTable, argc, argv);

   if ((!Files) || (Files > MAX_FILES))
      {
      printf("\nErro: seleccionados %d ficheiros.\n",
	     Files);
      exit(1);
      }

   printf("\n%d Ficheiros a processar:\n", Files);
   for(I=0; I<Files; I++) printf("[%2d] %s\t", I+1, FileTable[I]);
   puts("");

   for (I=0; I< Files; I++)
      {
      printf("\nFICHEIRO : %s -------------------------------",
	  FileTable[I]);
      S101Fly(Counters, FileTable[I]);

      S101Math(OutValues,
	    Counters);
      WOut(OutValues);
      } /* end for file I */

   return 0;
   } /* main version 2.1 ends. */
