comment ^

  mode3fnt.asm - Alternative text mode font.

  Jason Hood, 21 February, 2000.
  
  Usage: mode3fnt font [-s<col>] [-b<col>] [-m] [-a|e]
	 mode3fnt [+|-] [-r|u]

  where: font is the font file to use;
	 s is the color to clear the screen;
	 b is the border (frame) color;
	 m is used to reserve memory for a 16-line font, if smaller was loaded;
	 a or e will apply (execute) the mode;

  After installation:
	 no arguments will toggle off and on;
	 + will activate and set the mode;
	 - will disable and set the mode.
	 r or u will remove (uninstall);

  Default is bright yellow on blue screen color (30, 1eh) and blue border (1).
  All options can be changed at any time. Numbers can be hexadecimal by
  prefixing with '#' (eg. "s30" and "s#1e" are equivalent).

  Comments: jadoxa@hotmail.com
	    http://adoxa.homepage.com/tm/

^
		.286

VERSION_NUM	equ	100h

__TINY__	equ	0		; Define tiny model for AMIS

		INCLUDE AMIS.MAC

		@Startup

TSRcode@

	HOOKED_INTS 10h

	ALTMPX	'Adoxa', 'Mode3Fnt', VERSION_NUM


ISP_HEADER 10h, hw_reset_2Dh
	cmp	ax,3
turn_off label word
	je	mode3
	jmp	ORIG_INT10h
mode3:
	call	int10		; Set the mode
	pusha
	push	es

	mov	ax,1110h	; Set user-specified font
	mov	bx,1000h	; Font size, block 0
font_size equ $-1
	xor	dx,dx		; First character is 0
	mov	cx,256		; 256 characters
	push	cs
	pop	es
	mov	bp,offset font	; ES:BP points to the font
	call	int10

	mov	ah,0Bh		; Set frame color (BH = 0)
	mov	bx,1		; Blue
border_color equ $-2
	call	int10

	push	0b800h		; Clear video memory
	pop	es
	xor	di,di
	mov	ax,1e20h	; Bright yellow on blue and space
screen_color equ $-1
	mov	cx,4000h
	rep	stosw

	pop	es
	popa
	iret

int10:
	pushf
	call	ORIG_INT10h
	ret

fontmem db	0		; Maximum allowable font size
font	label	byte		; The font itself

TSRcodeEnd@

;-----------------------------------------------------------------------

_TEXT	SEGMENT 'CODE'
	ASSUME	cs:_TEXT, ds:_INIT, es:TGROUP, ss:NOTHING

CRLF	 equ	<13, 10>
EOL	 equ	<13, 10, '$'>

badopt	 db	"Unknown option: "
u_char	 db			"?", EOL
nofile	 db	"You must specify a file.", EOL
noload	 db	"Cannot load file.", EOL
invalid  db	"File does not appear to be a font file.", EOL
install  db	"Mode3Fnt has been installed.", EOL
removed  db	"Mode3Fnt has been removed.", EOL
noremove db	"Mode3Fnt cannot be removed at this time.", EOL
notins	 db	"Mode3Fnt is not installed.", EOL
active	 db	"Mode3Fnt is active.", EOL
inactive db	"Mode3Fnt is disabled.", EOL
nomem	 db	"Memory was not reserved to load this size font.", EOL

helpstr  db	"Mode3Fnt v1.0, by Jason Hood.", CRLF
	 db	"21 February, 2000. Freeware.", CRLF
	 db	"jadoxa@hotmail.com. http://adoxa.homepage.com/tm/", CRLF
	 db	CRLF
	 db	"Usage: mode3fnt font [-s<col>] [-b<col>] [-m] [-a|e]", CRLF
	 db	"       mode3fnt [+|-] [-r|u]", CRLF
	 db	CRLF
	 db	"font:  font file to use", CRLF
	 db	"s:     screen color (prefix with '#' for hex)", CRLF
	 db	"b:     border color", CRLF
	 db	"m:     reserve memory for a 16-line font if smaller was"
	 db	" loaded", CRLF
	 db	"a, e:  apply (execute)", CRLF
	 db	CRLF
	 db	"Once installed:", CRLF
	 db	"none:  toggle off and on", CRLF
	 db	"+:     activate and set mode", CRLF
	 db	"-:     disable and set mode", CRLF
	 db	"r, u:  remove (uninstall)", CRLF
	 db	CRLF
	 db	"Default is screen 30 (bright yellow on blue)"
	 db	" and border 1 (blue).", CRLF
	 db	"They, and the font, can be changed at any time.", EOL

installed db	0
fontfile  db	100 dup (0)
param	  db	0
maxmem	  db	0
apply	  db	0
instmem   dw	0

	@Startup2 PSP

	push	es
	push	ds
	pop	es
	mov	bx,1000h		; Set memory block to 64K
	mov	ah,4Ah			;  so it can load low if
	int	21h			;  there is no high memory.
	pop	es

	push	cs
	pop	ds
	ASSUME	ds:_TEXT

	IF_INSTALLED <short get_segment>
	jmp	short main

get_segment:
	mov	al,0
	int	2dh
	mov	es,dx		; Modify the resident code directly
	inc	installed

main:
	mov	si,81h		; Start of the command line
args:
	call	get_arg
	or	al,al
	jne	args1
	jmp	args_done
args1:
	inc	param		; Flag to indicate argument(s) specified
	cmp	al,'R'
	je	remove
	cmp	al,'S'
	jne	try_B
	mov	byte ptr screen_color,cl
	jmp	short args

try_B:
	cmp	al,'B'
	jne	try_M
	mov	byte ptr border_color,cl
	jmp	short args

try_M:
	cmp	al,'M'
	jne	try_A
	inc	maxmem
	jmp	short args
try_A:
	cmp	al,'A'
	jne	must_be_font
	inc	apply
	jmp	short args

must_be_font:
	call	load_file
	cmp	installed,0
	je	set_font
	cmp	ah,fontmem
	mov	dx,offset nomem
	ja	bad_exit
	mov	byte ptr font_size,ah
	push	si
	mov	si,offset fontdata
	mov	di,offset font
	mov	cx,ax
	rep	movsb
	pop	si
	jmp	short args
set_font:
	mov	fontmem,ah
	mov	byte ptr font_size,ah
	jmp	short args

remove:
	cmp	installed,0
	jne	remove1
not_installed:
	mov	dx,offset notins
	jmp	short bad_exit

remove1:
	UNINSTALL <short error>
	mov	dx,offset removed
good_exit:
	mov	ah,9
	int	21h
good_ret:
	mov	ax,4c00h
	int	21h

error:
	mov	dx,offset noremove
bad_exit:
	mov	ah,9
	int	21h
	mov	ax,4c01h
	int	21h

args_done:
	cmp	installed,0
	je	do_install
	jmp	toggle

do_install:
	cmp	fontfile,0
	mov	dx,offset nofile
	je	bad_exit
	mov	ah,fontmem
	mov	al,0
	cmp	maxmem,al
	je	do_install1
	cmp	ah,16
	jae	do_install1
	mov	ah,16
	mov	fontmem,ah
do_install1:
	shr	ax,4			; Paragraphs
	mov	instmem,ax
	INSTALL_TSR instmem,,TOPMEM,mcbname

mcbname:
	push	es
	mov	es,ax
	mov	si,offset fontdata
	mov	di,offset font
	mov	ch,byte ptr font_size
	mov	cl,0
	rep	movsb

	push	ds		; Lowercase the MCB name (as displayed
	push	ss		;  by MEM) 'cos it looks good.
	pop	ds		; Point DS to _INIT
	dec	ax
	mov	es,ax
	mov	di,8
	mov	si,offset _INIT:ALTMPX_SIGNATURE+8
	movsw
	movsw
	movsw
	movsw
	pop	ds
	pop	es

	cmp	apply,0
	je	no_mode
	mov	ax,3
	int	10h
no_mode:
	DISPLAY_STRING install
	ret

toggle:
	cmp	param,0 			; If we didn't see any options
	je	off_on				;  switch status
	cmp	apply,0
	je	good_ret1
mode_set:
	mov	ax,3
	int	10h
good_ret1:
	jmp	good_ret

off_on:
	xor	turn_off,0574h xor 9090h	; je mode3 <-> NOP; NOP
	mov	ax,turn_off
	mov	dx,offset inactive
	cmp	ax,9090h
	je	good_exit1
	mov	dx,offset active
good_exit1:
	jmp	good_exit

switch_on:
	mov	turn_off,0574h
	jmp	short is_inst

switch_off:
	mov	turn_off,9090h
is_inst:
	cmp	installed,0
	jne	mode_set
	jmp	not_installed

get_arg:
	segss			; SS is the only segment pointing
	lodsb			;  to the command line
	cmp	al,13		; Command line ends in CR
	jne	arg_next
	mov	al,0
	ret
arg_next:
	cmp	al,' '          ; Skip all spaces and control characters
	jbe	get_arg
	cmp	al,'?'
	je	help
	cmp	al,'+'
	je	switch_on
	cmp	al,'-'
	je	found_opt
	call	get_file
	mov	al,1
	ret
found_opt:
	cmp	byte ptr ss:[si],' ' ; Distinguish between minus and switchar
	jbe	switch_off
	segss
	lodsb
	cmp	al,'?'
	je	help
	mov	u_char,al	; Use unmodified character for error display
	and	al,0dfh 	; Force uppercase
	cmp	al,'U'
	jne	get_arg1
	mov	al,'R'
get_arg1:
	cmp	al,'R'
	jne	get_arg2
get_arg_exit:
	ret
get_arg2:
	cmp	al,'S'
	je	parse_num
	cmp	al,'B'
	je	parse_num
	cmp	al,'M'
	je	get_arg_exit
	cmp	al,'E'
	jne	get_arg3
	mov	al,'A'
get_arg3:
	cmp	al,'A'
	jne	bad_opt
	ret

bad_opt:
	mov	dx,offset badopt
	jmp	bad_exit

help:
	mov	dx,offset helpstr
	jmp	good_exit

parse_num:
	push	ax			; Remember option
	xor	cx,cx			; CX stores the number
	cmp	byte ptr ss:[si],'#'
	je	hex
	mov	bx,10			; Base 10 multiplier
digit:
	segss
	lodsb
	sub	al,'0'
	jb	end_num
	cmp	al,9
	ja	end_num
	xchg	ax,cx
	mul	bx
	add	al,cl
	xchg	ax,cx
	jmp	short digit

end_num:
	dec	si			; Back to the character that stopped
	pop	ax			;  conversion
	ret

hex:
	inc	si			; Skip the hash
hexit:
	segss
	lodsb
	or	al,20h			; Force lowercase (forcing uppercase
	sub	al,'0'                  ;  translates digits as well)
	jb	end_num
	cmp	al,9
	jbe	hex1
	cmp	al,'a' - '0'
	jb	end_num
	cmp	al,'f' - '0'
	ja	end_num
	sub	al,'a' - '0' - 10
hex1:
	shl	cl,4
	add	cl,al
	jmp	short hexit


get_file:
	mov	bx,offset fontfile
get_file1:
	cmp	al,' '
	jbe	get_file99
	mov	[bx],al
	inc	bx
	segss
	lodsb
	jmp	short get_file1
get_file99:
	mov	byte ptr [bx],0
	dec	si
	ret


load_file:
	mov	dx,offset fontfile
	mov	ax,3d00h
	int	21h
	jnc	load_okay

load_bad:
	mov	dx,offset noload
	jmp	bad_exit

load_okay:
	mov	bx,ax
	mov	ah,3fh
	mov	cx,16 * 256 + 1
	mov	dx,offset fontdata
	int	21h
	jc	load_bad
	push	ax
	mov	ah,3eh
	int	21h
	pop	ax
	cmp	al,0
	jne	bad_font
	cmp	ah,6			; Less than six could be okay,
	jb	bad_font		;  but let's assume it's not.
	cmp	ah,16			; 32 is the maximum,
	ja	bad_font		;  but 16 is all I'll allow.
	ret

bad_font:
	mov	dx,offset invalid
	jmp	bad_exit

fontdata db	16 * 256 + 1 dup (?)	; Load the font file here

_TEXT	ENDS

	end	INIT
