
#include <iomanip.h>                         // for setprecision(), setwidth()
#include <fstream.h>                         // for device i/o
#include <iostream.h>        // for C++ stuff
#include <math.h>            // for rounding
#include <dir.h>                             // for findfirst() / findnext(),
                                             // getcwd(), MAXPATH,
                                             // ..and MAXFILE (which is 9)

char inFileName[255];        // for input filename


int done;                    // for the following loop


char name[80],
     tempchar;
float  PIXEL_CLK,
       H_Period,
       H_DISP, H_FPORCH, H_SYNC, H_BPORCH, H_SYNC_POL,
       V_DISP, V_FPORCH, V_SYNC, V_BPORCH, V_SYNC_POL,
       INTERLACE_ENABLE,
       microsec,
       temp;

ifstream fin;                // create stream object for input

void setInfo ();        // prototype
long round (float);   // prototype for rounding function


int main(int argc, char **argv)
{
   struct ffblk ffblk;                       // for findfirst(), findnext()

   char choice;
   cerr << "\nMonitor Calculator - (C) Copyright 1996  Alexander Eremeef\n"
        << "-- written September 10, 1996 -- for the MGA.MON data file.\n"
        << "-- converts microsecond timing data back into MGA.MON format..\n"
        << "----------------------------------------------------------\n\n";

   int FileFlag=1;       // for later error flag

   if (argc > 1)
   {
     done = findfirst( argv[1], &ffblk, 0 );
     if (!done)
        FileFlag = 0;
   }
   while (FileFlag > 0)
   {
     cerr << "Please enter the name of the file:  \x1B[1;37m";
     cin >> inFileName;
     cerr << "\x1B[0m";

     done = findfirst( inFileName, &ffblk, 0 );

     if (done)
        cerr << "\n\a\x1B[1;36mERROR:  '\x1B[1;37m" << inFileName
             << "\x1B[1;36m'  does not exist!\x1B[1;33m\n\n";
     else
        FileFlag = 0;
   }

   fin.open( ffblk.ff_name );                             // open file
   cerr << "\n\nProcessing file:  " << ffblk.ff_name << "\n\n";

//---------------------------------------------------------------------------
   do
      {
      while (fin.peek() != '[' && fin.good())
         fin.ignore(255,'\n');

      if (!fin.good())
         break;

      setInfo();

      choice = fin.peek();                        // get the answer..
      }
   while (choice != 'n' && choice != 'q' && fin.good());
                                            // quit on 'n', 'q', or EOF
return 0;
}

//---------------------------------------------------------------------------
      void setInfo()                        // constructor, no args
      {
         fin.get(name,80,'\n').get();

         fin.ignore(255,'=');
         fin >> PIXEL_CLK;
         fin.ignore(255,'=');
         fin.ignore(255,'=');
         fin.ignore(255,'=');
         fin >> H_Period;
         fin.ignore(255,'=');
         fin >> H_DISP;
         fin.ignore(255,'=');
         fin.ignore(255,'=');
         fin >> H_FPORCH;
         fin.ignore(255,'=');
         fin >> H_SYNC;
         fin.ignore(255,'=');
         fin >> H_BPORCH;
         fin.ignore(255,'=');

         fin >> tempchar;
         if (tempchar == '-')
            H_SYNC_POL = 0;
         else if (tempchar == '+')
            H_SYNC_POL = 1;
         else
            H_SYNC_POL = -1;

         fin.ignore(255,'=');
         fin.ignore(255,'=');
         fin >> V_DISP;
         fin.ignore(255,'=');
         fin.ignore(255,'=');
         fin >> V_FPORCH;
         fin.ignore(255,'=');
         fin >> V_SYNC;
         fin.ignore(255,'=');
         fin >> V_BPORCH;
         fin.ignore(255,'=');

         fin >> tempchar;
         if (tempchar == '-')
            V_SYNC_POL = 0;
         else if (tempchar == '+')
            V_SYNC_POL = 1;
         else
            V_SYNC_POL = -1;

         fin.ignore(255,'=');
         fin >> INTERLACE_ENABLE;
         fin.ignore(255,'\n');



         cout << setiosflags(ios::fixed)

              << name << endl

              << "PIXEL_CLK  = "
              << round(PIXEL_CLK * 1000) << "\n"

              << "H_DISP     = "
              << round(H_DISP * PIXEL_CLK) << endl

              << "H_FPORCH   = "
              << round(H_FPORCH * PIXEL_CLK) << endl

              << "H_SYNC     = "
              << round(H_SYNC * PIXEL_CLK) << endl

              << "H_BPORCH   = "
              << round(H_BPORCH * PIXEL_CLK) << endl

              << "H_SYNC_POL = ";

         if (H_SYNC_POL == 0)
            cout << '0';
         else if (H_SYNC_POL == 1)
            cout << '1';
         else
            cout << '?';

         cout << endl
//-------
              << "V_DISP     = "
              << round(V_DISP / H_Period) << endl

              << "V_FPORCH   = "
              << round(V_FPORCH / H_Period) << endl

              << "V_SYNC     = "
              << round(V_SYNC / H_Period) << endl

              << "V_BPORCH   = "
              << round(V_BPORCH / H_Period) << endl

              << "V_SYNC_POL = ";

         if (V_SYNC_POL == 0)
            cout << '0';
         else if (V_SYNC_POL == 1)
            cout << '1';
         else
            cout << '?';

         cout << endl
              << "INTERLACE_ENABLE = "
              << INTERLACE_ENABLE << "\n\n";
      }

//---------------------------------------------------------------------------
      long round (float number)
      {
         long   ltemp;
         float  ftemp;

         ltemp = floor(number);
         ftemp = number - ltemp;

         if (ftemp < 0.5)
            return ltemp;
         else
            return ceil(number);
      }

