 REM Sic.bas v6.4b r1.0 - Symbolic Instruction Code; module 1 of 3.
 REM The public domain DOS programming interpreter.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' backwards compatible for bc 7.1
 REM $INCLUDE: 'bc7.inc'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' program variables
 REDIM Commands(1 TO MaxCommands) AS STRING
 REDIM Statements(1 TO MaxStatements + 3) AS STRING

 ' program code
 REDIM GosubReturn(1 TO 10) AS INTEGER
 REDIM Program(1 TO Max.Lines) AS STRING

 ' program data
 REDIM Arrays(0 TO 26, 0 TO Max.Arrays) AS DOUBLE
 REDIM Definitions(0 to Max.Functions) AS STRING
 REDIM Strngs(0 TO 26) AS STRING
 REDIM Variables(0 TO 26) AS DOUBLE

 ' file areas
 REDIM Field.Array(1 TO 255) AS STRING
 REDIM File.Fields(1 TO 255) AS STRING

 ' increase stack for recursion
 STACK STACK

 ' initialize some variables
 Max.Gosubs = 10
 PageLength = 23
 Program.Name = "<none>"
 SaveOnExit = True
 StdinInput = False
 StdinPrompt = False
 Token.List = " -+*/\^()[]{}<>=|&!%~?:#@`;,'" + CHR$(34)
 White.Space = CHR$(32) + CHR$(9) ' can be modified

 ' reseed randomizer
 RANDOMIZE TIMER

 ' get environment variables
 Var$ = ENVIRON$("SICPAGELENGTH")
 IF LEN(Var$) THEN
    Temp# = INT(VAL(Var$))
    IF Temp# > 0# AND Temp# <= 32767# THEN
       PageLength = CINT(Temp#)
    END IF
 END IF
 Var$ = ENVIRON$("SICSTDININPUT")
 IF LEN(Var$) THEN
    StdinInput = INT(VAL(Var$))
 END IF
 Var$ = ENVIRON$("SICSTDINPROMPT")
 IF LEN(Var$) THEN
    StdinPrompt = True
 END IF
 Var$ = ENVIRON$("SICSAVEONEXIT")
 IF LEN(Var$) THEN
    SaveOnExit = False
 END IF

 ' read in statements
 RESTORE Program.Data
 FOR Temp = 1 TO MaxStatements + 3
    READ Statements(Temp)
 NEXT

 ' read in commands
 RESTORE Command.Data
 FOR Temp = 1 TO MaxCommands
    READ Commands(Temp)
 NEXT

 ' store basic dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 BASIC.DTA.SEG = OutregsX.ES
 BASIC.DTA.OFF = OutregsX.BX

 REM Increase maximum file handles to 80.
 Filename = COMMAND$ ' store command line first
 InregsX.AX = &H6200 ' get psp segment
 CALL InterruptX(&H21, InregsX, OutregsX)
 PSP.Segment = OutregsX.BX
 DEF SEG = PSP.Segment ' point to psp segment
 ' offset to the command line
 Command.Line = &H80
 ' start of command line to store file handles
 Command.Tail = Command.Line + 40
 ' reset maximum file handles plus 5 for dos to closed handles
 FOR Var = 1 TO 85
    POKE Command.Tail + Var - 1, &HFF
 NEXT
 ' copy first 6 file handles to our offset
 FOR Var = 1 TO 6
    File.Handle = PEEK(&H18 + Var - 1)
    POKE Command.Tail + Var - 1, File.Handle
 NEXT
 POKE &H32, 85 ' store maximum file handles
 POKE &H34, Command.Tail ' store offset to new file handles
 DEF SEG

 ' check windows dos
 InregsX.AX = &H160A
 CALL InterruptX(&H2F, InregsX, OutregsX)
 IF OutregsX.AX = False THEN
    Temp = (OutregsX.BX And &HFF00) / 256
    IF Temp >= 4 THEN
       Windows.Detected = True
    END IF
 END IF

 ' run program from command line
 IF LEN(Filename) THEN
    Program.Resume = True
    IF DIR$(Filename) <> Nul THEN
       CALL New.Program
       CALL Read.Program
       CALL Run.Program(False)
    ELSE
       COLOR White, Black
       PRINT "SIC v" + Version + " r" + Release + "; Usage:"
       COLOR Yellow, Black
       PRINT "SIC <program name>"
       PRINT "   Starts SIC and runs program."
       PRINT "TYPE <program name> | SIC"
       PRINT "   Redirects and starts program name."
       PRINT "SIC w/o command line starts interpreter."
       COLOR Plain, Black
    END IF
    CALL Decrease.PSP
    END
 END IF

 ' run program from stdin
 CALL Read.Stdin

 ' terminates program if NUL program input
 X$ = Inkey$

 ' enter the Sic engine
 COLOR White, Black ' display logon banner
 PRINT "SIC v" + Version + " r" + Release + ": ";
 PRINT "The Symbolic Instruction Code interpreter."
 COLOR Yellow, Black
 PRINT "Enter 'quit' to return to system."

Error.Resume:
 ' check which function started Sic
 IF Program.Resume THEN
    CALL End.Program
    CALL Decrease.PSP
    END
 END IF

 ' enter the Sic programming interface
 ON ERROR GOTO Error.Routine

Start.Loop:
 ' get input
 COLOR Yellow, Black
 LINE INPUT ">", Out2
 IF Out2 = Nul THEN GOTO Start.Loop

 ' check entering preceded line number
 CALL Enter.Program.Line
 IF Assign THEN GOTO Start.Loop

 ' get sic environment variable
 Param2$ = Nul
 Var$ = ENVIRON$("SICCMDLINE")
 IF LEN(Var$) THEN
    Param2$ = Var$
 END IF

 ' store parameter
 Param$ = Nul
 Out3 = Out2
 Out2 = UCASE$(Out2)
 Parameter = INSTR(Out2, " ")
 IF Parameter THEN
    Param$ = MID$(Out2, Parameter + 1)
    Param2$ = MID$(Out3, Parameter + 1)
    Out2 = LEFT$(Out2, Parameter - 1)
 END IF

 ' compare to command list
 FOR Command.Number = 1 TO MaxCommands
    IF Out2 = Commands(Command.Number) THEN

       ' check command uses currently loaded program
       SELECT CASE Command.Number
       CASE 1, 4, 6, 8, 9, 11, 12, 13
          IF Program.Name = "<none>" THEN
             COLOR White, Black
             PRINT "No program loaded."
             GOTO Start.Loop
          END IF
       END SELECT

       ' check command has no parameter to specify
       SELECT CASE Command.Number
       CASE 1, 3, 8, 10
          IF LEN(Param$) THEN
             GOTO End.Loop
          END IF
       END SELECT

       ' process command
       SELECT CASE Command.Number
       CASE 1 ' analyze
          PRINT "Preparing program.."
          CALL Prepare.Program
          CALL Analyze.Program
          CALL New.Program
          Filename = Prepare.Filename
          CALL Read.Program
          KILL Prepare.Filename
       CASE 2 ' files
          CALL List.Files(Param$)
       CASE 3 ' help
          CALL List.Help
       CASE 4 ' indent
          CALL Indent.Program(INT(VAL(Param$)))
       CASE 5 ' kill
          CALL Kill.Program(Param$)
       CASE 6 ' list
          Start.Line = 1
          CALL Count.Lines(Last.Line)
          Stop.Line = Last.Line
          IF LEN(Param$) THEN
             Comma = INSTR(Param$, ",")
             IF Comma THEN
                Start.Line = INT(VAL(LEFT$(Param$, Comma - 1)))
                Stop.Line = INT(VAL(MID$(Param$, Comma + 1)))
             ELSE
                Start.Line = INT(VAL(Param$))
                Stop.Line = Last.Line
             END IF
          END IF
          CALL List.Program(Start.Line, Stop.Line, False)
       CASE 7 ' load
          CALL Load.Program(Param$)
       CASE 8 ' new
          IF SaveOnExit THEN
             CALL Save.Current
          END IF
          CALL New.Program
          Program.Name = "<none>"
          COLOR White, Black
          PRINT "Program cleared."
       CASE 9 ' print
          Start.Line = 1
          CALL Count.Lines(Last.Line)
          Stop.Line = Last.Line
          IF LEN(Param$) THEN
             Comma = INSTR(Param$, ",")
             IF Comma THEN
                Start.Line = INT(VAL(LEFT$(Param$, Comma - 1)))
                Stop.Line = INT(VAL(MID$(Param$, Comma + 1)))
             ELSE
                Start.Line = INT(VAL(Param$))
                Stop.Line = Last.Line
             END IF
          END IF
          CALL List.Program(Start.Line, Stop.Line, True)
       CASE 10 ' quit
          CALL Quit.Program
          END
       CASE 11 ' renumber
          Start.Line = False
          Increment.Value = False
          IF LEN(Param$) THEN
             Comma = INSTR(Param$, ",")
             IF Comma THEN
                Start.Line = INT(VAL(LEFT$(Param$, Comma - 1)))
                Increment.Value = INT(VAL(MID$(Param$, Comma + 1)))
             END IF
          END IF
          CALL Renumber.Program(Start.Line, Increment.Value)
       CASE 12 ' run
          CommandLine = Param2$
          IF LEFT$(UCASE$(Param2$), 5) = "LINE=" THEN
             Start.Number = INT(VAL(MID$(Param2$, 6)))
          ELSE
             Start.Number = False
          END IF
          COLOR White, Black
          PRINT "Starting program: " + Program.Name
          PRINT "Preparing program.."
          CALL Run.Program(Start.Number)
          COLOR White, Black
          PRINT "Program run ended."
       CASE 13 ' save
          CALL Save.Program(Param$)
       CASE 14 ' whatis
          CALL Whatis.Command(Param$)
       END SELECT
       GOTO Start.Loop
    END IF
 NEXT

 ' anything goes here is not a command
End.Loop:
 COLOR White, Black
 PRINT "Type 'Help' for information."
 GOTO Start.Loop
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 PrinterLF = False
 Printing = False
 ErrorLine = Program.Line
 ErrorValue = ERR
 IF POS(0) > 1 THEN
    PRINT
 END IF
 CALL Display.Error
 IF Program.Resume <= False THEN
    CALL Key.Prompt
 END IF
 RESUME Error.Resume

' declares all Sic commands
Command.Data:
 DATA "ANALYZE","FILES","HELP","INDENT","KILL","LIST","LOAD"
 DATA "NEW","PRINT","QUIT","RENUMBER","RUN","SAVE","WHATIS"

' declares indent structure types
Indent.Data:
 ' 1=indent right
 DATA "SELECTIF CASE", 1
 DATA "DO WHILE", 1
 DATA "DO", 1
 DATA "IF", 1
 DATA "SELECT CASE", 1
 DATA "DO UNTIL", 1
 DATA "FORIF", 1
 DATA "FOR", 1
 DATA "WHILE", 1
 DATA "LOOPIF", 1
 ' -1=indent left
 DATA "ENDIF", -1
 DATA "END IF", -1
 DATA "NEXTIF", -1
 DATA "NEXT", -1
 DATA "LOOP UNTIL", -1
 DATA "LOOP WHILE", -1
 DATA "END SELECT", -1
 DATA "WEND", -1
 DATA "END LOOPIF", -1
 DATA "LOOP", -1
 DATA "END SELECTIF", -1
 ' -2=indent left, then right
 DATA "ELSE", -2
 DATA "CASE", -2
 DATA "EOF", 0

' all remaining data statements declare
' analyze functions types and pairs
Analyze.Data1:
 DATA "IF", "ENDIF"
 DATA "DO", "LOOP"
 DATA "FOR", "NEXT"
 DATA "WHILE", "WEND"
 DATA "FORIF", "NEXTIF"
 DATA "LOOPIF", "END LOOPIF"
 DATA "SELECT CASE", "END SELECT"
 DATA "SELECTIF CASE", "END SELECTIF"

Analyze.Data2:
 DATA "IF", "ENDIF", "ELSE", "ELSEIF"
 DATA "SELECT CASE", "END SELECT", "CASE ELSE", "CASE"
 DATA "SELECTIF CASE", "END SELECTIF", "CASEIF ELSE", "CASEIF"

Analyze.Data3:
 DATA "DO", "LOOP", "EXIT DO", "CONTINUE DO"
 DATA "FOR", "NEXT", "EXIT FOR", "CONTINUE FOR"
 DATA "WHILE", "WEND", "EXIT WHILE", "CONTINUE WHILE"
 DATA "FORIF","NEXTIF", "EXIT FORIF", "CONTINUE FORIF"
 DATA "LOOPIF", "END LOOPIF", "EXIT LOOPIF", "CONTINUE LOOPIF"

' check validity of program
SUB Analyze.Program
 COLOR White, Black
 CALL Count.Lines(Last.Line)
 PRINT "Pass 1: counting matching structures."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
	  END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
          END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) <> "LOOPIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) <> "NEXTIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "END SELECT" THEN
             IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                Temp1$ = LEFT$(Temp1$, 10)
             END IF
          END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 2: counting matching imbedded structures."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	     Nested.Count = Nested.Count + 1
	  ELSE
             Temp2$ = Temp1$
             IF Imbedded2$ <> "ELSEIF" THEN
                IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
                   Imbedded3 = INSTR(Temp1$, " ")
                   IF Imbedded3 = False THEN
                      PRINT "Analyze error, pass 2: Bad ";Imbedded2$; ": Line:";Program.Line
                      EXIT SUB
                   END IF
                   Temp2$ = LEFT$(Temp1$, Imbedded3 - 1)
                END IF
             END IF
             IF Temp2$ = Imbedded2$ THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
		Nested.Count = Nested.Count + 1
	     END IF
	  END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 3: multipass structure match."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
             Nested.Count = 1
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
                   Count.Data2 = False
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
                      Count.Data2 = True
                   END IF
                   IF Start.Structure$ = "FOR" THEN
                      IF LEFT$(Temp2$, 5) = "FORIF" THEN
                         Count.Data2 = False
                      END IF
                   END IF
                   IF Count.Data2 THEN
		      Nested.Count = Nested.Count + 1
		   END IF
                   IF Stop.Structure$ = "LOOP" THEN
                      IF LEFT$(Temp2$, 6) <> "LOOPIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "NEXT" THEN
                      IF LEFT$(Temp2$, 6) <> "NEXTIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "END SELECT" THEN
                      IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                         Temp1$ = LEFT$(Temp1$, 10)
                      END IF
                   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Nested.Count = Nested.Count - 1
                      IF Nested.Count = False THEN
                         EXIT FOR
                      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count = Nested.Count - 1
                         IF Nested.Count = False THEN
                            EXIT FOR
                         END IF
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Nested.Count <> False THEN
		PRINT "Analyze error, pass 3: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 4: multipass imbedded struture match."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Total.Nested1 = 1
	     Total.Nested2 = 0
	     Nested.Count1 = 1
	     Nested.Count2 = 0
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
		      Total.Nested1 = Total.Nested1 + 1
		      Nested.Count1 = Nested.Count1 + 1
		   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Total.Nested2 = Total.Nested2 - 1
		      Nested.Count1 = Nested.Count1 - 1
                      IF Nested.Count1 = False THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count1 = Nested.Count1 - 1
                         IF Nested.Count1 = False THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		   IF LEFT$(Temp2$, LEN(Imbedded1$)) = Imbedded1$ THEN
		      Nested.Count2 = Nested.Count2 + 1
		      IF Nested.Count2 > Nested.Count1 THEN
			 PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
			 EXIT SUB
		      END IF
		      Nested.Count2 = Nested.Count2 - 1
		   ELSE
                      Temp3$ = Temp2$
                      IF Imbedded2$ <> "ELSEIF" THEN
                         IF LEFT$(Temp2$, LEN(Imbedded2$)) = Imbedded2$ THEN
                            Imbedded3 = INSTR(Temp2$, " ")
                            IF Imbedded3 = False THEN
                               PRINT "Analyze error, pass 4: Bad ";Imbedded2$; ": Line:";Program.Line
                               EXIT SUB
                            END IF
                            Temp3$ = LEFT$(Temp2$, Imbedded3 - 1)
                         END IF
                      END IF
                      IF Temp3$ = Imbedded2$ THEN
			 Nested.Count2 = Nested.Count2 + 1
			 IF Nested.Count2 > Nested.Count1 THEN
			    PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
			    EXIT SUB
			 END IF
			 Nested.Count2 = Nested.Count2 - 1
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Total.Nested2 > Total.Nested1 THEN
		PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 5: single pass imbedded control structure match."
 RESTORE Analyze.Data3
 FOR Data.Count = 1 TO 5
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
	  END IF
          Count.Data2 = False
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
             Count.Data2 = True
          END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) = "LOOPIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) = "NEXTIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Count.Data2 THEN
             Nested.Count = Nested.Count - 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Analysis completed. Program syntax correct."
END SUB

' gets last line in program
SUB Count.Lines (Temp1%)
 Temp1% = False
 FOR Temp2% = Max.Lines TO 1 STEP -1
    Temp1$ = Program(Temp2%)
    Temp1$ = STRIM$(Temp1$)
    IF LEN(Temp1$) THEN
       EXIT FOR
    END IF
 NEXT
 Temp1% = Temp2%
END SUB

' reset file handles
SUB Decrease.PSP
 CLOSE
 InregsX.AX = &H6200
 CALL InterruptX(&H21, InregsX, OutregsX)
 PSP.Segment = OutregsX.BX
 DEF SEG = PSP.Segment
 POKE &H32, 20
 POKE &H34, &H18
 DEF SEG
 ' remove dimensioned arrays from memory
 ERASE Arrays, Strngs, Variables, GosubReturn, Definitions
 ERASE Program, Field.Array, File.Fields
END SUB

' displays error message
SUB Display.Error
 SELECT CASE ErrorValue
 CASE 1
    Error.List$ = "Internal error #001: Next without For."
 CASE 2
    Error.List$ = "Error #002: Line" + STR$(ErrorLine) + ": Syntax error."
 CASE 3
    Error.List$ = "Internal error #003: Return without Gosub."
 CASE 4
    Error.List$ = "Internal error #004: Out of Data."
 CASE 5
    Error.List$ = "Error #005: Line" + STR$(ErrorLine) + ": Illegal function call."
 CASE 6
    Error.List$ = "Error #006: Line" + STR$(ErrorLine) + ": Overflow."
 CASE 7
    Error.List$ = "Error #007: Line" + STR$(ErrorLine) + ": Out of memory."
 CASE 8
    Error.List$ = "Internal error #008: Label not defined."
 CASE 9
    Error.List$ = "Error #009: Line" + STR$(ErrorLine) + ": Subscript out of range."
 CASE 10
    Error.List$ = "Internal error #010: Duplicate definition."
 CASE 11
    Error.List$ = "Error #011: Line" + STR$(ErrorLine) + ": Division by zero."
 CASE 12
    Error.List$ = "Internal error #012: Illegal in direct mode."
 CASE 13
    Error.List$ = "Internal error #013: Type mismatch."
 CASE 14
    Error.List$ = "Error #014: Line" + STR$(ErrorLine) + ": Out of string space."
 CASE 15
    Error.List$ = "Error #015: Line" + STR$(ErrorLine) + ": Invalid Pset statement."
 CASE 16
    Error.List$ = "Error #016: Line" + STR$(ErrorLine) + ": String formula too complex."
 CASE 17
    Error.List$ = "Reserved error #017: Cannot continue."
 CASE 18
    Error.List$ = "Internal error #018: Function not defined."
 CASE 19
    Error.List$ = "Error #019: Line" + STR$(ErrorLine) + ": No Resume."
 CASE 20
    Error.List$ = "Error #020: Line" + STR$(ErrorLine) + ": Resume without error."
 CASE 21
    Error.List$ = "Error #021: Line" + STR$(ErrorLine) + ": Syntax error specifying filename to open."
 CASE 22
    Error.List$ = "Error #022: Line" + STR$(ErrorLine) + ": Syntax error specifying filename to close."
 CASE 23
    Error.List$ = "Error #023: Line" + STR$(ErrorLine) + ": Syntax error specifying filename field."
 CASE 24
    Error.List$ = "Error #024: Line" + STR$(ErrorLine) + ": Device timeout."
 CASE 25
    Error.List$ = "Error #025: Line" + STR$(ErrorLine) + ": Device fault."
 CASE 26
    Error.List$ = "Internal error #026: For without Next."
 CASE 27
    Error.List$ = "Error #027: Line" + STR$(ErrorLine) + ": Out of paper."
 CASE 28
    Error.List$ = "Error #028: Line" + STR$(ErrorLine) + ": Invalid Line statement."
 CASE 29
    Error.List$ = "Internal error #029: While without Wend."
 CASE 30
    Error.List$ = "Internal error #030: Wend without While."
 CASE 31
    Error.List$ = "Error #031: Line" + STR$(ErrorLine) + ": Syntax error writing to file."
 CASE 32
    Error.List$ = "Error #032: Line" + STR$(ErrorLine) + ": Syntax error printing to file."
 CASE 33
    Error.List$ = "Internal error #033: Duplicate label."
 CASE 34
    Error.List$ = "Error #034: Line" + STR$(ErrorLine) + ": Syntax error inputing from file."
 CASE 35
    Error.List$ = "Internal error #035: Subprogram not defined."
 CASE 36
    Error.List$ = "Error #034: Line" + STR$(ErrorLine) + ": Syntax error line inputing from file."
 CASE 37
    Error.List$ = "Internal error #036: Argument-count mismatch."
 CASE 38
    Error.List$ = "Error #038: Line" + STR$(ErrorLine) + ": Array not defined."
 CASE 39
    Error.List$ = "Error #039: Line" + STR$(ErrorLine) + ": Invalid Circle statement."
 CASE 40
    Error.List$ = "Error #040: Line" + STR$(ErrorLine) + ": Variable required."
 CASE 41
    Error.List$ = "Error #041: Line" + STR$(ErrorLine) + ": Invalid Lset statement."
 CASE 42
    Error.List$ = "Error #042: Line" + STR$(ErrorLine) + ": Invalid Rset statement."
 CASE 43
    Error.List$ = "Error #043: Line" + STR$(ErrorLine) + ": Invalid Put statement."
 CASE 44
    Error.List$ = "Error #044: Line" + STR$(ErrorLine) + ": Invalid Get statement."
 CASE 45
    Error.List$ = "Error #045: Line" + STR$(ErrorLine) + ": Invalid Read statement."
 CASE 46
    Error.List$ = "Error #046: Line" + STR$(ErrorLine) + ": Invalid Draw statement."
 CASE 47
    Error.List$ = "Error #047: Line" + STR$(ErrorLine) + ": Invalid Play statement."
 CASE 48
    Error.List$ = "Error #048: Line" + STR$(ErrorLine) + ": Invalid Paint statement."
 CASE 49
    Error.List$ = "Error #049: Line" + STR$(ErrorLine) + ": Invalid Get/Put statement."
 CASE 50
    Error.List$ = "Error #050: Line" + STR$(ErrorLine) + ": Field overflow."
 CASE 51
    Error.List$ = "Internal compiler error #051."
 CASE 52
    Error.List$ = "Error #052: Line" + STR$(ErrorLine) + ": Bad file name or number."
 CASE 53
    Error.List$ = "Error #053: Line" + STR$(ErrorLine) + ": File not found."
 CASE 54
    Error.List$ = "Error #054: Line" + STR$(ErrorLine) + ": Bad file mode."
 CASE 55
    Error.List$ = "Error #055: Line" + STR$(ErrorLine) + ": File already open."
 CASE 56
    Error.List$ = "Error #056: Line" + STR$(ErrorLine) + ": Field statement active."
 CASE 57
    Error.List$ = "Error #057: Line" + STR$(ErrorLine) + ": Device I/O error."
 CASE 58
    Error.List$ = "Error #058: Line" + STR$(ErrorLine) + ": File already exists."
 CASE 59
    Error.List$ = "Error #059: Line" + STR$(ErrorLine) + ": Bad record length."
 CASE 60
    Error.List$ = "Error #060: Line" + STR$(ErrorLine) + ": Invalid Bsave/Bload statement. Filename: " + Filename$
 CASE 61
    Error.List$ = "Error #061: Line" + STR$(ErrorLine) + ": Disk full."
 CASE 62
    Error.List$ = "Error #062: Line" + STR$(ErrorLine) + ": Input past end of file."
 CASE 63
    Error.List$ = "Error #063: Line" + STR$(ErrorLine) + ": Bad record number."
 CASE 64
    Error.List$ = "Error #064: Line" + STR$(ErrorLine) + ": Bad file name: " + LCASE$(Filename) + "."
 CASE 65
    Error.List$ = "Error #065: Line" + STR$(ErrorLine) + ": Invalid Data statement."
 CASE 66
    Error.List$ = "Error #066: Line" + STR$(ErrorLine) + ": Out of data."
 CASE 67
    Error.List$ = "Error #067: Line" + STR$(ErrorLine) + ": Too many files."
 CASE 68
    Error.List$ = "Error #068: Line" + STR$(ErrorLine) + ": Device unavailable."
 CASE 69
    Error.List$ = "Error #069: Line" + STR$(ErrorLine) + ": Communication buffer overflow."
 CASE 70
    Error.List$ = "Error #070: Line" + STR$(ErrorLine) + ": File permission denied."
 CASE 71
    Error.List$ = "Error #071: Line" + STR$(ErrorLine) + ": Disk not ready."
 CASE 72
    Error.List$ = "Error #072: Line" + STR$(ErrorLine) + ": Disk-media error."
 CASE 73
    Error.List$ = "Internal error #073: Feature unavailable."
 CASE 74
    Error.List$ = "Error #074: Line" + STR$(ErrorLine) + ": Rename across disks."
 CASE 75
    Error.List$ = "Error #075: Line" + STR$(ErrorLine) + ": Path/File access error."
 CASE 76
    Error.List$ = "Error #076: Line" + STR$(ErrorLine) + ": Path not found."
 CASE 77
    Error.List$ = "Error #077: Line" + STR$(ErrorLine) + ": Invalid View statement."
 CASE 78
    Error.List$ = "Error #078: Line" + STR$(ErrorLine) + ": Invalid Window statement."
 CASE 79
    Error.List$ = "User defined error #079: Line" + STR$(ErrorLine) + "."
 CASE 80
    Error.List$ = "Internal error #080: Feature removed."
 CASE 81
    Error.List$ = "Error #081: Line" + STR$(ErrorLine) + ": Invalid name."
 CASE 82
    Error.List$ = "Reserved error #082: Table not found." ' isam
 CASE 83
    Error.List$ = "Reserved error #083: Index not found." ' isam
 CASE 84
    Error.List$ = "Reserved error #084: Invalid column." ' isam
 CASE 85
    Error.List$ = "Reserved error #085: No current record." ' isam
 CASE 86
    Error.List$ = "Reserved error #086: Duplicate value for unique index." ' isam
 CASE 87
    Error.List$ = "Reserved error #087: Invalid operation on null index." ' isam
 CASE 88
    Error.List$ = "Reserved error #088: Database needs repair." ' isam
 CASE 89
    Error.List$ = "Reserved error #089: Insufficient ISAM buffers." ' isam
 CASE 90
    Error.List$ = "User defined error #090: Line" + STR$(ErrorLine) + "."
 CASE 91
    Error.List$ = "Error #091: Line" + STR$(ErrorLine) + ": Unknown statement."
 CASE 92
    Error.List$ = "Error #092: Line" + STR$(ErrorLine) + ": Whatis: " + Strng + "."
 CASE 93
    Error.List$ = "User defined error #093: Line" + STR$(ErrorLine) + "."
 CASE 94
    Error.List$ = "User defined error #094: Line" + STR$(ErrorLine) + "."
 CASE 95
    Error.List$ = "User defined error #095: Line" + STR$(ErrorLine) + "."
 CASE 96
    Error.List$ = "User defined error #096: Line" + STR$(ErrorLine) + "."
 CASE 97
    Error.List$ = "Error #097: Line" + STR$(ErrorLine) + ": Mismatched for/next."
 CASE 98
    Error.List$ = "Error #098: Line" + STR$(ErrorLine) + ": Mismatched do/loop."
 CASE 99
    Error.List$ = "Error #099: Line" + STR$(ErrorLine) + ": Missing line number."
 CASE 100
    Error.List$ = "Error #100: Line" + STR$(ErrorLine) + ": Unmatched gosub."
 CASE 101
    Error.List$ = "Error #101: Error accessing file " + LCASE$(Filename) + "."
 CASE 102
    Error.List$ = "Error #102: Line" + STR$(ErrorLine) + ": Mismatched select/end select."
 CASE 103
    Error.List$ = "Error #103: Line" + STR$(ErrorLine) + ": Mismatched forif/nextif."
 CASE 104
    Error.List$ = "Error #104: Line" + STR$(ErrorLine) + ": Mismatched loopif/endloopif."
 CASE 105
    Error.List$ = "Error #105: Line" + STR$(ErrorLine) + ": Mismatched selectif/end selectif."
 CASE 106
    Error.List$ = "User defined error #106: Line" + STR$(ErrorLine) + "."
 CASE 107
    Error.List$ = "User defined error #107: Line" + STR$(ErrorLine) + "."
 CASE 108
    Error.List$ = "User defined error #108: Line" + STR$(ErrorLine) + "."
 CASE 109
    Error.List$ = "User defined error #109: Line" + STR$(ErrorLine) + "."
 CASE 110
    Error.List$ = "Error #110: Line" + STR$(ErrorLine) + ": Unknown swap statement."
 CASE 111
    Error.List$ = "Error #111: Line" + STR$(ErrorLine) + ": Record size overflow."
 CASE 112
    Error.List$ = "Error #112: Line" + STR$(ErrorLine) + ": Error chaining to program."
 CASE 113
    Error.List$ = "Error #113: Line" + STR$(ErrorLine) + ": Error naming file."
 CASE 114
    Error.List$ = "Error #114: Line" + STR$(ErrorLine) + ": Error killing file."
 CASE 115
    Error.List$ = "Error #115: Line" + STR$(ErrorLine) + ": Error changing directory."
 CASE 116
    Error.List$ = "Error #116: Line" + STR$(ErrorLine) + ": Error making directory."
 CASE 117
    Error.List$ = "Error #117: Line" + STR$(ErrorLine) + ": Error removing directory."
 CASE 118
    Error.List$ = "Error #118: Line" + STR$(ErrorLine) + ": Error setting date."
 CASE 119
    Error.List$ = "Error #119: Line" + STR$(ErrorLine) + ": Error setting time."
 CASE 120
    Error.List$ = "Error #120: Line" + STR$(ErrorLine) + ": Error changing drive."
 CASE 121
    Error.List$ = "Error #121: Line" + STR$(ErrorLine) + ": Error using OUT statement."
 CASE 122
    Error.List$ = "Error #122: Line" + STR$(ErrorLine) + ": Error using WAIT statement."
 CASE 123
    Error.List$ = "Error #123: Line" + STR$(ErrorLine) + ": Error using ABSOLUTE statement."
 CASE 124
    Error.List$ = "Error #124: Line" + STR$(ErrorLine) + ": Error using POKE statement."
 CASE 125
    Error.List$ = "Error #125: Line" + STR$(ErrorLine) + ": Error using DEFSEG statement."
 CASE 126
    Error.List$ = "Error #126: Line" + STR$(ErrorLine) + ": Error specifying file handle number."
 CASE 127
    Error.List$ = "Error #127: Line" + STR$(ErrorLine) + ": Error specifying hexidecimal number."
 CASE 128
    Error.List$ = "Error #128: Line" + STR$(ErrorLine) + ": Error specifying octal number."
 CASE 129
    Error.List$ = "Error #129: Line" + STR$(ErrorLine) + ": Error specifying binary number."
 CASE 130
    Error.List$ = "Error #130: Line" + STR$(ErrorLine) + ": Error specifying decimal value."
 CASE 131
    Error.List$ = "Error #131: Line" + STR$(ErrorLine) + ": Error specifying numeric value."
 CASE 132
    Error.List$ = "Error #132: Line" + STR$(ErrorLine) + ": Error specifying factorial value."
 CASE 133
    Error.List$ = "Error #133: Line" + STR$(ErrorLine) + ": Error specifying quoted value."
 CASE 134
    Error.List$ = "Error #134: Line" + STR$(ErrorLine) + ": Bad input variable."
 CASE 135
    Error.List$ = "Error #135: Line" + STR$(ErrorLine) + ": Mismatched data."
 CASE 136
    Error.List$ = "Error #136: Line" + STR$(ErrorLine) + ": Too few input variables."
 CASE 137
    Error.List$ = "Error #137: Line" + STR$(ErrorLine) + ": Too many input variables."
 CASE 138
    Error.List$ = "Error #138: Line" + STR$(ErrorLine) + ": Missing left parenthesis."
 CASE 139
    Error.List$ = "Error #139: Line" + STR$(ErrorLine) + ": Missing right parenthesis."
 CASE 140
    Error.List$ = "Error #140: Line" + STR$(ErrorLine) + ": Specified double exponent."
 CASE 141
    Error.List$ = "Error #141: Line" + STR$(ErrorLine) + ": Missing exponent value."
 CASE 142
    Error.List$ = "Error #142: Line" + STR$(ErrorLine) + ": Bad exponent unary sign."
 CASE 143
    Error.List$ = "Error #143: Line" + STR$(ErrorLine) + ": Bad exponent decimal point."
 CASE 144
    Error.List$ = "Error #144: Line" + STR$(ErrorLine) + ": Bad DEF FN declaration."
 CASE 145
    Error.List$ = "Error #145: Line" + STR$(ErrorLine) + ": Unknown line number."
 CASE ELSE
    Error.List$ = "Error #000: Error" + STR$(ErrorValue) + "."
 END SELECT
 IF Program.Resume <= False THEN
    PRINT Error.List$
 ELSE
    PRINT "Error"; ErrorValue
 END IF
END SUB

' end of program routine
SUB End.Program
 SCREEN 0
 WIDTH 80, 25
 COLOR Plain, Black
 LOCATE , , , 8, 8
 IF LineFeed THEN
    PRINT
 END IF
 IF Program.Resume <= False THEN
    WHILE INKEY$ <> Nul
    WEND
 END IF
END SUB

' parses and stores a program line number
SUB Enter.Program.Line
 Assign = False
 Out2 = STRIM$(Out2)
 FOR Blanks = 1 TO LEN(Out2)
    Imbedded = False
    FOR Parse = 1 TO LEN(White.Space)
       IF MID$(Out2, Blanks, 1) = MID$(White.Space, Parse, 1) THEN
          Imbedded = Blanks
          EXIT FOR
       END IF
    NEXT
    IF Imbedded THEN
       Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
       IF Line.Number >= 1 AND Line.Number <= Max.Lines THEN
          Out3 = MID$(Out2, Imbedded)
          IF STRIM$(Out3) = Nul THEN
             EXIT FOR
          END IF
          Assign = True
          Program(Line.Number) = Out3
	  IF Program.Name = "<none>" THEN
	     Program.Name = "<untitled>"
	  END IF
       ELSE
          Out3 = STRIM$(Out2)
          IF INSTR("0123456789", LEFT$(Out3, 1)) THEN
             Assign = True
             PRINT "Line number out of range."
          END IF
       END IF
       EXIT SUB
    END IF
 NEXT
 Line.Number = INT(VAL(Out2))
 IF Line.Number > False AND Line.Number <= Max.Lines THEN
    Assign = True
    Program(Line.Number) = Nul
    CALL Count.Lines(Last.Line)
    IF Last.Line = False THEN
       Program.Name = "<none>
    ELSE
       IF Program.Name = "<none>" THEN
          Program.Name = "<untitled>"
       END IF
    END IF
 ELSE
    Out3 = STRIM$(Out2)
    IF INSTR("0123456789", LEFT$(Out3, 1)) THEN
       Assign = True
       PRINT "Line number out of range."
    END IF
 END IF
END SUB

' starts a MS-DOS shell
SUB Execute.Command (Shell.Statement$)
 ' store shell dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(ParseDTA)
 InregsX.DX = VARPTR(ParseDTA)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' store current drive/directory
 Current.Directory$ = CURDIR$

 ' start DOS command shell
 IF LEN(Shell.Statement$) THEN
    Shell.Command$ = "COMMAND.COM /E:4096 /C " + Shell.Statement$
    SHELL Shell.Command$
 ELSE
    SHELL
 END IF

 ' restore current drive/directory
 CHDRIVE Current.Directory$
 CHDIR Current.Directory$

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
END SUB

' indents current program
SUB Indent.Program(Number.Spaces)
 COLOR White, Black
 CALL More.Prompt("Indent with tabs or spaces(t/s/q)?", "tsq", Output.Char$)
 SELECT CASE Output.Char$
 CASE "t"
    Tabs = True
 CASE "s"
    Tabs = False
 CASE "q"
    EXIT SUB
 END SELECT
 IF Number.Spaces = False THEN
    COLOR White, Black
    IF Tabs THEN
       PRINT "Enter number of tabs to indent";
    ELSE
       PRINT "Enter number of spaces to indent";
    END IF
    INPUT Increment
 ELSE
    Increment = Number.Spaces
 END IF
 Indent = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    IF Tabs THEN
       Number$ = CHR$(9)
    ELSE
       Number$ = SPACE$(6 - LEN(STR$(Program.Line)))
    END IF
    Out2 = Program(Program.Line)
    Out2 = STRIM$(Out2)
    IF LEN(Out2) THEN
       Temp1$ = STRIM$(Out2)
       Temp1$ = UCASE$(Temp1$)
       Temp1$ = TTRIM$(Temp1$, False)
       Next.Indent = False
       RESTORE Indent.Data
       DO
	  READ Keyword$, KeyIndent
	  IF Keyword$ = "EOF" THEN
	     EXIT DO
	  END IF
	  IF LEFT$(Temp1$, LEN(Keyword$)) = Keyword$ THEN
	     Next.Indent = KeyIndent
	     EXIT DO
	  END IF
       LOOP
       SELECT CASE Next.Indent
       CASE 1
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
	  Indent = Indent + 1
       CASE -1
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
             EXIT SUB
	  END IF
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
       CASE -2
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
             EXIT SUB
	  END IF
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
	  Indent = Indent + 1
       CASE ELSE
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
       END SELECT
       Out2 = Number$ + Out2
       Program(Program.Line) = Out2
    END IF
 NEXT
 IF Indent <> False THEN
    PRINT "Indent error: Line:"; Program.Line
    EXIT SUB
 END IF
 PRINT "Program indented."
END SUB

' prompts for a keystroke
SUB Key.Prompt
 COLOR White, Black
 LOCATE , , 1
 PRINT "Press any key to continue:";
 Input.Char$ = Nul
 DO
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       EXIT DO
    END IF
 LOOP
 PRINT
END SUB

' deletes a .sic file
SUB Kill.Program(Temp.Name$)
 CLOSE
 DO
    IF Temp.Name$ = Nul THEN
       COLOR White, Black
       PRINT "Program name to kill";
       INPUT Program.File$
    ELSE
       Program.File$ = Temp.Name$
    END IF
    IF LEN(Program.File$) = False THEN
       EXIT DO
    END IF
    Program.File$ = STRIM$(Program.File$)
    Program.File$ = LCASE$(Program.File$)
    IF RIGHT$(Program.File$, 4) = ".sic" THEN
       Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
    END IF
    Program.File$ = LEFT$(Program.File$, 8)
    Filename = Program.File$ + ".sic"
    IF DIR$(Filename) = Nul THEN
       PRINT "File "; CHR$(34); Filename; CHR$(34); " does not exist."
       IF LEN(Temp.Name$) THEN
          EXIT DO
       END IF
    ELSE
       IF Temp.Name$ = Nul THEN
          COLOR White, Black
          PRINT "Kill "; CHR$(34); Filename; CHR$(34); ". ";
          CALL More.Prompt("Are you sure(y/n)?", "yn", Output.Char$)
       ELSE
          Output.Char$ = "y"
       END IF
       COLOR White, Black
       IF Output.Char$ = "y" THEN
	  KILL Filename
          PRINT "Program "; CHR$(34); Filename; CHR$(34); " killed."
       ELSE
          PRINT "Program "; CHR$(34); Filename; CHR$(34); " not killed."
       END IF
       EXIT DO
    END IF
 LOOP
END SUB

' lists specified .sic files
SUB List.Files (Var$)
 ' declare file date and time work variables
 DIM File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
 DIM HourTemp AS SINGLE, MinuteTemp AS SINGLE, SecondsTemp AS SINGLE
 DIM DayTemp AS SINGLE, MonthTemp AS SINGLE, YearTemp AS SINGLE
 DIM File.Date AS STRING * 10, File.Time AS STRING * 8

 ' declare file size work variables
 DIM File.Size AS DOUBLE, Total.Bytes AS DOUBLE
 DIM Total.Files AS DOUBLE

 ' reset counters
 Line.Count = False
 Continuous.Display = False

 ' reset some variables
 Total.Files = DFalse
 Total.Bytes = Dfalse

 ' store asciz search filename
 IF Var$ = Nul THEN
    ASCIZ = "*.SIC" + CHR$(0)
 ELSE
    IF RIGHT$(Var$, 4) = ".SIC" THEN
       ASCIZ = Var$ + CHR$(0)
    ELSE
       ASCIZ = Var$ + ".SIC" + CHR$(0)
    END IF
 END IF

 ' restore directory search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(ParseDTA)
 InregsX.DX = VARPTR(ParseDTA)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' find first filename
 InregsX.AX = &H4E00
 InregsX.CX = &H27
 InregsX.DS = VARSEG(ASCIZ)
 InregsX.DX = VARPTR(ASCIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' start file list loop
 DO
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF

    ' check page length
    Line.Count = Line.Count + 1
    IF Continuous.Display = False THEN
       IF Line.Count = 1 THEN
	  GOSUB Title.Header
       END IF
    END IF

    ' store file attribute
    Attribute% = ASC(ParseDTA.FileAttr)
    Attr$ = Nul
    IF (Attribute% AND &H1) = &H1 THEN
       Attr$ = Attr$ + "R"
    END IF
    IF (Attribute% AND &H2) = &H2 THEN
       Attr$ = Attr$ + "H"
    END IF
    IF (Attribute% AND &H4) = &H4 THEN
       Attr$ = Attr$ + "S"
    END IF

    ' store filename
    Filename = ParseDTA.ASCIZfilename
    Filename = LEFT$(Filename, INSTR(Filename, CHR$(0)) - 1)
    Filename = LEFT$(Filename, INSTR(Filename, ".") - 1)

    ' count files
    Total.Files = Total.Files + 1#

    ' store file size
    File.Size = Dfalse
    File.Size = File.Size + ASC(MID$(ParseDTA.FileSize, 4, 1))
    File.Size = File.Size * &H100 + ASC(MID$(ParseDTA.FileSize, 3, 1))
    File.Size = File.Size * &H100 + ASC(MID$(ParseDTA.FileSize, 2, 1))
    File.Size = File.Size * &H100 + ASC(MID$(ParseDTA.FileSize, 1, 1))

    ' count bytes
    Total.Bytes = Total.Bytes + File.Size

    ' construct file date and time for display
    File.Work.Time = ASC(MID$(ParseDTA.FileTime, 2, 1))
    File.Work.Time = File.Work.Time * &H100 + ASC(MID$(ParseDTA.FileTime, 1, 1))
    File.Work.Date = ASC(MID$(ParseDTA.FileDate, 2, 1))
    File.Work.Date = File.Work.Date * &H100 + ASC(MID$(ParseDTA.FileDate, 1, 1))
    HourTemp = INT(File.Work.Time / 2048)
    MinuteTemp = INT((File.Work.Time AND &H7E0) / 32)
    SecondsTemp = INT((File.Work.Time AND &H1F) / 2)
    YearTemp = INT(File.Work.Date / 512)
    MonthTemp = INT((File.Work.Date AND &H1E0) / 32)
    DayTemp = INT(File.Work.Date AND &H1F)
    YearTemp = YearTemp + 1980
    File.Date = RIGHT$(STR$(MonthTemp + 100), 2) + "-" + RIGHT$(STR$(DayTemp + 100), 2) + "-" + MID$(STR$(YearTemp), 2)
    File.Time = RIGHT$(STR$(HourTemp + 100), 2) + ":" + RIGHT$(STR$(MinuteTemp + 100), 2) + ":" + RIGHT$(STR$(SecondsTemp + 100), 2)

    ' make filename
    Filename = LCASE$(Filename)
    MID$(Filename, 1, 1) = UCASE$(MID$(Filename, 1, 1))
    Display.Line$ = Filename + SPACE$(8 - LEN(Filename))
    Display.Line$ = Display.Line$ + " " + File.Date + " " + File.Time
    FileSize$ = FORMAT$(File.Size, "#,##0")
    Display.Line$ = Display.Line$ + " " + RTRIM$(FileSize$)

    ' display filename
    COLOR Yellow, Black
    PRINT Display.Line$;

    ' check attribute
    IF LEN(Attr$) THEN
       COLOR Red, Black
       PRINT " "; Attr$;
    END IF
    PRINT

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       Line.Count = False
       IF Continuous.Display = False THEN
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous.Display = True
	  END SELECT
       END IF
    END IF

    ' find next filename
    InregsX.AX = &H4F00
    CALL InterruptX(&H21, InregsX, OutregsX)
 LOOP

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check page length
 IF Line.Count >= PageLength - 3 THEN
    IF Continuous.Display = False THEN
       CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
    END IF
 END IF

 ' print totals
 COLOR White, Black
 PRINT "--------                     ----"
 Total.Line$ = FORMAT$(Total.Files, "#,##0") + " Files"
 Total.Line$ = Total.Line$ + SPACE$(29 - LEN(Total.Line$))
 Temp# = Total.Bytes
 TempA = False
 DO
    IF Temp# >= 1024 THEN
       Temp# = Temp# / 1024
       TempA = TempA + 1
       IF TempA = 4 THEN
	  EXIT DO
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP
 Temp$ = FORMAT$(Temp#, "#,##0.0;;")
 SELECT CASE TempA
 CASE 0
    Strng = Temp$ + " B"
 CASE 1
    Strng = Temp$ + " KB"
 CASE 2
    Strng = Temp$ + " MB"
 CASE 3
    Strng = Temp$ + " GB"
 CASE 4
    Strng = Temp$ + " TB"
 CASE ELSE
    Strng = Temp$
 END SELECT
 Total.Line$ = Total.Line$ + Strng
 PRINT Total.Line$
 EXIT SUB

Title.Header:
 COLOR White, Black
 PRINT "Filename Date       Time     Size"
 PRINT "-------- ---------- -------- ----"
 RETURN
END SUB

' display help menu
SUB List.Help
 DO
    COLOR White, Black
    PRINT "Help utility SIC v" + Version + " r" + Release + " list:"
    COLOR Yellow, Black
    PRINT "[1]command list"
    PRINT "[2]input prompt editing keys"
    PRINT "[3]general documentation"
    PRINT "[4]formatting information"
    PRINT "[5]screen mode tables"
    PRINT "[6]error code values"
    PRINT "[7]syntax documentation"
    PRINT "[8]boolean syntax/charts"
    PRINT "[9]disclaimer notice"
    CALL More.Prompt("Enter(1-9, Q to quit)?", "123456789q", Output.Char$)
    SELECT CASE Output.Char$
    CASE "1"
       COLOR White, Black
       PRINT "SIC created: " + PublishDate
       COLOR Yellow, Black
       PRINT "ANALYZE  --  checks program structure."
       PRINT "FILES    --  display programs."
       PRINT "INDENT   --  formats current program."
       PRINT "KILL     --  delete program."
       PRINT "LIST     --  display current program."
       PRINT "LOAD     --  read program from disk."
       PRINT "NEW      --  erase current program."
       PRINT "PRINT    --  print current program."
       PRINT "QUIT     --  exit SIC interpreter."
       PRINT "RENUMBER --  renumber program."
       PRINT "RUN      --  start current program."
       PRINT "SAVE     --  store current program."
       PRINT "WHATIS   --  enter immediate mode."
       CALL Key.Prompt
    CASE "2"
       Filename = "sickeys.doc"
       CALL List.Help.File
    CASE "3"
       Filename = "sic.doc"
       CALL List.Help.File
    CASE "4"
       Filename = "sicform.doc"
       CALL List.Help.File
    CASE "5"
       Filename = "sicscrn.doc"
       CALL List.Help.File
    CASE "6"
       Filename = "error.doc"
       CALL List.Help.File
    CASE "7"
       Filename = "syntax.doc"
       CALL List.Help.File
    CASE "8"
       Filename = "boolean.doc"
       CALL List.Help.File
    CASE "9"
       Filename = "disclaim.doc"
       CALL List.Help.File
    CASE "q"
       EXIT DO
    END SELECT
 LOOP
END SUB

' displays a help file
SUB List.Help.File
 CLOSE
 IF DIR$(Filename) = Nul THEN
    PRINT "Helpfile "; CHR$(34); Filename; CHR$(34); " not found."
    EXIT SUB
 END IF
 OPEN Filename FOR INPUT AS #1
 Continuous = False
 Line.Count = False
 DO WHILE NOT EOF(1)
    COLOR Yellow, Black
    LINE INPUT #1, Input.Line$
    PRINT Input.Line$
    IF Continuous = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count = PageLength THEN
	  Line.Count = False
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous = True
	  END SELECT
       END IF
    END IF
 LOOP
 CALL Key.Prompt
END SUB

' lists current .sic program
SUB List.Program(Start.Line, Stop.Line, Print.Prog)
 COLOR White, Black
 IF Print.Prog THEN
    CALL More.Prompt("Printer number(1-4,q)?", "1234q", Output.Char$)
    IF Output.Char$ = "q" THEN
       EXIT SUB
    END IF
    Print.Number = INT(VAL(Output.Char$))
    CLOSE
    OPEN "LPT"+MID$(STR$(Print.Number), 2) + ":" FOR OUTPUT AS #1
 END IF
 IF Print.Prog THEN
    PRINT #1, "Program: ";Program.Name
 ELSE
    PRINT "Program: ";Program.Name
 END IF
 Continuous.Display = False
 Line.Count = 1
 FOR Program.Line = Start.Line TO Stop.Line
    Out2 = Program(Program.Line)
    IF LEN(Out2) THEN
       COLOR Yellow, Black
       IF Print.Prog THEN
          IF INSTR(White.Space, LEFT$(Out2, 1)) THEN
             PRINT #1, MID$(STR$(Program.Line), 2) + Out2
          ELSE
             PRINT #1, MID$(STR$(Program.Line), 2) + " " + Out2
          END IF
       ELSE
          IF INSTR(White.Space, LEFT$(Out2, 1)) THEN
             PRINT ">";MID$(STR$(Program.Line), 2) + Out2
          ELSE
             PRINT ">";MID$(STR$(Program.Line), 2) + " " + Out2
          END IF
       END IF
       IF Print.Prog = False THEN
          IF Continuous.Display = False THEN
             Line.Count = Line.Count + 1
             IF Line.Count = PageLength THEN
                Line.Count = False
                CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
                SELECT CASE Output.Char$
                CASE "n"
                   EXIT FOR
                CASE "c"
                   Continuous.Display = True
                END SELECT
             END IF
          END IF
       END IF
    END IF
 NEXT
 COLOR White, Black
 PRINT "Program list ended."
END SUB

' loads a .sic file
SUB Load.Program(Temp.Name$)
 IF SaveOnExit THEN
    CALL Save.Current
 END IF
 IF Temp.Name$ = Nul THEN
    COLOR White, Black
    PRINT "Program name to load";
    INPUT Program.File$
 ELSE
    Program.File$ = Temp.Name$
 END IF
 IF Program.File$ = Nul THEN
    EXIT SUB
 END IF
 Program.File$ = STRIM$(Program.File$)
 Program.File$ = LCASE$(Program.File$)
 IF RIGHT$(Program.File$, 4) = ".sic" THEN
    Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
 END IF
 Program.File$ = LEFT$(Program.File$, 8)
 Filename = Program.File$ + ".sic"
 CALL New.Program
 Program.Name = "<none>"
 CALL Read.Program
 Program.Name = LCASE$(Program.File$)
 COLOR White, Black
 PRINT "Program loaded."
END SUB

' prompts for multiple input characters
SUB More.Prompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$; " ";
 Input.Char$ = Nul
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' remove current .sic program from memory
SUB New.Program
 ' erase/redimension program code array
 ERASE Program
 REDIM Program(1 TO Max.Lines) AS STRING
END SUB

' stops the Sic engine
SUB Quit.Program
 LineFeed = False
 IF SaveOnExit THEN
    CALL Save.Current
 END IF
 CALL Key.Prompt
 CALL End.Program
 CALL Decrease.PSP
 PRINT "Exiting to system.."
 END
END SUB

' loads a program from disk
SUB Read.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 DO WHILE NOT EOF(1)
    LINE INPUT #1, Out2
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
          IF Line.Number > False AND Line.Number <= Max.Lines THEN
             Program(Line.Number) = MID$(Out2, Imbedded)
             EXIT FOR
          END IF
       END IF
    NEXT
 LOOP
 CLOSE
END SUB

' gets standard input .sic file
SUB Read.Stdin
 ' check standard input
 InregsX.AX = &H600
 InregsX.DX = &HFF
 CALL InterruptX(&H21, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    EXIT SUB
 END IF

 ' reset run type
 Program.Resume = 1
 CALL New.Program

 ' loop while reading input
 DO

    ' read character from standard input
    Char$ = CHR$(OutregsX.AX AND &HFF)
    IF ASC(Char$) = 0 THEN
       InregsX.AX = &H600
       InregsX.DX = &HFF
       CALL InterruptX(&H21, InregsX, OutregsX)
       Char$ = CHR$(0) + CHR$(OutregsX.AX AND &HFF)
    END IF

    ' determine character type
    SELECT CASE ASC(Char$)
    CASE 0, 10, 26
    CASE 13
       FOR Blanks = 1 TO LEN(White.Space)
          Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
          IF Imbedded THEN
             Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
             IF Line.Number > False AND Line.Number <= Max.Lines THEN
                Program(Line.Number) = MID$(Out2, Imbedded + 1)
                EXIT FOR
             END IF
          END IF
       NEXT
       Out2 = Nul
    CASE ELSE
       Out2 = Out2 + Char$
    END SELECT

    ' check standard input
    InregsX.AX = &H600
    InregsX.DX = &HFF
    CALL InterruptX(&H21, InregsX, OutregsX)
    IF (OutregsX.Flags AND &H40) = &H40 THEN
       EXIT DO
    END IF
 LOOP

 ' run stdin program
 CALL Run.Program(False)
 CALL Decrease.PSP
 END
END SUB

' renumbers current .sic program
SUB Renumber.Program(Start.Value, Increment.Value)
 IF Start.Value = False OR Increment.Value = False THEN
    COLOR White, Black
    PRINT "Starting line number";
    INPUT Start.Line
    PRINT "Increment value";
    INPUT Increment
 ELSE
    Start.Line = Start.Value
    Increment = Increment.Value
 END IF
 Start.Line = INT(Start.Line)
 IF Start.Line <= False THEN
    PRINT "Bad start line value."
    EXIT SUB
 END IF
 IF Start.Line > Max.Lines THEN
    PRINT "Bad start line value."
    EXIT SUB
 END IF
 Increment = INT(Increment)
 IF Increment <= False THEN
    PRINT "Bad increment value."
    EXIT SUB
 END IF
 IF Increment > INT(Max.Lines / 2) THEN
    PRINT "Bad increment value."
    EXIT SUB
 END IF
 DO
    Temp.Filename$ = TempName$
    Filename = Temp.Filename$ + ".sc1"
    IF DIR$(Filename) = Nul THEN
       EXIT DO
    END IF
 LOOP
 CALL Store.Program
 CALL Count.Lines(Last.Line)
 REDIM Renumber.List(1 TO Max.Lines) AS INTEGER
 New.Line.Number = Start.Line
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF New.Line.Number > Max.Lines THEN
	  COLOR White, Black
	  PRINT "Renumber list exceeds"; STR$(Max.Lines); " lines."
	  ERASE Renumber.List
	  EXIT SUB
       END IF
       Renumber.List(New.Line.Number) = Line.Number
       New.Line.Number = New.Line.Number + Increment
    END IF
 NEXT
 PRINT "Renumbering program.."
 FOR Line.Number = 1 TO Last.Line
    New.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = STRIM$(Old.Program.Line$)
    Old.Program.Line$ = TTRIM$(Old.Program.Line$, True)
    IF Old.Program.Line$ <> Nul THEN
       Line.Renumbered = True
       IF UCASE$(LEFT$(Old.Program.Line$, 7)) = "RESTORE" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "RESTORE") + 7
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 8)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 4)) = "GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 5)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 13)) = "ON ERROR GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 14)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 6)) = "RESUME" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 15)) <> "RESUME PREVIOUS" THEN
	     IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME SAME" THEN
		IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME NEXT" THEN
		   Line.Renumbered = False
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "RESUME") + 6
                   GOSUB Next.Space
		   Number$ = MID$(Old.Program.Line$, 7)
		   Number$ = STRIM$(Number$)
		   Old.Line.Number = INT(VAL(Number$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 5)) = "GOSUB" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 6)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 2)) = "ON" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 8)) <> "ON ERROR" THEN
	     Line.Renumbered = False
             IF INSTR(UCASE$(Old.Program.Line$), "GOTO") THEN
                Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
                Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                GOSUB Next.Space
                New.Program.Line1$ = Next.Program.Line$
                Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOTO")
                Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 4)
		DO
                   Imbedded1 = INSTR(Old.Number1$, ",")
                   IF Imbedded1 THEN
                      New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                      Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
		   ELSE
                      New.Number1$ = Old.Number1$
                      Old.Number1$ = Nul
		   END IF
                   IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                      Imbedded = 1
                      New.Program.Line$ = New.Number1$
                      GOSUB Next.Space
                      New.Number1$ = Next.Program.Line$
                   ELSE
                      New.Number1$ = Nul
                   END IF
                   Imbedded2 = INSTR(Old.Number2$, ",")
                   IF Imbedded2 THEN
                      New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                      Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
		   ELSE
                      New.Number2$ = Old.Number2$
                      Old.Number2$ = Nul
		   END IF
		   Line.Renumbered = False
                   Old.Line.Number = INT(VAL(New.Number2$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
                   IF Old.Number2$ = Nul THEN
		      EXIT DO
		   END IF
		   IF Line.Renumbered = False THEN
		      EXIT DO
		   END IF
		LOOP
                IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                   New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                END IF
                Program(Line.Number) = New.Program.Line1$
	     ELSE
                IF INSTR(UCASE$(Old.Program.Line$), "GOSUB") THEN
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
                   Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                   GOSUB Next.Space
                   New.Program.Line1$ = Next.Program.Line$
                   Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOSUB")
                   Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 5)
                   DO
                      Imbedded1 = INSTR(Old.Number1$, ",")
                      IF Imbedded1 THEN
                         New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                         Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
                      ELSE
                         New.Number1$ = Old.Number1$
                         Old.Number1$ = Nul
                      END IF
                      IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                         Imbedded = 1
                         New.Program.Line$ = New.Number1$
                         GOSUB Next.Space
                         New.Number1$ = Next.Program.Line$
                      ELSE
                         New.Number1$ = Nul
                      END IF
                      Imbedded2 = INSTR(Old.Number2$, ",")
                      IF Imbedded2 THEN
                         New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                         Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
                      ELSE
                         New.Number2$ = Old.Number2$
                         Old.Number2$ = Nul
                      END IF
                      Line.Renumbered = False
                      Old.Line.Number = INT(VAL(New.Number2$))
                      IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                         FOR New.Line.Number = 1 TO Max.Lines
                            IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                               New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                               Line.Renumbered = True
                               EXIT FOR
                            END IF
                         NEXT
                      END IF
                      IF Old.Number2$ = Nul THEN
                         EXIT DO
                      END IF
                      IF Line.Renumbered = False THEN
                         EXIT DO
                      END IF
                   LOOP
                   IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                      New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                   END IF
                   Program(Line.Number) = New.Program.Line1$
                END IF
	     END IF
	  END IF
       END IF
       IF Line.Renumbered = False THEN
	  COLOR White, Black
          PRINT "Error renumbering program: line";Line.Number
          Filename = Temp.Filename$ + ".sc1"
	  CALL Read.Program
	  COLOR White, Black
	  PRINT "Program reloaded."
          KILL Filename
	  ERASE Renumber.List
	  EXIT SUB
       END IF
    END IF
 NEXT
 PRINT "Resequencing line numbers.."
 Filename = Temp.Filename$ + ".sc1"
 CALL Store.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 CALL New.Program
 WHILE NOT EOF(1)
    LINE INPUT #1, New.Program.Line$
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(New.Program.Line$, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          EXIT FOR
       END IF
    NEXT
    Old.Line.Number = INT(VAL(LEFT$(New.Program.Line$, Imbedded - 1)))
    FOR New.Program.Line = 1 TO Max.Lines
       IF Renumber.List(New.Program.Line) = Old.Line.Number THEN
          Program(New.Program.Line) = MID$(New.Program.Line$, Imbedded)
	  EXIT FOR
       END IF
    NEXT
 WEND
 CLOSE
 COLOR White, Black
 PRINT "Program renumbered."
 KILL Filename
 ERASE Renumber.List
 EXIT SUB
' locates string with following white spaces
Next.Space:
 Next.Program.Line$ = New.Program.Line$
 DO
    IF Imbedded >= LEN(Next.Program.Line$) THEN
       EXIT DO
    END IF
    IF INSTR(White.Space, MID$(Next.Program.Line$, Imbedded + 1, 1)) THEN
       Imbedded = Imbedded + 1
    ELSE
       EXIT DO
    END IF
 LOOP
 Next.Program.Line$ = LEFT$(Next.Program.Line$, Imbedded)
 RETURN
END SUB

' starts current .sic program
SUB Run.Program(Start.Line)
 ' close any files
 CLOSE

 ' try to release any memory
 X! = FRE(-1)
 X! = FRE("A")

 ' store current drive/directory
 CurrentDirectory = CURDIR$

 ' restore run variables
 DataLine = 1
 DataNumber = False
 ErrorLine = False
 ErrorType = False
 ErrorValue = False
 Nested.Gosub = False
 Max.Gosubs = 10
 ScreenMode = False
 Visible = 1
 REDIM GosubReturn(1 TO 10) AS INTEGER
 FOR Count1 = 1 TO 26
    Variables(Count1) = Dfalse
    Strngs(Count1) = Nul
    FOR Count2 = 1 TO Max.Arrays
       Arrays(Count1, Count2) = Dfalse
    NEXT
 NEXT
 FOR Count1 = 1 TO Max.Functions
    Definitions(Count1) = Nul
 NEXT
 CALL Prepare.Program
 CALL Count.Lines(Last.Line)
 Program.Line = False
 IF Start.Line > False THEN
    IF Start.Line <= Last.Line THEN
       IF LEN(STRIM$(Program(Start.Line))) THEN
          Program.Line = Start.Line - 1
       ELSE
          ERROR 145
          EXIT SUB
       END IF
    ELSE
       ERROR 145
       EXIT SUB
    END IF
 END IF
 COLOR Plain, Black
Statement.Loop:
 Program.Line = Program.Line + 1
 IF Program.Line > Last.Line THEN
    GOTO Statement.End
 END IF
 IF Program.Line > Max.Lines THEN
    GOTO Statement.End
 END IF
 Out2 = STRIM$(Program(Program.Line))
 IF LEN(Out2) THEN
    CALL Enter.Equate
 END IF
 GOTO Statement.Loop
Statement.End:
 CALL End.Program
 Program.Line = Max.Lines
 CALL New.Program

 ' restore current drive/directory
 CHDRIVE CurrentDirectory
 CHDIR CurrentDirectory

 ' read original program
 Filename = Prepare.Filename
 CALL Read.Program
 KILL Prepare.Filename
END SUB

' prompts to store current .sic program
SUB Save.Current
 IF Program.Name <> "<none>" THEN
    CALL More.Prompt("Save current program(y/n)?", "yn", Output.Char$)
    IF Output.Char$ = "y" THEN
       CALL Save.Program(Nul)
    END IF
 END IF
END SUB

' stores current .sic program
SUB Save.Program(Temp.Name$)
 DO
    DO
       IF Temp.Name$ = Nul Then
          COLOR White, Black
          PRINT "Program name to save";
          IF Program.Name <> "<untitled>" THEN
             COLOR White, Black
             PRINT "("; Program.Name; ")";
          END IF
          INPUT Program.File$
       ELSE
          Program.File$ = Temp.Name$
       END IF
       IF Program.File$ = Nul THEN
	  IF Program.Name <> "<untitled>" THEN
             Program.File$ = Program.Name
	     EXIT DO
	  END IF
       ELSE
          Program.File$ = STRIM$(Program.File$)
          Program.File$ = LCASE$(Program.File$)
          IF RIGHT$(Program.File$, 4) = ".sic" THEN
             Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
          END IF
	  EXIT DO
       END IF
    LOOP
    Program.File$ = LEFT$(Program.File$, 8)
    Filename = Program.File$ + ".sic"
    IF Temp.Name$ = Nul THEN
       COLOR White, Black
       PRINT "Save program as "; CHR$(34); Filename; CHR$(34);
       CALL More.Prompt("(y/n/q)?", "ynq", Output.Char$)
    ELSE
       Output.Char$ = "y"
    END IF
    SELECT CASE Output.Char$
    CASE "y"
       IF Temp.Name$ = Nul THEN
          Output.Char$ = "y"
          IF DIR$(Filename) <> Nul THEN
             PRINT "Program already exists. ";
             CALL More.Prompt("Overwrite(y/n)?", "yn", Output.Char$)
          END IF
       ELSE
          Output.Char$ = "y"
       END IF
       IF Output.Char$ = "y" THEN
          Program.Name = Program.File$
	  CALL Store.Program
	  COLOR White, Black
          PRINT "Program "; CHR$(34); Filename; CHR$(34); " saved to disk."
	  EXIT DO
       END IF
    CASE "q"
       COLOR White, Black
       PRINT "Program not saved to disk."
       EXIT DO
    END SELECT
 LOOP
END SUB

' writes out the current .sic program to file
SUB Store.Program
 CLOSE
 OPEN Filename FOR OUTPUT AS #1
 CALL Count.Lines(Last.Line)
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF INSTR(White.Space, LEFT$(ProgramLine$, 1)) THEN
          PRINT #1, MID$(STR$(Line.Number), 2) + ProgramLine$
       ELSE
          PRINT #1, MID$(STR$(Line.Number), 2) + " " + ProgramLine$
       END IF
    END IF
 NEXT
 CLOSE
END SUB

' immediate parsing prompt.
SUB Whatis.Command(What.Value$)
 ErrorLine = False
 ErrorType = False
 ErrorValue = False
 Nested.Gosub = False
 Max.Gosubs = 10
 REDIM GosubReturn(1 TO 10) AS INTEGER
 FOR Count1 = 1 TO 26
    Variables(Count1) = Dfalse
    Strngs(Count1) = Nul
    FOR Count2 = 1 TO Max.Arrays
       Arrays(Count1, Count2) = Dfalse
    NEXT
 NEXT
 FOR Count1 = 1 TO Max.Functions
    Definitions(Count1) = Nul
 NEXT
 IF LEN(What.Value$) THEN
    Program.Line = False
    Out2 = TTRIM$(What.Value$, True)
    CALL Enter.Equate
    IF LineFeed THEN
       PRINT
    END IF
 ELSE
    DO
       Program.Line = False
       COLOR White, Black
       LINE INPUT ":", Out2
       IF UCASE$(Out2) = "QUIT" THEN
          EXIT DO
       END IF
       IF Out2 = Nul THEN
          PRINT "Type 'Quit' to exit Whatis mode."
       ELSE
          Out2 = TTRIM$(Out2, True)
          CALL Enter.Equate
          IF LineFeed THEN
             PRINT
          END IF
       END IF
    LOOP
 END IF
 CALL End.Program
 COLOR White, Black
 PRINT "Whatis mode ended."
END SUB

' prepares program for analyze/run command
SUB Prepare.Program
 ' write out current program
 DO
    Temp.Filename$ = TempName$
    Filename = Temp.Filename$ + ".sc2"
    IF DIR$(Filename) = Nul THEN
       EXIT DO
    END IF
 LOOP
 Prepare.Filename = Filename
 CALL Store.Program

 ' concatenate line continuation statements, remove continued lines.
 Program.Line = False
 CALL Count.Lines(Last.Line)
Count.Start1:
 Program.Line = Program.Line + 1
 IF Program.Line > Last.Line THEN
    GOTO Count.End1
 END IF
 IF Program.Line > Max.Lines THEN
    GOTO Count.End1
 END IF
 First.Line = Program.Line
 Out2 = STRIM$(Program(Program.Line))
 IF LEN(Out2) THEN
    DO
       IF RIGHT$(Out2, 1) = "_" THEN
          WHILE RIGHT$(Out2, 1) = "_"
             Out2 = LEFT$(Out2, LEN(Out2) - 1)
          WEND
          FOR Next.Line = Program.Line + 1 TO Last.Line
             Out3 = STRIM$(Program(Next.Line))
             IF LEN(Out3) THEN
                Out2 = Out2 + Out3
                Program.Line = Next.Line
                Program(Next.Line) = Nul
                EXIT FOR
             END IF
          NEXT
       ELSE
          EXIT DO
       END IF
       Out2 = STRIM$(Out2)
    LOOP
    Program(First.Line) = Out2
 END IF
 GOTO Count.Start1
Count.End1:

 ' compress program array,
 ' replaces all white spaces with single space,
 ' replaces all double spaces with single space.
 Program.Line = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Program(Program.Line) = TTRIM$(Out2, True)
    ELSE
       Program(Program.Line) = Nul
    END IF
 NEXT

 ' remove remark at end of line,
 ' search for end of matching double quotes
 ' which might contain an apostrophe.
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Start.Char = 1
Next.Quotes:
       Quote.Start = False
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = CHR$(34) THEN
             Quote.Start = Temp
             EXIT FOR
          END IF
       NEXT
       IF Quote.Start THEN
          Quote.Stop = False
          FOR Temp2 = Quote.Start + 1 TO LEN(Out2)
             IF MID$(Out2, Temp2, 1) = CHR$(34) THEN
                Quote.Stop = Temp2
                EXIT FOR
             END IF
          NEXT
          IF Quote.Stop THEN
             Start.Char = Quote.Stop + 1
             GOTO Next.Quotes
          END IF
       END IF
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = "'" THEN
             Out2 = LEFT$(Out2, Temp - 1)
             EXIT FOR
          END IF
       NEXT
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
          Program(Program.Line) = Out2
       ELSE
          Program(Program.Line) = "REM"
       END IF
    END IF
 NEXT
END SUB

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
FUNCTION TTRIM$(Var$, Var)
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          MID$(VarX$, Temp, 1) = " "
       END IF
    NEXT
 LOOP
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    IF MID$(VarX$, Temp, 2) = "  " THEN
       VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
       Temp = Temp - 1
    END IF
 LOOP
 TTRIM$ = VarX$
END FUNCTION

' strips leading/trailing white spaces from string
FUNCTION STRIM$(Var$)
 XVar$ = Var$
 FOR Count = 1 TO LEN(White.Space)
    DO
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = MID$(XVar$, 2)
       ELSE
	  EXIT DO
       END IF
    LOOP
    DO
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
       ELSE
	  EXIT DO
       END IF
    LOOP
 NEXT
 STRIM$ = XVar$
END FUNCTION

' returns a randomized temporary filename.
' could be constructed from Date/Time.
FUNCTION TempName$
 Var$ = Nul
 FOR Temp = 1 TO 8
    Var$ = Var$ + LTRIM$(STR$(INT(RND*9+1)))
 NEXT
 TempName$ = Var$
END FUNCTION

 ' declares all Sic statements on left side of equation,
 ' each statement listed contains its own subroutine.
 ' listed in rows of ten.
Program.Data:
 DATA "'","ENDIF","END IF","STOP","REM","MID$","LEFT$","RIGHT$","PRINT #","DPRINT"
 DATA "LPRINT","SPRINT","UPRINT","INPUT;","FORIF","FOR","NEXTIF","NEXT","CONTINUE FORIF","CONTINUE FOR"
 DATA "EXIT FORIF","EXIT FOR","DO UNTIL","LOOP WHILE","EXIT DO","CONTINUE DO","GOTO","GOSUB","RETURN","DO WHILE"
 DATA "DO","OFF","IF","ELSEIF","CASEIF ELSE","CASEIF","SELECT CASE","END SELECTIF","BEEP","SOUND"
 DATA "COLOR","LOCATE","CLS","SCREEN","WIDTH","WRITE #","LINE INPUT;","LINE INPUT #","INPUT #","WEND"
 DATA "WHILE","CONTINUE WHILE","EXIT WHILE","ELSE","LOOP UNTIL","LOOPIF","END LOOPIF","EXIT LOOPIF","LOOP","RANDOMIZE"
 DATA "POKE","INT86","DEFSEG","ABSOLUTE","OUT","WAIT","SLEEP","PAUSE","SELECTIF CASE","END SELECT"
 DATA "CASE ELSE","CASE","CONTINUE LOOPIF","END","CLEAR","SYSTEM","SWAP","ERROR","ON ERROR GOTO","ON ERROR RESUME PREVIOUS"
 DATA "ON ERROR RESUME SAME","ON ERROR RESUME NEXT","ON ERROR STOP","RESUME PREVIOUS","RESUME SAME","RESUME NEXT","RESUME","ON","DATE$","TIME$"
 DATA "CHDRIVE","CD","CHDIR","MD","MKDIR","RD","RMDIR","KILL","DELETE","RENAME"
 DATA "NAME","SHELL","CHAIN","LET","CLOSE #","OPEN #","FIELD #","WRITE","PRINT","INPUT"
 DATA "LINE INPUT","LSET #","RSET #","PUT #","GET #","READ #","DATA","READ","RESTORE","CIRCLE STEP"
 DATA "LINE STEP","PSET","PRESET","PAINT","DRAW","PLAY","GET","PUT","BSAVE","BLOAD"
 DATA "VIEW SCREEN","VIEW","WINDOW SCREEN","WINDOW","CIRCLE","LINE","CLOSE","DEF FN"

 REM  "This program is public domain software written by"
 DATA "Author: Erik Jon Oredson"
 DATA "Email: eoredson@yahoo.com"
 DATA "Url: http://www.rptanet.org/~azathoth/"
 ' -endofprogram-
