 REM file: Sic.inc v6.5a r1.0 - Symbolic Instruction Code; include module.
 REM The public domain DOS programming interpreter.

 REM $DYNAMIC
 DEFINT A-Z

 ' get include files
 REM $INCLUDE: 'bpb.bi'
 REM $INCLUDE: 'dta.bi'
 REM $INCLUDE: 'qbx.bi'
 REM $INCLUDE: 'fat32.bi'

 ' boolean constants
 CONST Dfalse=0#
 CONST Dtrue=-1#
 CONST False=0
 CONST True=-1

 ' color constants
 CONST Black=0
 CONST Plain=7
 CONST Red=12
 CONST White=15
 CONST Yellow=14

 ' constant declarations
 CONST Max.Arrays=128 ' can be changed
 CONST Max.Functions=26 ' can be changed
 CONST Max.Lines=2048 ' can be changed
 CONST MaxCommands=14 ' cannot be changed
 CONST MaxStatements=138 ' cannot be changed
 CONST PublishDate="09/19/2000"
 CONST Nul=""
 CONST Release="1.0"
 CONST Version="6.5a"

 ' global variables
 COMMON SHARED Allow.Alpha AS INTEGER
 COMMON SHARED Allow.Extra AS INTEGER
 COMMON SHARED Array.Size AS INTEGER
 COMMON SHARED Assign AS INTEGER
 COMMON SHARED ASCIZ AS STRING * 260
 COMMON SHARED CaseStrng AS STRING
 COMMON SHARED CaseValue AS DOUBLE
 COMMON SHARED CaseValue1 AS DOUBLE
 COMMON SHARED CaseValue2 AS DOUBLE
 COMMON SHARED CaseValueS1 AS STRING
 COMMON SHARED CaseValueS2 AS STRING
 COMMON SHARED CommandLine AS STRING
 COMMON SHARED CurrentDirectory AS STRING
 COMMON SHARED DataLine AS INTEGER
 COMMON SHARED DataNumber AS INTEGER
 COMMON SHARED DataValue AS DOUBLE
 COMMON SHARED ErrorLine AS INTEGER
 COMMON SHARED ErrorType AS INTEGER
 COMMON SHARED ErrorValue AS INTEGER
 COMMON SHARED ExceptStep AS DOUBLE
 COMMON SHARED ExceptStepIs AS INTEGER
 COMMON SHARED FieldVariable AS INTEGER
 COMMON SHARED Filename AS STRING
 COMMON SHARED FinishFor AS DOUBLE
 COMMON SHARED Last.Line AS INTEGER
 COMMON SHARED Last.Token AS INTEGER
 COMMON SHARED LineFeed AS INTEGER
 COMMON SHARED Max.Gosubs AS INTEGER
 COMMON SHARED Nested.Gosub AS INTEGER
 COMMON SHARED Out2 AS STRING
 COMMON SHARED Out3 AS STRING
 COMMON SHARED Out4 AS STRING
 COMMON SHARED PageLength AS INTEGER
 COMMON SHARED Printing AS INTEGER
 COMMON SHARED PrinterLF AS INTEGER
 COMMON SHARED Prepare.Filename AS STRING
 COMMON SHARED Program.Line AS INTEGER
 COMMON SHARED Program.Name AS STRING
 COMMON SHARED Program.Resume AS INTEGER
 COMMON SHARED Quotes AS INTEGER
 COMMON SHARED StepTo AS DOUBLE
 COMMON SHARED SaveOnExit AS INTEGER
 COMMON SHARED ScreenMode AS INTEGER
 COMMON SHARED StdinInput AS INTEGER
 COMMON SHARED StdinPrompt AS INTEGER
 COMMON SHARED Strng AS STRING
 COMMON SHARED Token AS INTEGER
 COMMON SHARED Token.Index AS INTEGER
 COMMON SHARED Token.List AS STRING
 COMMON SHARED Unless.Branch AS INTEGER
 COMMON SHARED Unless.Value AS DOUBLE
 COMMON SHARED ValueIs AS DOUBLE
 COMMON SHARED Visible AS INTEGER
 COMMON SHARED Var.Seg1 AS STRING
 COMMON SHARED Var.Seg2 AS DOUBLE
 COMMON SHARED White.Space AS STRING
 COMMON SHARED Windows.Detected AS INTEGER

 ' common interrupt registers
 COMMON SHARED AX AS DOUBLE
 COMMON SHARED BX AS DOUBLE
 COMMON SHARED CX AS DOUBLE
 COMMON SHARED DX AS DOUBLE
 COMMON SHARED BP AS DOUBLE
 COMMON SHARED SI AS DOUBLE
 COMMON SHARED DI AS DOUBLE
 COMMON SHARED FL AS DOUBLE
 COMMON SHARED DS AS DOUBLE
 COMMON SHARED ES AS DOUBLE

 ' program areas
 COMMON SHARED Commands() AS STRING ' stores all .sic menu commands
 COMMON SHARED Statements() AS STRING ' stores all .sic program commands

 ' code areas
 COMMON SHARED GosubReturn() AS INTEGER ' stack space for gosubs
 COMMON SHARED Program() AS STRING ' storage space for .sic program

 ' data areas
 COMMON SHARED Arrays() AS DOUBLE ' variable arrays A() to Z()
 COMMON SHARED Strngs() AS STRING ' string variables A$ to Z$
 COMMON SHARED Variables() AS DOUBLE ' variables A to Z
 COMMON SHARED Definitions() AS STRING ' DEF FN functions

 ' subroutine area
 COMMON SHARED Renumber.List() AS INTEGER ' space for renumber subroutine

 ' file areas
 COMMON SHARED Field.Array() AS STRING
 COMMON SHARED File.Fields() AS STRING

 ' graphics areas
 COMMON SHARED Graphics.Screen() AS INTEGER
 COMMON SHARED Var.Seg3() AS INTEGER

 ' declare registers from vbdos.lib
 COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

 ' declare program dta
 COMMON SHARED BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER

 ' declare structures
 COMMON SHARED BPBfile AS BPBtype, ParseDTA AS DTAtype
 COMMON SHARED FAT32struc AS FAT32Type

 ' subroutine declarations
 DECLARE SUB Analyze.Program()
 DECLARE SUB Arith(V$, V1#, V2#)
 DECLARE SUB Assign.End()
 DECLARE SUB Assignment1(V$, V%)
 DECLARE SUB Assignment2(V$, V1%, V2%)
 DECLARE SUB Assignment3(V$, V1$)
 DECLARE SUB Assignment4(V$, V1$)
 DECLARE SUB Count.Lines(V%)
 DECLARE SUB Decrease.PSP()
 DECLARE SUB Display.Error()
 DECLARE SUB End.Program()
 DECLARE SUB Enter.Equate()
 DECLARE SUB Enter.Program.Line()
 DECLARE SUB Equate(V#)
 DECLARE SUB Execute.Command(V$)
 DECLARE SUB Get.Token()
 DECLARE SUB Get.Token2(V%)
 DECLARE SUB Get.Token3()
 DECLARE SUB Get.Token4()
 DECLARE SUB Indent.Program(V%)
 DECLARE SUB Key.Prompt()
 DECLARE SUB Kill.Program(V$)
 DECLARE SUB List.Files(V$)
 DECLARE SUB List.Help()
 DECLARE SUB List.Help.File()
 DECLARE SUB List.Program(V1%, V2%, V3%)
 DECLARE SUB Load.Program(V$)
 DECLARE SUB More.Prompt(V1$, V2$, V$)
 DECLARE SUB New.Program()
 DECLARE SUB Parse.Alphabetic1(V#)
 DECLARE SUB Parse.Alphabetic2(V#)
 DECLARE SUB Parse.Alphabetic3(V#)
 DECLARE SUB Parse.Numeric (V#)
 DECLARE SUB Parse.Quoted()
 DECLARE SUB Parse1(V#)
 DECLARE SUB Parse2(V#)
 DECLARE SUB Parse3(V#)
 DECLARE SUB Parse4(V#)
 DECLARE SUB Parse5(V#)
 DECLARE SUB Parse6(V#)
 DECLARE SUB Parse7(V#)
 DECLARE SUB Parse8(V#)
 DECLARE SUB Parse9(V#)
 DECLARE SUB Prepare.Program()
 DECLARE SUB Quit.Program()
 DECLARE SUB Read.Data.Element(V%)
 DECLARE SUB Read.Program()
 DECLARE SUB Read.Stdin()
 DECLARE SUB Renumber.Program(V1%, V2%)
 DECLARE SUB Run.Program(V%)
 DECLARE SUB Save.Current()
 DECLARE SUB Save.Program(V$)
 DECLARE SUB Store.Program()
 DECLARE SUB Whatis.Command(V$)
 DECLARE FUNCTION STRIM$(V$)
 DECLARE FUNCTION TTRIM$(V$, V%)
 DECLARE FUNCTION TempName$()
