 REM Help.bas v6.4b r1.0 - Symbolic Instruction Code; help module.
 REM The public domain DOS programming interpreter utility.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' backwards compatible for bc 7.1
 REM $INCLUDE: 'bc7.inc'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' initialize variables
 PageLength = 23
 Var$ = ENVIRON$("SICPAGELENGTH")
 IF LEN(Var$) THEN
    Temp# = INT(VAL(Var$))
    IF Temp# > 0# AND Temp# <= 32767# THEN
       PageLength = CINT(Temp#)
    END IF
 END IF

 ' run program from command line
 CALL List.Help
Error.Resume:
 CALL Quit.Program
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 IF POS(0) > 1 THEN
    PRINT
 END IF
 COLOR White, Black
 PRINT "Help utility error";Err
 CALL Key.Prompt
 RESUME Error.Resume

' display help menu
SUB List.Help
 DO
    COLOR White, Black
    PRINT "Help utility SIC v" + Version + " r" + Release + " list:"
    COLOR Yellow, Black
    PRINT "[1]command list"
    PRINT "[2]input prompt editing keys"
    PRINT "[3]general documentation"
    PRINT "[4]formatting information"
    PRINT "[5]screen mode tables"
    PRINT "[6]error code values"
    PRINT "[7]syntax documentation"
    PRINT "[8]boolean syntax/charts"
    PRINT "[9]disclaimer notice"
    CALL More.Prompt("Enter(1-9, Q to quit)?", "123456789q", Output.Char$)
    SELECT CASE Output.Char$
    CASE "1"
       COLOR White, Black
       PRINT "SIC created: " + PublishDate
       COLOR Yellow, Black
       PRINT "ANALYZE  --  checks program structure."
       PRINT "FILES    --  display programs."
       PRINT "INDENT   --  formats current program."
       PRINT "KILL     --  delete program."
       PRINT "LIST     --  display current program."
       PRINT "LOAD     --  read program from disk."
       PRINT "NEW      --  erase current program."
       PRINT "PRINT    --  print current program."
       PRINT "QUIT     --  exit SIC interpreter."
       PRINT "RENUMBER --  renumber program."
       PRINT "RUN      --  start current program."
       PRINT "SAVE     --  store current program."
       PRINT "WHATIS   --  enter immediate mode."
       CALL Key.Prompt
    CASE "2"
       Filename = "sickeys.doc"
       CALL List.Help.File
    CASE "3"
       Filename = "sic.doc"
       CALL List.Help.File
    CASE "4"
       Filename = "sicform.doc"
       CALL List.Help.File
    CASE "5"
       Filename = "sicscrn.doc"
       CALL List.Help.File
    CASE "6"
       Filename = "error.doc"
       CALL List.Help.File
    CASE "7"
       Filename = "syntax.doc"
       CALL List.Help.File
    CASE "8"
       Filename = "boolean.doc"
       CALL List.Help.File
    CASE "9"
       Filename = "disclaim.doc"
       CALL List.Help.File
    CASE "q"
       EXIT DO
    END SELECT
 LOOP
END SUB

' displays a help file
SUB List.Help.File
 CLOSE
 IF DIR$(Filename) = Nul THEN
    PRINT "Helpfile "; CHR$(34); Filename; CHR$(34); " not found."
    EXIT SUB
 END IF
 OPEN Filename FOR INPUT AS #1
 Continuous = False
 Line.Count = False
 DO WHILE NOT EOF(1)
    COLOR Yellow, Black
    LINE INPUT #1, Input.Line$
    PRINT Input.Line$
    IF Continuous = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count = PageLength THEN
	  Line.Count = False
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous = True
	  END SELECT
       END IF
    END IF
 LOOP
 CALL Key.Prompt
END SUB

' prompts for multiple input characters
SUB More.Prompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$; " ";
 Input.Char$ = Nul
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' prompts for a keystroke
SUB Key.Prompt
 COLOR White, Black
 LOCATE , , 1
 PRINT "Press any key to continue:";
 Input.Char$ = Nul
 DO
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       EXIT DO
    END IF
 LOOP
 PRINT
END SUB

' stops the Sic engine
SUB Quit.Program
 LineFeed = False
 CALL End.Program
 PRINT "Exiting to system.."
 END
END SUB

' end of program routine
SUB End.Program
 SCREEN 0
 WIDTH 80, 25
 COLOR Plain, Black
 LOCATE , , , 8, 8
 IF LineFeed THEN
    PRINT
 END IF
 WHILE INKEY$ <> Nul
 WEND
END SUB

