//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCLOCK.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Clock implementation                 |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app
#define uses_colors
#define uses_dc
#define uses_system

#include "PVuses.h"

#ifndef NOCLOCK

class Tclock_monitor: public Titem
{
  public:
#ifndef NOMOUSE
    boolean date;
#endif
    Tclock_monitor( void );
    virtual void set_palette( void );
    virtual void draw( void );
#ifndef NOMOUSE
    virtual void event_handler( Tevent &ev );
#endif
};

static Tclock_monitor *clock_monitor;
static Tidle old_idle_proc;
static int timer_handle=-1;
static char hours;
static char minutes;
static char seconds;
static char day;
static char month;
static char year;

static void clock_refresh( unsigned long time_passed )
{
  static char old_hours = 0;
  static char old_minutes = 0;
  static char old_seconds = 0;
  union REGS r;

  old_idle_proc( time_passed );
  if( !( old_hours & old_minutes ) )
  {
    r.h.ah = 4;
    INTR( 0x1A, &r, &r );
    year = r.h.cl;
    month = r.h.dh;
    day = r.h.dl;
  }
  r.h.ah = 2;
  INTR( 0x1A, &r, &r );
  hours = r.h.ch;
  minutes = r.h.cl;
  seconds = r.h.dh;
  if( ( seconds == old_seconds ) && ( minutes == old_minutes ) && ( hours == old_hours ) ) return;
  old_seconds = seconds;
  old_minutes = minutes;
  old_hours = hours;
  clock_monitor->redraw();
};

Tclock_monitor::Tclock_monitor( void ):
  Titem( 8, 1 )
{
  set_flags( ifSELECTABLE, 0 );
#ifndef NOMOUSE
  date = 0;
#endif
  old_idle_proc = hook_idle( clock_refresh );
}

void Tclock_monitor::set_palette( void )
{
  text_attr = pal_menus.normal;
  bold_attr = ( pal_menus.normal & 0xF0 ) | pal_menus.shortcut;
}

void Tclock_monitor::draw( void )
{
#ifndef NOMOUSE
  if( date )
    txtf( "|b%c%c-%c%c-%c%c", (day>>4)+'0', (day&0x0F)+'0', (month>>4)+'0', (month&0x0F)+'0', (year>>4)+'0', (year&0x0F)+'0' );
  else
#endif
    txtf( "|t%c%c:%c%c:%c%c", (hours>>4)+'0', (hours&0x0F)+'0', (minutes>>4)+'0', (minutes&0x0F)+'0', (seconds>>4)+'0', (seconds&0x0F)+'0' );
}

#ifndef NOMOUSE
void date_off( void )
{
  clock_monitor->date = 0;
  clock_monitor->redraw();
}
#endif

#ifndef NOMOUSE
void Tclock_monitor::event_handler( Tevent &ev )
{
  if( ( ev.code == evMOUSE_DOWN ) && ev.INSIDE )
  {
    cancel_request( timer_handle );
    date = 1;
    redraw();
    call_request( timer_handle, date_off, 18*3 );
    while( get_mouse( ev, evMOUSE_DRAG ) );
    handled( ev );
  }
}
#endif

void __init_clock( void )
{
  clock_monitor = NEW( Tclock_monitor );
  master_modal->put_in( clock_monitor, desktop_xl - 9, 0 );
  timer_handle = alloc_timer();
}

#endif //NOCLOCK
