//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        OPTIONS.H                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Options Manager interface            |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _OPTIONS_H_INCLUDED
#define _OPTIONS_H_INCLUDED

  #define MAX_TOOLS       16
  #define MAX_FILE_PARAMS 8192

/*
COMPILER OPTIONS DEFINES
*/
  //memory models
  #define mmSMALL                1
  #define mmMEDIUM               2
  #define mmCOMPACT              3
  #define mmLARGE                4
  #define mmFLAT_HUGE            5
  //target cpu
  #define cp8086                 1
  #define cp80186                2
  #define cp80286                3
  #define cp80386                4
  #define cp80486                5
  #define cp80586                6
  //code size
  #define cs16BITS               1
  #define cs32BITS               2
  //calling conventions
  #define ccREGISTER             1
  #define ccSTACK                2
  //compiler options
  #define opPRECOMPILE      0x0001 //precompiled headers
  #define opSIGNED_CHARS    0x0002 //signed characters
  #define opENUMS_AS_INTS   0x0004 //treat enums as ints
  #define opUNIQUE          0x0008 //all functions must have unique addresses
  #define opBASE_TYPES      0x0010 //generate function prototypes using base types
  #define opCALLS2GROW      0x0020 //generate calls to grow the stack
  #define opNULLVALID       0x0040 //null points to valid memory
  #define opOUTPUTDECL      0x0080 //output declarations to .def
  #define opINTARGS         0x0100 //promote to int all function args & returns
  #define opLITERALSINCODE  0x0200 //place literals in code segment
  #define opSEPARATESEG     0x0400 //each function in separate segment
  #define opSAVESEGS        0x0800 //save segment regs accross calls
  #define opSYNTAXONLY      0x1000 //syntax check only
  #define opTOUCHSTACK      0x2000 //touch the stack through SS first
  #define opDEBUG_INFO      0x4000 //enable debugging information
  #define opOPTIMIZATIONS   0x8000 //enable optimizations
  //compiler optimizations
  #define opLOOP            0x0001 //loop optimizations
  #define opLOOPUNROLL      0x0002 //loop unrolling optimizations
  #define opREORDER         0x0004 //reorder instructions for best pipeline usage
  #define opCALLRET         0x0008 //call followed by <return> --> <jump>
  #define opRELAX           0x0010 //relax aliasing constraints
  #define opNUMERICALLY     0x0020 //numerically unstable optimizations
  #define opLOWMEM          0x0040 //continue optimizaton if low on memory
  #define opINLINE          0x0080 //inline code for math functions
  #define opCONSISTENT      0x0100 //consistend floating point results
  #define opPENTIUM         0x0200 //optimize floating point for Pentium
  #define opINTRINSIC       0x0400 //expand intrinsic functions inline
  #define opUSER            0x0800 //expand user functions inline
  #define opMULTI_THREAD    0x1000 //OPTION, NOT AN OPTIMIZATION
  #define opDLL             0x2000 //OPTION, NOT AN OPTIMIZATION
  #define opDEFAULT_WIN     0x4000 //OPTION, NOT AN OPTIMIZATION
  #define alBYTE                 1 //byte alignment
  #define alWORD                 2 //word alignment
  #define alDWORD                3 //dword alignment
  #define alQWORD                4 //qword alignment
  #define ofSPEED                1 //optimize for speed
  #define ofSIZE                 2 //optimize for size
  #define ofEFFECTIVITY          3 //optimize for effectivity
  //segments
  #define dsFLOATS               1 //DS floats, e.g. not fixed to DGROUP
  #define dsPEGGED               2 //DS is pegged to DGROUP
  #define dsLOAD                 3 //load DS directly from DGROUP
  #define fsPEGGED          0x0001 //FS pegged to a segment
  #define gsPEGGED          0x0002 //GS pegged to a segment
  #define ssNEQDGROUP       0x0004 //SS != DGROUP
  //floating point instructions
  #define fpCALLS                1 //calls to floating point library
  #define fpEMULATION            2 //inline 80x87 instructions w/ emulation
  #define fpINLINE               3 //inline 80x87 instructions w/o emulation
  #define fp8087                 1 //8087 floating point instructions
  #define fp80287                2 //80287 floating point instructions
  #define fp80387                3 //80387 floating point instructions
  //debugging
  #define doSTACK           0x0001 //stack overflow checks
  #define doOPTIMIZATIONS   0x0002 //disable optimizations
  #define doBROWSING        0x0004 //generate browsing info
  #define doWARN_IS_ERR     0x0008 //treat warnings as errors
  #define sfNEED                 1 //generate traceable stack frames as needed
  #define sfALWAYS               2 //always generate traceable stack frames
  #define dlLINENUMS             1 //line numbers debug info
  #define dlFULL                 2 //full symbolic debug info
  #define dlUNREFERENCED         3 //including unreferencet type names
  #define dfWATCOM               1 //Watcom debug fomat
  #define dfDWARF                2 //Dwarf debug fomat
  #define dfCODEVIEW             3 //Codeview debug fomat
  //exception handling
  #define xhENABLE       0x0001
  #define xhDIRECTCALL   1
  #define xhTABLEDRIVEN  2
  //preprocess files
  #define pfENABLE          0x8000 //enable preprocessor
  #define pfENCRYPT         0x0001 //encrypt identifiers
  #define pfLINE            0x0002 //insert #line directives
  #define pfPRESERVE        0x0004 //preserve comments
  #define pfWRAP            0x0008 //wrap output
  //portability
  #define poANSI                 1 //true ANSI standard C++
  #define poWATCOM               2 //enable Watcom C++ extensions


/*
LINKER OPTIONS DEFINES
*/
  #define mfENABLE          0x0001 //enable map file
  #define mfCOMPILER        0x0002 //compiler-generated symbols in the map
  #define mfMANGLED         0x0004 //mangled names in the map
  #define mfSTATIC          0x0008 //static symbols in the map
  #define mfSEGMENT         0x0010 //segment info in the map


/*
EDITOR OPTIONS DEFINES
*/
  #define efSAVE_STATUS     0x8000
  #define efOPEN_INCLUDE    0x4000


/*
TOOLS ENTRY DEFINES
*/
  #define teCOMPILER    0x0001 //this is a compiler
  #define teTRAP_OUTPUT 0x0002 //trap output to a file
  #define teTRAP_ERRORS 0x0004 //trap output & pass it to a filter program
  #define teTRAP        (teTRAP_OUTPUT|teTRAP_ERRORS)
  #define teDONT_SWAP   0x0008 //don't swap screen
  #define tePROMPT      0x0010 //prompt with full command line before executing
  #define teSAVE_ALL    0x0020 //save all files before executing
  #define teSAVE_CUR    0x0040 //save current file before executing
  #define teLONG_CMD    0x0080 //support long command lines
  #define teMAKE        0x0100 //make project before executing


/*
STRUCTS
*/
  #define BT_COUNT 7
  struct Tbt
  {
    char *title;
    char *key;
  };

  #define TO_COUNT 26
  struct Ttarget_os
  {
    char *title;
    char *key;
  };

  struct Tcompiler_options
  {
    int memory_model;           //mmSMALL..mmHUGE
    int code_size;              //cs16BITS, cs32BITS
    int cpu;                    //cp8086..cp80586
    int calling_conventions;    //ccREGISTER, ccSTACK
    uint build_target;
    uint options;               //opXXXX
    uint optimizations;         //opXXXX
    int alignment;              //alBYTE, alWORD, alDWORD, alQWORD
    int optimize_for;           //ofSPEED, ofSIZE, ofEFFECTIVITY
    int ds_segment;             //dsFLOATS, dsPEGGED, dsLOAD
    uint fsgsss_segments;       //fsPEGGED, gsPEGGED, ssNEQDGROUP
    int fp_instructions;        //fpCALLS, fpEMULATION, fpINLINE
    int fp_portability;         //fp8087, fp80287, fp80387
    uint debug_options;         //doSTACK, doOPTIMIZATIONS, doBROWSING, doWARN_IS_ERR
    int stack_frames;           //sfNEED, sfALWAYS
    int debug_level;            //dlLINENUMS, dlFULL, dlUNREFERENCED;
    int debug_format;           //dfWATCOM, dfDWARF, dfCODEVIEW
    boolean exception_handling;
    int destructions;           //xhDIRECTCALL, xhTABLEDRIVEN
    uint preprocess_options;    //pfENCRYPT, pfLINE, pfPRESERVE, pfWRAP
    int preprocess_wrap;        //wrap columns if wrap specified
    int portability;            //poANSI, poWATCOM
    long far_data_threshold;
    int inline_threshold;
    char warn_level;
    char max_errors;
    char defines[128];          //pre-compile defines
    char other[128];            //additional (user-specified) options
    char code_group_name[33];
    char code_class_name[33];
    char data_segment_name[33];
    char module_name[33];
    char text_segment_name[33];
  };

  struct Tlinker_options
  {
    long stack_size;
    char max_errors;
    uint target_os;
    char other_options[1024];   //memo-handled options
  };

  struct Teditor_options
  {
    uint flags;
    int condense_column;
    int condense_length;
    int  tab_size;
    char extension[_MAX_EXT];
    char cpp_extensions[10*5+1];
    char asm_extensions[10*5+1];
  };

  struct Tdefault_directories
  {
    char include  [_MAX_PATH];
    char library  [_MAX_PATH];
    char objects  [_MAX_PATH];
    char tmp_files[_MAX_PATH];
  };

  struct Ttools_entry
  {
    char path[_MAX_PATH];
    char command_line[128];
    uint shortcut;
    uint options;
    char trap_file[13];
    char title[21];
  };
  #define TTOOLS_ENTRY_SIZE ( sizeof( Ttools_entry ) - 21 )

#endif //_OPTIONS_H_INCLUDED


#ifdef _DECLARE_OPTIONS_H

  Tbt build_target[BT_COUNT] =
  {
    { "Host",       ""        },
    { "DOS",        "dos"     },
    { "Windows",    "windows" },
    { "Windows NT", "nt"      },
    { "OS/2",       "os2"     },
    { "QNX",        "qnx"     },
    { "Netware",    "netware" }
  };

  Ttarget_os target_os[TO_COUNT] =
  {
    { "none",                                ""            },
    { "16-bit DOS",                          "dos"         },
    { "16-bit DOS COM",                      "com"         },
    { "16-bit OS/2",                         "os2"         },
    { "16-bit OS/2 DLL",                     "os2 dll"     },
    { "16-bit QNX",                          "qnx"         },
    { "16-bit Windows 3.x",                  "windows"     },
    { "16-bit Windows 3.x DLL",              "windows_dll" },
    { "32-bit AutoCAD Development System",   "ads"         },
    { "32-bit AutoCAD Device Interface",     "eadi"        },
    { "32-bit DOS/4GW",                      "dos4g"       },
    { "32-bit PMODE/W",                      "pmodew"      },
    { "32-bit FlashTek",                     "x32r"        },
    { "32-bit Novell NLM",                   "netware"     },
    { "32-bit OS/2",                         "os2v2"       },
    { "32-bit OS/2 DLL",                     "os2v2 dll"   },
    { "32-bit OS/2 Presentation Manager",    "os2v2_pm"    },
    { "32-bit Phar Lap",                     "pharlap"     },
    { "32-bit Phar Lap TNT",                 "tnt"         },
    { "32-bit QNX",                          "qnx386"      },
    { "32-bit Extended Windows 3.x EXE/DLL", "win386"      },
    { "32-bit Windows 95",                   "win95"       },
    { "32-bit Windows 95 DLL",               "win95 dll"   },
    { "32-bit Windows NT Character-mode",    "nt"          },
    { "32-bit Windows NT Windowed",          "nt_win"      },
    { "32-bit Windows NT DLL",               "nt_dll"      }
  };

  Tcompiler_options compiler_options =
  {
  /* memory_model        = */ mmFLAT_HUGE,
  /* code_size           = */ cs32BITS,
  /* cpu                 = */ cp80586,
  /* calling_conventions = */ ccREGISTER,
  /* build_target        = */ 0,
  /* options             = */ 0,
  /* optimizations       = */ opLOOP|opREORDER|opCALLRET|opRELAX|opNUMERICALLY|opPENTIUM|opINTRINSIC,
  /* alignment           = */ alBYTE,
  /* optimize_for        = */ ofSPEED,
  /* ds_segment          = */ dsPEGGED,
  /* fsgsss_segments     = */ 0,
  /* fp_instructions     = */ fpEMULATION,
  /* fp_portability      = */ fp80387,
  /* debug_options       = */ doSTACK|doOPTIMIZATIONS,
  /* stack_frames        = */ sfNEED,
  /* debug_level         = */ dlFULL,
  /* debug_format        = */ dfWATCOM,
  /* exception_handling  = */ 0,
  /* destructions        = */ xhDIRECTCALL,
  /* preprocess_options  = */ 0,
  /* preprocess_wrap     = */ 0,
  /* portability         = */ poWATCOM,
  /* far_data_threshold  = */ 32767,
  /* inline_threshold    = */ 10,
  /* warn_level          = */ 2,
  /* max_errors          = */ 20,
  /* defines             = */ { 0 },
  /* other               = */ { 0 },
  /* code_group_name     = */ { '*', 0 },
  /* code_class_name     = */ { '*', 0 },
  /* data_segment_name   = */ { '*', 0 },
  /* module_name         = */ { '*', 0 },
  /* text_segment_name   = */ { '*', 0 }
  };

  Tlinker_options linker_options =
  {
  /* stack_size          = */ 4096,
  /* max_erors           = */ 20,
  /* target_os           = */ 10,
  /* other_options       = */ "option eliminate"
  };

  Teditor_options editor_options =
  {
  /* flags               = */ efAUTO_INDENT|efPROMPT_ON_REPLACE|efSAVE_STATUS|efOPEN_INCLUDE,
  /* condense_column     = */ 0,
  /* condense_length     = */ 3,
  /* tab_size            = */ 8,
  /* extension           = */ ".CPP",
  /* cpp_extensions      = */ ".CPP;.C;.H",
  /* asm_extensions      = */ ".ASM;.INC"
  };

  Tdefault_directories default_directories =
  {
  /* include             = */ { 0 },
  /* library             = */ { 0 },
  /* objects             = */ { 0 },
  /* tmp_files           = */ { 0 }
  };

  boolean options_changed = 0;
  Tlb_list *ot_tools = NULL;
  char options_filename[_MAX_PATH] = "";
  char short_options_filename[21] = "";

#else

  extern Tbt build_target[BT_COUNT];
  extern Ttarget_os target_os[TO_COUNT];
  extern Tcompiler_options compiler_options;
  extern Tlinker_options linker_options;
  extern Teditor_options editor_options;
  extern Tdefault_directories default_directories;
  extern boolean options_changed;
  extern Tlb_list *ot_tools;
  extern char options_filename[_MAX_PATH];
  extern char short_options_filename[21];

#endif

void options_fast( void );
void options_compiler_code_generation( void );
void options_compiler_advanced_code_generation( void );
void options_compiler_target( void );
void options_compiler_segment_registers( void );
void options_compiler_floating_point( void );
void options_compiler_debugging( void );
void options_compiler_exceptions_handling( void );
void options_compiler_optimizations( void );
void options_compiler_messages( void );
void options_compiler_preprocess_files( void );
void options_compiler_names( void );
void options_linker( void );
void options_editor( void );
void options_directories( void );
void options_tools( void );
void expand_command_line( char *command_line, char *file, char *result );
int exec_tool( uint tool, char *file );
void options_file_changed( char *filename );
boolean load_options( char *filename, boolean show_error );
void options_open( void );
void options_save( void );
void options_save_as( void );
