//******************************************************************************
// PLC: EXECUTOR                                                              **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef PLC_EXEC_H
	#define PLC_EXEC_H

	#include "Adept.H"
	#include "PLC_Main.H"

//**************************************
// GLOBAL CONSTANTS

	enum
	{
		PLC_FLOW_NORMAL,
		PLC_FLOW_CONTINUE,PLC_FLOW_BREAK,
		PLC_FLOW_RETURN,
		PLC_FLOW_GOTO,
	};

//**************************************
// GLOBAL VARIABLES

	#undef GLOBAL
	#ifdef PLC_EXEC_C
		#define GLOBAL
	#else
		#define GLOBAL	extern
	#endif

	GLOBAL	PLC_DATATYPE	PLC_Result;
	GLOBAL	byte			PLC_FlowStatus;
	GLOBAL	PLC_TOKEN		*PLC_GotoToken;
	GLOBAL	void	(*PLC_ExecKeyword)(PLC_TOKEN *,flag *);
	GLOBAL	void	(*PLC_ApplyOperator)(byte,PLC_DATATYPE *,PLC_DATATYPE *);

//**************************************
// GLOBAL	ROUTINE PROTOTYPES

	// EXECUTION
	void	PLC_Execute			(byte *RoutineName,LNK_LINK *ParmList,PLC_DATATYPE *Result);
	void	PLC_Evaluate		(byte *SourceBuf,PLC_DATATYPE *Result);

	// ADVANCED
	PLC_TOKEN	*PLC_LabelSearch	(byte *Name);
	void	PLC_ExecExpression		(LNK_LINK *TokenList);
	void	PLC_ExecStatement		(PLC_TOKEN *Token,flag *IfResultPtr);
	void	PLC_ExecBlock			(PLC_TOKEN *Token);
	PLC_VARIABLE	*PLC_VariableSearch	(PLC_SYMBOL *Symbol);
	PLC_ROUTINE		*PLC_RoutineSearch	(PLC_SYMBOL *Symbol);
#endif

