//******************************************************************************
// DATA LIBRARY: LINKED LISTS                                                 **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef DAT_LINK_H
	#define DAT_LINK_H

	#include "Adept.H"

//**************************************
// GLOBAL CONSTANTS

	// Use when the link is not the first element of a structure (not recommended)
	#define LNK_ADJUST_PTR(Link,Type,Member)	((void*)( ((byte*)Link) - offsetof((Type),(Member)) ))

	// LINK
	struct LNK_LINK
	{
		struct LNK_LINK	*Prev,*Next;
		flag			Anchor;
	};
	typedef struct LNK_LINK LNK_LINK;

//**************************************
// GLOBAL ROUTINES

	void	LNK_AnchorInit		(LNK_LINK *Anchor);
	void	LNK_LinkInit		(LNK_LINK *Link);
	void	LNK_AddAfter		(LNK_LINK *OrigLink,LNK_LINK *Link);	// inits link automatically
	void	LNK_AddBefore		(LNK_LINK *OrigLink,LNK_LINK *Link);	// inits link automatically
	void	LNK_MoveAfter		(LNK_LINK *OrigLink,LNK_LINK *Link);
	void	LNK_MoveBefore		(LNK_LINK *OrigLink,LNK_LINK *Link);
	void	LNK_Remove			(LNK_LINK *Link);
	void	LNK_Relocate		(LNK_LINK *Link,void *OldLinkPos);
	void	*LNK_Next			(LNK_LINK *Link);
	void	*LNK_Prev			(LNK_LINK *Link);

	#pragma intrinsic(LNK_Next,LNK_Prev)

#endif
