#ifndef __cx_font__
#define __cx_font__

#include "petal.h"

class Font {
  private:
    unsigned char header[0x90];         // the font's header
    char *font_width;                   // an array of character widths
    char *font_data;                    // the actual font data
    short *font_offset;                 // character offsets into the font data
    //float scale;                        // the scale of the font
    int  numer, denom;
    int  chars;                         // the number of characters in the font
    int  first_char;                    // the first character of the font
    int  to_top, to_bottom, to_descender;  // some vertical font size info
    signed int  x, y;                   // used to track the current position when rendering
    int  col;                           // the colour of the font
    int isbold;
  public:
    Font(void);

    void load(char *fname);
    void outtextxy(int x, int y, char *string, Image *img = petal.default_image, int len = 0);
    int  length(char *string);
    int  height(void) { return (int)((to_top + 3) * numer / denom ) + isbold; }
    void scale(int numerator, int denominator) { numer = numerator; denom = denominator; }
    void points(int size) { numer = size; denom = to_top + 3; }
    void colour(int c) { col = c; }
    void bold(bool yesno) { if(yesno) isbold = 2; else isbold = 1; }
    void thick_line(int x1, int y1, int x2, int y2, int c, int thickness, Image *img = petal.default_image);
};

#endif
