/* dice.cc
 * 1998/03/19
 * Jeff Weeks
 *
 * This is a program that was actually writting for Finite class.  It
 * will graph the result of 'n' rolls of a pair of dice to assure us
 * of the expected curve.
 */

/* standard ANSI includes */
#include <stdlib.h>
#include <stdio.h>

/* this program uses my PETAL graphics library */
#include "petal/petal.h"
#include "petal/font.h"
#include "petal/pcx.h"

/* the PETAL DOS drivers */
#include "petal/drivers/lfb.h"
#include "petal/drivers/pmode.h"
#include "petal/drivers/banked.h"

void get_period(void);
void roll(void);
int  get_text(int x, int y, char *str, int maxlen);
void setup(void);
void shutdown(void);

int TEXT, SHINE, BG, SHADOW;    /* the GUI colours */
Font *med, *small;              /* the GUI fonts */
Image *img;                     /* a plain yellow image for the bars */
Pcx *bg;                        /* the background PCX image */
char num[20];                   /* a temporary string for converting numbers to strings */
int inc_every;                  /* increment one pixel every 'n' rolls */
int period;                     /* how many times to roll the dice */
int done;                       /* a done flag.  When set, the program exits */
int total[11];                  /* total of each dice roll */
int inc[11];                    /* increment of each roll sense last update */

int main(void) {
  /* startup petal */
  setup();

  /* the main loop */
  while(!done) {
    get_period();
    roll();
  }

  /* close up PETAL and remove our image from memory */
  shutdown();
}

void get_period(void) {
  /* redisply the background image */
  show_image(bg->img);

  /* draw the GUI elements */
  get_text(10,180,num,10);

  /* get a integer value to know how many times to roll the dice */
  period = atoi(num);
  inc_every = 1;
}

void roll(void) {
  int i, c, d1, d2, tot;
  int bar_height;
  char label[100];

  if(period == 0) {
    done = 1;
    return;
  }

  /* roll all the dice... */
  for(i = 0; i <= period; i++) {
    /* provide a quick exit (press any key) for slow graphs */
    if(get_key()) {
      /* remember reset the total and increments before exiting */
      for(c = 0; c < 11; c++) {
        inc[c] = 0;
        total[c] = 0;
      }
      return;
    }

    /* simulate rolling of two individual dice */
    d1 = rand() % 6 + 1; d2 = rand() % 6 + 1;

    /* take the total of the dice rolls.  I subtract two for array addressing
       reasons. In other words, array subscript 0 will hold the information
       for rolls of total 2, while 1 will hold information for rolls of total
       3 and so on.*/
    tot = (d1 + d2) - 2;

    /* increase the total and increment values.  Total contains the total
       number of times each dice roll has been rolled.  The increment holds
       how many times each roll has been rolled sense the last update. */
    total[tot]++; inc[tot]++;

    /* if the bar is above the screen, double the increment value, thereby
       decreasing the scale of the graph.  Also remember to redraw the screen */
    if( (total[tot] / inc_every) > 150) {
      inc_every *= 2;
      show_image(110, 30, 210, 150, bg->img);
      for(c = 0; c < 11; c++) {
        bar_height = total[c] / inc_every;
        show_image(110+(c*18), 180-bar_height, 10, bar_height);
      }
    }

    /* show the columns */
    for(c = 0; c < 11; c++) {
      /* but only if it's incremented enough to be visible at the
         current scale */
      if(inc[c] >= inc_every) {
        bar_height = total[c] / inc_every;
        show_image(110+(c*18), 180-bar_height, 10, bar_height);
        inc[c] = 0;
      }
    }

    /* show a white percentage bar */
    filled_rect(110,10,310,20, colour(1,1,1));
    sprintf(label, "%d%%", i * 100 / period);
    small->colour(TEXT);
    small->outtextxy(120,18,label);
    show_image(110, 10, i * 200 / period, 10);
  }

  /* now reset the total and increments after done */
  for(c = 0; c < 11; c++) {
    inc[c] = 0;
    total[c] = 0;
  }

  /* wait for a key before the next roll */
  while(get_key() == 0);
}

/* A little input function for graphics modes.  It will include up to
   maxlen characters at location (x,y).  If there is already a valid
   string in s, it will be supplied as the default string. */
int get_text(int x, int y, char *s, int maxlen) {
  char temp[500], letter[] = { "X" };                   /* temporary strings */
  int done = 0, pos = 0, c;				/* done flag, current length, character */
  int px = x, py = y + (small->height() - 3);           /* the current position of the cursor */
  int width  = (maxlen * small->length("W"));
  int height = (small->height());

  /* draw the text area */
  filled_rect(x, y, x + width, y + height, BG);
  hline(x - 1, x + width  + 1, y - 1, SHADOW);
  vline(y - 1, y + height + 1, x - 1, SHADOW);
  hline(x - 1, x + width  + 1, y + height + 1, SHINE);
  vline(y - 1, y + height + 1, x + width  + 1, SHINE);
  show_image(x-1, y-1, width+2, height+2);

  /* display the current text */
  small->colour(TEXT);
  for(c = 0; c < strlen(s); c++) {
    temp[pos] = (char)s[c];                             /* store the letter */
    letter[0] = (char)s[c];                             /* copy it into a string.. */
    small->outtextxy(px,py,letter);                     /* ... and print it */
    px += small->length("W");                           /* the move on to the next letter */
    pos++;
  }

  while(!done) {					                        /* while enter hasn't been pressed */
    small->colour(TEXT);                                /* select the right colour */
    small->outtextxy(px,py,"_");			/* draw a simulated cursor */
    show_image(x, y, width, height);                    /* copy the current string to the screen */
    while( (c = get_key()) == 0);			/* get a character */
    small->colour(BG);                                  /* change to background colour */
    small->outtextxy(px,py,"_");			/* and erase the cursor */


    if(c == 13 || c == 9) {				/* if enter or tab is pressed end string input */
      done = 1;
      break;
    }

    if(c == 8 && pos != 0) {			        /* backspace only if not on first char */
      backspace:
	/* erase the old character */
        filled_rect(px - small->length("W") - 2, py, px, py - small->height(), BG);
	pos--;              			         /* set back position */
	px -= small->length("W");			 /* set back cursor position */
	goto skipover;				         /* dont display character (can't see backspace anyway) */
    }
    if(c == 8) goto skipover;			        /* don't print backspace to string (above only works if pos != 0) */

    if(pos != maxlen && c > 30 && c < 128) {            /* don't add new characters unless they're valid and there's room */
      temp[pos] = (char)c;				/* store the character in temp string */
      small->colour(TEXT);                              /* change font colour to foreground */
      letter[0] = (char)c;                              /* store the character in a one character string... */
      small->outtextxy(px,py,letter);                   /* and print it (outtextxy needs a string) */
      px += small->length("W");				/* add the maximum length for a spacing (uni-spaced) */
      pos++;						/* increase to the next letter */
    }

    skipover:
    ;
  }

  finished:
  temp[pos] = '\0';					/* null terminate the string */
  strcpy(s, temp);					/* copy it to s (parameter passed to get_text) */
  return pos;						/* return the length of the string */
}



void setup(void) {
  int max_x, max_y, size, bpp, i, pos;

  /* Initialize PETAL - my graphics library.  Use any of the following
     drivers.  The first one is a Linux X11 external driver. */
  if(init_petal("./video.driver", "Finite Program..."))
  if(init_petal(&lfb_driver, ""))
  if(init_petal(&pmode_driver, ""))
  if(init_petal(&banked_driver, "")) {
    printf("Error initializing graphics system\n");
    exit(1);
  }

  /* open up a 320x200 window, in 256 colour mode */
  if(set_resolution(320,200,8)) {
    printf("Error setting graphics mode\n");
    exit(1);
  }

  /* Check the mode information */
  size = get_resolution(&max_x, &max_y, &bpp);
  printf("Running at %dx%dx%d\n", max_x, max_y, bpp);
  printf("%ld colours\n", max_col+1);

  /* load in the background PCX and display it */
  bg = new Pcx;
  bg->load("./bg.pcx");
  set_pal(bg->palette);
  set_image(bg->img);

  /* load in the fonts and set up their properties */
  med = new Font;
  med->load("./fonts/tscr.chr");
  med->colour( colour(1,1,1) );
  med->points(12);

  small = new Font;
  small->load("./fonts/litt.chr");
  small->colour( colour(0,0,0) );

  /* display the numbers on it, centered underneath the columns */
  for(i = 0; i < 11; i++) {
    sprintf(num, "%d", i+2);
    pos = 110+(i*18); if(i+2 > 9) pos -= 3;
    med->outtextxy(pos, 195, num);
  }

  /* display the instructions on the side bar */
  small->colour( colour(0,0,0) );
  small->outtextxy(1, 10,  " Enter the ");
  small->outtextxy(1, 20,  "number of dice ");
  small->outtextxy(1, 30,  "to roll, press ");
  small->outtextxy(1, 40,  "enter and a ");
  small->outtextxy(1, 50,  "graph will be ");
  small->outtextxy(1, 60,  "created.");
  small->outtextxy(1, 70,  " To cancel the ");
  small->outtextxy(1, 80,  "current graph, ");
  small->outtextxy(1, 90,  "simply press a ");
  small->outtextxy(1, 100, "key.");
  /*
  small->colour( colour(1,1,1) );
  small->outtextxy(2, 11,  "Just enter the ");
  small->outtextxy(2, 21,  "number of dice ");
  small->outtextxy(2, 31,  "to roll, press ");
  small->outtextxy(2, 41,  "enter and a ");
  small->outtextxy(2, 51,  "graph will be ");
  small->outtextxy(2, 61,  "created.");
  small->outtextxy(2, 71,  "To cancel the ");
  small->outtextxy(2, 81,  "current graph, ");
  small->outtextxy(2, 91,  "simply press a ");
  small->outtextxy(2, 101, "key.");
  */

  small->outtextxy(10, 175, "# of rolls: ");

  show_image();

  /* create an image */
  img = new_image();
  if(img == NULL) {
    printf("Couldn't allocate image data\n");
    exit(1);
  }

  /* set it to default, and clear it to yellow (the bar colour) */
  set_image(img);
  clear( colour(1,1,0) );

  /* setup the GUI colours */
  TEXT   = colour(0.0, 0.0, 0.0);
  SHINE  = colour(1.0, 1.0, 1.0);
  BG     = colour(0.8, 0.8, 0.8);
  SHADOW = colour(0.4, 0.4, 0.4);

  /* the default number of rolls to make */
  strcpy(num,"100");
  return;
}



void shutdown(void) {
  deinit_petal();
  delete_image(img);
  delete bg;
}
