
/*--------------------------------------------------------------------------
 *
 *	MOUKEY v1.0 for C/C++
 *	Mouse routines
 *
 *	MOUSE.C: Source code
 *
 *	May 1997
 *
 *	Copyright (c) 1997 Tanescu A. Horatiu
 *	Author's address: alpha@lego.soroscj.ro
 *
 *	Written and compiled under Borland C++ Version 3.1.
 *
 *	Permission is granted to incorporate any or all code and
 *	information contained in this file into other programs
 *	provided that proper credit is given to Tanescu A. Horatiu.
 *
 *--------------------------------------------------------------------------
 *
 *	Revision history:
 *      1.0	May 1997	Initial coding.
 *
 */

#include "mouse.h"
#include <dos.h>

#define INT_MOUSE		0x33		// mouse software interrupt

// Use TASM
// #pragma inline

int mouseInstalled;
int mouseX, mouseY;
unsigned int mouseButtonCount;
int mouseButtons;

int mouseReset(void)
{
  asm	xor	ax, ax
  asm	int     INT_MOUSE
  asm	mov	mouseButtonCount, bx
  asm	mov	mouseInstalled, ax
  return (_AX);
}

void mouseShow(void)
{
  asm	mov	ax, 0x0001
  asm	int	INT_MOUSE
}

void mouseHide(void)
{
  asm	mov	ax, 0x0002
  asm	int	INT_MOUSE
}

int mouseRead(void)
{
  asm	mov	ax, 0x0003
  asm	int	INT_MOUSE
  asm	mov	mouseX, cx
  asm	mov	mouseY, dx
  asm	mov	ax, bx
  asm	mov	mouseButtons, ax
  return (_AX);
}

void mouseTo(int x, int y)
{
  asm	mov	cx, x
  asm	mov	dx, y
  asm	mov	ax, 0x0004
  asm	int	INT_MOUSE
}

int mouseGetDown(int button, int* lastx, int* lasty)
{
  asm	mov	bx, button
  asm	mov	ax, 0x0005
  asm	int	INT_MOUSE
  asm	push	bx
  asm	mov     mouseButtons, ax
  *lastx = _CX;
  *lasty = _DX;
  asm	pop	ax
  return (_AX);
}

int mouseGetUp(int button, int* lastx, int* lasty)
{
  asm	mov	bx, button
  asm	mov	ax, 0x0006
  asm	int	INT_MOUSE
  asm	push	bx
  asm	mov     mouseButtons, ax
  *lastx = _CX;
  *lasty = _DX;
  asm	pop	ax
  return (_AX);
}

void mouseSetXRange(int minc, int maxc)
{
  asm	mov	cx, minc
  asm	mov	dx, maxc
  asm	mov	ax, 0x0007
  asm	int	INT_MOUSE
}

void mouseSetYRange(int minr, int maxr)
{
  asm	mov	cx, minr
  asm	mov	dx, maxr
  asm	mov	ax, 0x0008
  asm	int	INT_MOUSE
}

void mouseSetGraphicCursor(graphcursor *gc)
{
  union  REGS inregs, outregs;
  struct SREGS segregs;

  inregs.x.ax = 0x0009;
  inregs.x.bx = gc->gc_hotx;
  inregs.x.cx = gc->gc_hoty;
  inregs.x.dx = FP_OFF(gc->gc_masks);
  segregs.es  = FP_SEG(gc->gc_masks);
  int86x(INT_MOUSE, &inregs, &outregs, &segregs);
}

void mouseSetTextCursor(int scrmask, int curmask)
{
  asm	mov	cx, scrmask
  asm	mov	dx, curmask
  asm	xor	bx, bx
  asm	mov	ax, 0x000A
  asm	int	INT_MOUSE
}

void mouseSetHardCursor(int firstln, int lastln)
{
  asm	mov	cx, firstln
  asm	mov	dx, lastln
  asm	mov	bx, 0x0001
  asm	mov	ax, 0x000A
  asm	int	INT_MOUSE
}

void mouseReadMove(int* xmoves, int* ymoves)
{
  asm	mov	ax, 0x000B
  asm	int	INT_MOUSE
  *xmoves = _CX;
  *ymoves = _DX;
}

void mouseSetHandler(int mask, mousehandler handler)
{
  asm	les	dx, [handler]
  asm	mov	cx, mask
  asm	mov	ax, 0x000C
  asm	int	INT_MOUSE
}

void mouseLightPenEmulationOn(void)
{
  asm	mov	ax, 0x000D
  asm	int	INT_MOUSE
}

void mouseLightPenEmulationOff(void)
{
  asm	mov	ax, 0x000E
  asm	int	INT_MOUSE
}

void mouseSetMickeyRatio(int x, int y)
{
  asm	mov	cx, x
  asm	mov	dx, y
  asm	mov	ax, 0x000F
  asm	int	INT_MOUSE
}

void mouseSetUpdateRegion(int left, int top, int right, int bottom)
{
  asm	mov	cx, left
  asm	mov	dx, top
  asm	mov	si, right
  asm	mov	di, bottom
  asm	mov	ax, 0x0010
  asm	int	INT_MOUSE
}

int mouseLargeGraphCursor(largegraphcursor *lgc)
{
  union  REGS inregs, outregs;
  struct SREGS segregs;

  inregs.x.ax = 0x0012;
  inregs.h.ch = lgc->lgc_height;
  inregs.h.cl = lgc->lgc_hoty;
  inregs.h.bh = lgc->lgc_width;
  inregs.h.bl = lgc->lgc_hotx;
  inregs.x.dx = FP_OFF(lgc->lgc_masks);
  segregs.es  = FP_SEG(lgc->lgc_masks);
  return (int86x(INT_MOUSE, &inregs, &outregs, &segregs));
}

void mouseSetThreshold(int threshold)
{
  asm	mov	dx, threshold
  asm	mov	ax, 0x0013
  asm	int	INT_MOUSE
}

#define MAKELONG(low, high) ((unsigned long)(((unsigned int)(low)) | (((unsigned long)((unsigned int)(high))) << 16)))

mousehandler mouseExchangeHandler(int mask, mousehandler handler, int* oldmask)
{
  asm	les	dx, [handler]
  asm	mov	cx, mask
  asm	mov	ax, 0x0014
  asm	int	INT_MOUSE
  asm	push	es
  asm	push	dx
  *oldmask = _CX;
  asm	pop	ax
  asm	pop	dx
  return ((mousehandler)MAKELONG(_AX, _DX));
}

int mouseDriverStateSize(void)
{
  asm	mov	ax, 0x0015
  asm	int	INT_MOUSE
  return (_BX);
}

void mouseSaveDriverState(int bufsize, void* buf)
{
  _ES = FP_SEG(buf);
  _DX = FP_OFF(buf);
  asm	mov	bx, bufsize
  asm	mov	ax, 0x0016
  asm	int	INT_MOUSE
}

void mouseRestoreDriverState(int bufsize, void* buf)
{
  _ES = FP_SEG(buf);
  _DX = FP_OFF(buf);
  asm	mov	bx, bufsize
  asm	mov	ax, 0x0017
  asm	int	INT_MOUSE
}

int mouseSetAlternateHandler(int mask, mousehandler handler)
{
  asm	les	dx, [handler]
  asm	mov	cx, mask
  asm	mov	ax, 0x0018
  asm	int	INT_MOUSE
  asm	cmp	ax, 0x0018
  asm	jne	Error
  return (1);
Error:
  return (0);
}

mousehandler mouseGetAlternateHandler(int mask)
{
  asm	mov	cx, mask
  asm	mov	ax, 0x0019
  asm	int	INT_MOUSE
  asm	or	cx, cx
  asm	je	Error
  return ((mousehandler)MAKELONG(_DX, _BX));
Error:
  return (0);
}

void mouseSetSensitivity(int horiz, int vert, int threshold)
{
  asm	mov	bx, horiz
  asm	mov	cx, vert
  asm	mov	dx, threshold
  asm	mov	ax, 0x001A
  asm	int	INT_MOUSE
}

void mouseGetSensitivity(int *horiz, int *vert, int *threshold)
{
  union     REGS regs;

  regs.x.ax  = 0x001B;
  int86(INT_MOUSE, &regs, &regs);
  *horiz     = regs.x.bx;
  *vert      = regs.x.cx;
  *threshold = regs.x.dx;
}

void mouseSetInterruptRate(int rate)
{
  asm	mov	bx, rate
  asm	mov	ax, 0x001C
  asm	int	INT_MOUSE
}

void mouseSetPage(int page)
{
  asm	mov	bx, page
  asm	mov	ax, 0x001D
  asm	int	INT_MOUSE
}

int mouseGetPage(void)
{
  asm	mov	ax, 0x001E
  asm	int	INT_MOUSE
  return (_BX);
}

void far* mouseDisable(void)
{
  asm	mov	ax, 0x001F
  asm	int	INT_MOUSE
  asm	cmp	ax, 0x001F
  asm	je	Error
  return ((void far*)MAKELONG(_BX, _ES));
Error:
  return (0);
}

int mouseEnable(void)
{
  asm	mov	ax, 0x0020
  asm	int	INT_MOUSE
  asm	cmp	ax, 0x0020
  asm	je	Error
  return (1);
Error:
  return (0);
}

int mouseSoftReset(void)
{
  asm	mov	ax, 0x0021
  asm	int	INT_MOUSE
  asm	cmp	ax, 0x0021
  asm	je	Error
  asm	mov	mouseButtonCount, bx
  asm	mov	mouseInstalled, ax
  return (_AX);
Error:
  asm	xor	ax, ax
  asm	mov	mouseInstalled, ax
  return (_AX);
}

void mouseSetLanguage(int language)
{
  asm	mov	bx, language
  asm	mov	ax, 0x0022
  asm	int	INT_MOUSE
}

int mouseGetLanguage(void)
{
  asm	mov	ax, 0x0023
  asm	int	INT_MOUSE
  return (_BX);
}

unsigned mouseGetInfo(mouse_info *info)
{
  union     REGS regs;
  void far* temp;

  regs.x.ax = 0x0024;
  int86(INT_MOUSE, &regs, &regs);
  info->majorver  = regs.h.bh;
  info->minorver  = regs.h.bl;
  info->mousetype = regs.h.ch;
  info->IRQ       = regs.h.cl;

  asm	mov	ax, 0x0034
  asm	int	INT_MOUSE
  temp = MK_FP(_ES, _DX);
  info->inifile   = (char far*)temp;

  asm	mov	ax, 0x004D
  asm	int	INT_MOUSE
  temp = MK_FP(_ES, _DI);
  info->copyright = (char far*)temp;

  asm	mov	ax, 0x006D
  asm	int	INT_MOUSE
  temp = MK_FP(_ES, _DI);
  info->version   = (char far*)temp;

  asm	mov	ax, 0x0025
  asm	int	INT_MOUSE
  return (_AX);
}

int mouseMinX(void)
{
  asm	mov	ax, 0x0031
  asm	int	INT_MOUSE
  return (_AX);
}

int mouseMinY(void)
{
  asm	mov	ax, 0x0031
  asm	int	INT_MOUSE
  return (_BX);
}

int mouseMaxX(void)
{
  asm	mov	ax, 0x0031
  asm	int	INT_MOUSE
  return (_CX);
}

int mouseMaxY(void)
{
  asm	mov	ax, 0x0031
  asm	int	INT_MOUSE
  return (_DX);
}

void mouseGetMaxXY(int *minx, int *miny, int *maxx, int *maxy)
{
  union     REGS regs;

  regs.x.ax = 0x0031;
  int86(INT_MOUSE, &regs, &regs);
  *minx     = regs.x.ax;
  *miny     = regs.x.bx;
  *maxx     = regs.x.cx;
  *maxy     = regs.x.dx;
}

void mouseGetHotSpot(int *hotspotx, int *hotspoty)
{
  union     REGS regs;

  regs.x.ax = 0x002A;
  int86(INT_MOUSE, &regs, &regs);
  *hotspotx = regs.x.bx;
  *hotspoty = regs.x.cx;
}

char mouseState(void)
{
  asm	mov	ax, 0x002A
  asm	int	INT_MOUSE
  return (_AL);
}